/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.dl;

import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.EdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.decorators.VertexStringer;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.DirectedSparseVertex;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.visualization.ISOMLayout;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import org.compbiollab.algorithms.GraphAlgorithms;
import org.enfin.squad.bl.GraphEdge;
import org.enfin.squad.bl.IEdge;

public class NetIO {
    public static Graph load(String fileName) {
        DirectedSparseGraph theGraph = new DirectedSparseGraph();
        BufferedReader inputData = null;
        try {
            inputData = new BufferedReader(new FileReader(fileName));
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        try {
            String line;
            while ((line = inputData.readLine()) != null) {
                Pattern regEx = Pattern.compile("(^\\S+)\\s+(-[>|])\\s+(\\S+).*$");
                Matcher lineToParse = regEx.matcher(line);
                if (!lineToParse.matches()) continue;
                Vector existingVertices = new Vector(theGraph.getVertices());
                Vector namesOfNodes = new Vector();
                namesOfNodes = GraphAlgorithms.getNamesOfVertices(existingVertices, theGraph);
                String nameOfFromVertex = lineToParse.group(1).trim().replace(" ", "_");
                Vertex fromVertex = null;
                if (namesOfNodes.contains(nameOfFromVertex)) {
                    fromVertex = GraphAlgorithms.getNodeByName((Graph)theGraph, nameOfFromVertex);
                } else {
                    fromVertex = theGraph.addVertex((Vertex)new DirectedSparseVertex());
                    fromVertex.addUserDatum((Object)"id", (Object)nameOfFromVertex, UserData.SHARED);
                }
                existingVertices = new Vector(theGraph.getVertices());
                namesOfNodes = new Vector();
                namesOfNodes = GraphAlgorithms.getNamesOfVertices(existingVertices, theGraph);
                String nameOfToVertex = lineToParse.group(3).trim().replace(" ", "_");
                Vertex toVertex = null;
                if (namesOfNodes.contains(nameOfToVertex)) {
                    toVertex = GraphAlgorithms.getNodeByName((Graph)theGraph, nameOfToVertex);
                } else {
                    toVertex = theGraph.addVertex((Vertex)new DirectedSparseVertex());
                    toVertex.addUserDatum((Object)"id", (Object)nameOfToVertex, UserData.SHARED);
                }
                Vector existingEdges = new Vector(theGraph.getEdges());
                if (GraphAlgorithms.edgeExists(theGraph, fromVertex, toVertex)) continue;
                DirectedEdge oneEdge = (DirectedEdge)theGraph.addEdge((Edge)new DirectedSparseEdge(fromVertex, toVertex));
                if (lineToParse.group(2).equals("->")) {
                    oneEdge.addUserDatum((Object)"sign", (Object)"positive", UserData.SHARED);
                } else if (lineToParse.group(2).equals("-|")) {
                    oneEdge.addUserDatum((Object)"sign", (Object)"negative", UserData.SHARED);
                }
                oneEdge.addUserDatum((Object)"source", (Object)nameOfFromVertex, UserData.SHARED);
                oneEdge.addUserDatum((Object)"target", (Object)nameOfToVertex, UserData.SHARED);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            inputData.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return theGraph;
    }

    public static void writeToFile(Graph gr, File outputFile) throws IOException {
        ArrayList<IEdge> edgeList = GraphEdge.getIedgesFromGraph(gr);
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outputFile));
            for (IEdge edg : edgeList) {
                out.write(edg.getDescription().replace("--", "->") + "\n");
            }
            out.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws IOException {
        JFrame mainFrame = new JFrame();
        Graph theGraph = NetIO.load("/home/luis/projects/ModelingSuite/test/Arabidopsis_minimal.net");
        PluggableRenderer theRenderer = new PluggableRenderer();
        StringLabeller theLabeller = StringLabeller.getLabeller((Graph)theGraph);
        theRenderer.setVertexStringer((VertexStringer)theLabeller);
        theRenderer.setVertexLabelCentering(false);
        EdgePaintFunction epf = new EdgePaintFunction(){

            public Paint getDrawPaint(Edge e) {
                if (e.getUserDatum((Object)"sign").equals("positive")) {
                    return Color.GREEN;
                }
                if (e.getUserDatum((Object)"sign").equals("negative")) {
                    return Color.RED;
                }
                return Color.BLACK;
            }

            public Paint getFillPaint(Edge e) {
                return null;
            }
        };
        theRenderer.setEdgePaintFunction(epf);
        VisualizationViewer vv = new VisualizationViewer((Layout)new ISOMLayout(theGraph), (Renderer)theRenderer);
        mainFrame.getContentPane().add((Component)vv);
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.pack();
        mainFrame.setVisible(true);
    }
}

