/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.dl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.table.TableModel;

public class VectorTools {
    public static Vector transpose(Vector theMatrix) {
        Vector transposedData = new Vector();
        int oldNumberOfRows = theMatrix.size();
        int oldNumberOfColumns = ((Vector)theMatrix.elementAt(0)).size();
        for (int i = 0; i < oldNumberOfColumns; ++i) {
            Vector newRow = new Vector();
            for (int j = 0; j < oldNumberOfRows; ++j) {
                newRow.add(((Vector)theMatrix.elementAt(j)).elementAt(i));
            }
            transposedData.add(newRow);
        }
        return transposedData;
    }

    public static Vector reduceDataPointsDensity(Vector originalData, int reducingFactor) {
        Vector output = new Vector();
        int numberOfRows = originalData.size();
        for (int i = 0; i < numberOfRows; ++i) {
            if (i % reducingFactor != 0) continue;
            output.add(originalData.elementAt(i));
        }
        return output;
    }

    public static Vector eliminateOneRow(int rowToEliminate, Vector theMatrix) {
        Vector finalMatrix = new Vector();
        int numberOfRows = theMatrix.size();
        for (int i = 0; i < numberOfRows; ++i) {
            if (i == rowToEliminate) continue;
            finalMatrix.add(theMatrix.elementAt(i));
        }
        return finalMatrix;
    }

    public static Vector eliminateOneColumn(int columnToEliminate, Vector theMatrix) {
        Vector finalMatrix = new Vector(theMatrix);
        finalMatrix = VectorTools.transpose(finalMatrix);
        finalMatrix = VectorTools.eliminateOneRow(columnToEliminate, finalMatrix);
        finalMatrix = VectorTools.transpose(finalMatrix);
        return finalMatrix;
    }

    public static boolean areCircularPermutations(Vector cycleOne, Vector cycleTwo) {
        int i;
        if (cycleOne.size() != cycleTwo.size()) {
            return false;
        }
        if (cycleOne == cycleTwo) {
            return true;
        }
        HashSet setOne = new HashSet(cycleOne);
        HashSet setTwo = new HashSet(cycleTwo);
        if (!setOne.equals(setTwo)) {
            return false;
        }
        int shiftedBy = 0;
        for (int i2 = 0; i2 < cycleTwo.size(); ++i2) {
            if (!cycleOne.elementAt(0).equals(cycleTwo.elementAt(i2))) continue;
            shiftedBy = i2;
            break;
        }
        if (shiftedBy == 0) {
            return false;
        }
        Vector doubledTarget = new Vector(cycleTwo);
        for (i = 0; i < cycleTwo.size(); ++i) {
            doubledTarget.add(cycleTwo.elementAt(i));
        }
        for (i = 0; i < cycleOne.size(); ++i) {
            if (cycleOne.elementAt(i).equals(doubledTarget.elementAt(i + shiftedBy))) continue;
            return false;
        }
        return true;
    }

    public static boolean vectorIsAlreadyIncluded(Vector oneVector, Vector allVectors) {
        for (int i = 0; i < allVectors.size(); ++i) {
            if (!VectorTools.areCircularPermutations(oneVector, (Vector)allVectors.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public static Vector unionOfVectors(Vector theSuperSet) {
        Vector result = new Vector();
        for (int i = 0; i < theSuperSet.size(); ++i) {
            Vector oneVector = (Vector)theSuperSet.get(i);
            for (int j = 0; j < oneVector.size(); ++j) {
                if (result.contains(oneVector.get(j))) continue;
                result.add(oneVector.get(j));
            }
        }
        return result;
    }

    public static Vector nextBinaryState(Vector presentState) {
        Vector<Integer> output = new Vector<Integer>(presentState);
        for (int i = 0; i < output.size(); ++i) {
            int place = output.size() - i - 1;
            if (output.get(place).equals(0)) {
                output.set(place, 1);
                return output;
            }
            output.set(place, 0);
        }
        return output;
    }

    public static Vector nextRelevantBinaryState(Vector presentState, Vector ignoreThesePositions) {
        Vector thePresentState = new Vector(presentState);
        Collections.sort(ignoreThesePositions);
        Vector nextState = new Vector();
        thePresentState = VectorTools.reduceVector(thePresentState, ignoreThesePositions);
        nextState = VectorTools.nextBinaryState(thePresentState);
        nextState = VectorTools.insertZeroesAt(nextState, ignoreThesePositions);
        return nextState;
    }

    public static Vector reduceVector(Vector originalVector, Vector placesToEliminate) {
        Vector<String> theOriginalVector = new Vector<String>(originalVector);
        for (int i = 0; i < placesToEliminate.size(); ++i) {
            Integer place = new Integer(placesToEliminate.get(i).toString());
            theOriginalVector.setElementAt("_X_", place);
        }
        Vector reducedVector = new Vector();
        for (int i = 0; i < theOriginalVector.size(); ++i) {
            if (theOriginalVector.get(i).equals("_X_")) continue;
            reducedVector.add(theOriginalVector.get(i));
        }
        return reducedVector;
    }

    private static Vector insertZeroesAt(Vector originalVector, Vector positions) {
        Vector finalVector = new Vector();
        finalVector = originalVector;
        for (int i = 0; i < positions.size(); ++i) {
            Integer position = new Integer(positions.get(i).toString());
            finalVector.add(position, 0);
        }
        return finalVector;
    }

    public static boolean largerThan(Vector firstVector, Vector secondVector) {
        for (int i = 0; i < firstVector.size(); ++i) {
            Integer value1 = new Integer(firstVector.get(i).toString());
            Integer value2 = new Integer(secondVector.get(i).toString());
            if (value2 >= value1) continue;
            return true;
        }
        return false;
    }

    public static Vector getColumn(Vector theMatrix, int whichColumn) {
        Vector result = new Vector();
        for (int i = 0; i < theMatrix.size(); ++i) {
            Vector oneRow = (Vector)theMatrix.get(i);
            result.add(oneRow.get(whichColumn));
        }
        return result;
    }

    public static Vector tableModelToMatrix(TableModel theModel) {
        int i;
        Vector matrix = new Vector();
        int numberOfColumns = theModel.getColumnCount();
        int numberOfRows = theModel.getRowCount();
        Vector<String> headerColumn = new Vector<String>();
        for (i = 0; i < numberOfColumns; ++i) {
            headerColumn.add(theModel.getColumnName(i));
        }
        matrix.add(headerColumn);
        for (i = 0; i < numberOfRows; ++i) {
            Vector<Object> oneRow = new Vector<Object>();
            for (int j = 0; j < numberOfColumns; ++j) {
                oneRow.add(theModel.getValueAt(i, j));
            }
            matrix.add(oneRow);
        }
        return matrix;
    }

    public static Vector insertOneColumn(int position, Vector column, Vector matrix) {
        Vector result = new Vector();
        for (int i = 0; i < column.size(); ++i) {
            Vector oneRow = new Vector((Vector)matrix.get(i));
            oneRow.add(position, column.get(i));
            result.add(oneRow);
        }
        return result;
    }

    public static Vector convertStringToInteger(Vector theVector) {
        Vector<Integer> result = new Vector<Integer>();
        for (int i = 0; i < theVector.size(); ++i) {
            Integer value = new Integer(theVector.get(i).toString());
            result.add(value);
        }
        return result;
    }

    public static Vector joinVectors(Vector vector1, Vector vector2) {
        int i;
        Vector result = new Vector();
        for (i = 0; i < vector1.size(); ++i) {
            result.add(vector1.get(i));
        }
        for (i = 0; i < vector2.size(); ++i) {
            result.add(vector2.get(i));
        }
        return result;
    }

    public static Vector integerHashToVector(HashMap theHash) {
        if (theHash == null) {
            return null;
        }
        Vector hashKeys = new Vector(theHash.keySet());
        Collections.sort(hashKeys);
        Integer largest = new Integer(hashKeys.lastElement().toString());
        Vector pairs = new Vector();
        for (int i = 0; i <= largest; ++i) {
            Vector<Integer> onePair = new Vector<Integer>();
            if (!theHash.containsKey(i)) {
                onePair.add(i);
                onePair.add(0);
                pairs.add(onePair);
                continue;
            }
            onePair.add(i);
            onePair.add((Integer)theHash.get(i));
            pairs.add(onePair);
        }
        return pairs;
    }

    public static int indexOfLargestValue(Vector theVector) {
        double largestValue = 0.0;
        int index = 0;
        for (int i = 0; i < theVector.size(); ++i) {
            Double presentValue = new Double(theVector.get(i).toString());
            if (!(largestValue <= presentValue)) continue;
            index = i;
            largestValue = presentValue;
        }
        return index;
    }

    public static Vector getZeroMatrix(int numberOfRows, int numberOfColumns) {
        Vector matrix = new Vector();
        for (int i = 0; i < numberOfRows; ++i) {
            Vector<Integer> oneRow = new Vector<Integer>();
            for (int j = 0; j < numberOfColumns; ++j) {
                oneRow.add(0);
            }
            matrix.add(oneRow);
        }
        return matrix;
    }

    public static void setValueOfMatrix(Vector matrix, int row, int column, int value) {
        Vector oneRow = (Vector)matrix.get(row);
        oneRow.setElementAt(value, column);
        matrix.setElementAt(oneRow, row);
    }

    public static void setValueOfMatrix(Vector matrix, int row, int column, double value) {
        Vector oneRow = (Vector)matrix.get(row);
        oneRow.setElementAt(value, column);
        matrix.setElementAt(oneRow, row);
    }

    public static Object getValue(Vector matrix, int row, int column) {
        return ((Vector)matrix.get(row)).get(column);
    }

    public static void fillMatrixWithValue(Vector matrix, double value) {
        int numberOfRows = matrix.size();
        int numberOfColumns = new Vector((Vector)matrix.get(0)).size();
        for (int i = 0; i < numberOfRows; ++i) {
            for (int j = 0; j < numberOfColumns; ++j) {
                VectorTools.setValueOfMatrix(matrix, i, j, value);
            }
        }
    }
}

