/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.guiutils;

import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.w3c.dom.Comment;
import org.w3c.dom.Text;

public class XMLTree
extends JTree {
    private static final long serialVersionUID = 1L;

    public XMLTree(Document doc) {
        super(XMLTree.makeRootNode(doc));
        super.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                if (propertyName == "foreground") {
                    propertyName = "text";
                }
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        });
    }

    private static DefaultMutableTreeNode makeRootNode(Document document) {
        try {
            DefaultMutableTreeNode rootTreeNode = XMLTree.buildTree(document.getRootElement());
            return rootTreeNode;
        }
        catch (Exception e) {
            String errorMessage = "Error making root node: " + e;
            System.err.println(errorMessage);
            e.printStackTrace();
            return new DefaultMutableTreeNode(errorMessage);
        }
    }

    private static DefaultMutableTreeNode buildTree(Element rootElement) {
        DefaultMutableTreeNode rootTreeNode = new DefaultMutableTreeNode(XMLTree.treeNodeLabel(rootElement));
        XMLTree.addChildren(rootTreeNode, rootElement);
        return rootTreeNode;
    }

    private static void addChildren(DefaultMutableTreeNode parentTreeNode, Element parentXMLElement) {
        List childElements = parentXMLElement.getChildren();
        for (int i = 0; i < childElements.size(); ++i) {
            Element childElement = (Element)childElements.get(i);
            if (childElement instanceof Text || childElement instanceof Comment) continue;
            DefaultMutableTreeNode childTreeNode = new DefaultMutableTreeNode(XMLTree.treeNodeLabel(childElement));
            parentTreeNode.add(childTreeNode);
            XMLTree.addChildren(childTreeNode, childElement);
        }
    }

    private static String treeNodeLabel(Element childElement) {
        List elementAttributes = childElement.getAttributes();
        String treeNodeLabel = childElement.getName();
        if (elementAttributes != null && elementAttributes.size() > 0) {
            treeNodeLabel = "<html><font color=blue><B>" + treeNodeLabel + "</B></font>" + " (";
            int numAttributes = elementAttributes.size();
            for (int i = 0; i < numAttributes; ++i) {
                Attribute attribute = (Attribute)elementAttributes.get(i);
                if (i > 0) {
                    treeNodeLabel = treeNodeLabel + ", ";
                }
                treeNodeLabel = treeNodeLabel + attribute.getName() + "=" + "<font color=red><B>" + attribute.getValue().toString() + "</B></font>";
            }
            treeNodeLabel = treeNodeLabel + ")" + "</html>";
        }
        return treeNodeLabel;
    }
}

