/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.perturbations.bl;

import java.util.List;
import org.enfin.squad.bl.AbstractGraphNode;
import org.enfin.squad.dl.GraphContainer;
import org.enfin.squad.guiutils.PropertiesMap;
import org.enfin.squad.perturbations.bl.AbstractGraphAction;

public class GraphActionTimeConstant
extends AbstractGraphAction {
    private static final long serialVersionUID = 1L;
    private String nodeType = "constantpulse";

    public GraphActionTimeConstant(String target, String parameter, Double time, Double newValue) {
        super(target, parameter, newValue);
        this.parameterList.put("target", new PropertiesMap("target", this.getTargetNodeName(), this.getTargetNodeName().getClass()));
        this.parameterList.put("parameter", new PropertiesMap("parameter", parameter, parameter.getClass()));
        this.parameterList.put("time", new PropertiesMap("time", time, time.getClass()));
        this.parameterList.put("value", new PropertiesMap("value", newValue, newValue.getClass()));
    }

    private Double getPerturbationTime() {
        return (Double)this.parameterList.get((Object)"time").value;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void perturbState(List<AbstractGraphNode> nodes, Double time) throws NoSuchFieldException {
        if (time >= this.getPerturbationTime()) {
            AbstractGraphNode targetNode = GraphContainer.getNodeByName(nodes, super.getTargetNodeName());
            if (targetNode == null) {
                throw new NoSuchFieldException("The node was not found for action -> " + this.getDescription());
            }
            this.setModifiableProperty(targetNode, super.getParameter(), super.getPerturbationValue());
        }
    }

    @Override
    public String getDescription() {
        return "Change node:" + super.getTargetNodeName() + " at time=" + this.getPerturbationTime().toString() + " to state=" + super.getPerturbationValue().toString() + " for the rest of the time course";
    }

    @Override
    public String getNodeType() {
        return this.nodeType;
    }

    @Override
    public String getNodeTypeReadable() {
        return "Constant perturbation";
    }
}

