/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.perturbations.bl;

import java.util.List;
import org.enfin.squad.bl.AbstractGraphNode;
import org.enfin.squad.dl.GraphContainer;
import org.enfin.squad.guiutils.PropertiesMap;
import org.enfin.squad.perturbations.bl.AbstractGraphAction;

public class GraphActionTimeRange
extends AbstractGraphAction {
    private static final long serialVersionUID = 1L;
    private String nodeType = "rangepulse";
    boolean isActionTriggered;

    public GraphActionTimeRange(String target, String parameter, Double startTime, Double stopTime, Double newValue) {
        super(target, parameter, newValue);
        this.parameterList.put("timestart", new PropertiesMap("timestart", startTime, startTime.getClass()));
        this.parameterList.put("timestop", new PropertiesMap("timestop", stopTime, stopTime.getClass()));
        this.initialize();
    }

    @Override
    public void initialize() {
        this.isActionTriggered = false;
    }

    private Double getPerturbationTimeStart() {
        return (Double)this.parameterList.get((Object)"timestart").value;
    }

    private Double getPerturbationTimeStop() {
        return (Double)this.parameterList.get((Object)"timestop").value;
    }

    @Override
    public void perturbState(List<AbstractGraphNode> nodes, Double time) throws NoSuchFieldException {
        if (time >= this.getPerturbationTimeStart() && time < this.getPerturbationTimeStop()) {
            AbstractGraphNode targetNode = GraphContainer.getNodeByName(nodes, super.getTargetNodeName());
            if (targetNode == null) {
                throw new NoSuchFieldException("The node was not found for action -> " + this.getDescription());
            }
            super.setModifiableProperty(targetNode, super.getParameter(), super.getPerturbationValue());
            this.isActionTriggered = true;
        }
    }

    @Override
    public String getNodeType() {
        return this.nodeType;
    }

    @Override
    public String getNodeTypeReadable() {
        return "Time Range Perturbation";
    }

    @Override
    public String getDescription() {
        return "Change node:" + super.getTargetNodeName() + " from time=" + this.getPerturbationTimeStart().toString() + " to time=" + this.getPerturbationTimeStop().toString() + " to state=" + super.getPerturbationValue().toString();
    }
}

