/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.perturbations.bl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.compbiollab.dynamicalsystem.Simulator;
import org.enfin.squad.bl.AbstractGraphNode;
import org.enfin.squad.bl.NetworkState;
import org.enfin.squad.bl.NodeValueState;
import org.enfin.squad.bl.ode.ODESystemSolver;
import org.enfin.squad.dl.GraphContainer;
import org.enfin.squad.guiutils.IGUIXMLMappable;
import org.enfin.squad.guiutils.PropertiesMap;
import org.enfin.squad.perturbations.bl.AbstractGraphAction;
import org.enfin.squad.perturbations.bl.GraphActionTimePulse;
import org.jdom.Attribute;
import org.jdom.Element;

public class Perturbator
implements IGUIXMLMappable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(Perturbator.class);
    private NetworkState initialState;
    private Map<String, PropertiesMap> properties = new TreeMap<String, PropertiesMap>();
    private ArrayList<AbstractGraphAction> actionNodes = new ArrayList();

    public static void main(String[] args) {
        Perturbator pert = new Perturbator(new NetworkState("SS1", NodeValueState.createAllInactiveStates(1), new String[]{"A"}), "testPert");
        GraphActionTimePulse gt = new GraphActionTimePulse("C", "state", 10.0, 0.5);
        GraphActionTimePulse gt2 = new GraphActionTimePulse("B", "state", 20.0, 0.5);
        pert.addActionNode(gt);
        pert.addActionNode(gt2);
        try {
            GraphContainer gr = new GraphContainer("samples/2statesMML.mml");
            Simulator theSimulator = new Simulator(gr);
            ODESystemSolver ode = new ODESystemSolver(gr, pert);
            ode.run();
            ode.setStopAtSteadyState(false);
            System.out.println(ode.getResultsAsString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Perturbator(NetworkState initialstate, String perturbationId) {
        this.initialState = initialstate;
        this.getPropertyMaps().put("id", new PropertiesMap("id", perturbationId, perturbationId.getClass()));
        this.getPropertyMaps().put("initialstate", new PropertiesMap("initialstate", initialstate.getId(), initialstate.getId().getClass()));
        this.initialize();
    }

    public void initialize() {
        for (AbstractGraphAction act : this.actionNodes) {
            act.initialize();
        }
    }

    @Override
    public Map<String, PropertiesMap> getPropertyMaps() {
        return this.properties;
    }

    @Override
    public String getNodeType() {
        return "perturbation";
    }

    @Override
    public String getNodeTypeReadable() {
        return "Perturbation";
    }

    public void addActionNode(AbstractGraphAction action) {
        this.actionNodes.add(action);
    }

    public NetworkState getInitialState() {
        return this.initialState;
    }

    public String getInitialStateID() {
        return this.properties.get((Object)"initialstate").value.toString();
    }

    public ArrayList<AbstractGraphAction> getActionNodes() {
        return this.actionNodes;
    }

    public void setActionNodes(ArrayList<AbstractGraphAction> actionNodes) {
        this.actionNodes = actionNodes;
    }

    public void performPerturbation(List<AbstractGraphNode> nodes, Double time) {
        try {
            for (AbstractGraphAction act : this.actionNodes) {
                act.perturbState(nodes, time);
            }
        }
        catch (NoSuchFieldException e) {
            log.error((Object)("perturbation failed: " + this.toString()));
            e.printStackTrace();
        }
    }

    public String getId() {
        return this.properties.get((Object)"id").value.toString();
    }

    @Override
    public Element getXmlElement() {
        Element el = new Element(this.getNodeType());
        for (PropertiesMap prt : this.getPropertyMaps().values()) {
            el.getAttributes().add(new Attribute(prt.propertyName, prt.value.toString()));
        }
        for (AbstractGraphAction act : this.actionNodes) {
            Element child = new Element(act.getNodeType());
            for (PropertiesMap prtChild : act.getPropertyMaps().values()) {
                child.getAttributes().add(new Attribute(prtChild.propertyName, prtChild.value.toString()));
            }
            el.getChildren().add(child);
        }
        return el;
    }

    @Override
    public void addChildMappableObject(Object child) {
        if (child.getClass().getGenericSuperclass().equals(AbstractGraphAction.class)) {
            AbstractGraphAction nt = (AbstractGraphAction)child;
            this.actionNodes.add(nt);
        }
    }
}

