/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.perturbations.bl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.enfin.squad.bl.NetworkState;
import org.enfin.squad.guiutils.IGUIXMLMappable;
import org.enfin.squad.guiutils.PropertiesMap;
import org.enfin.squad.perturbations.bl.Perturbator;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;

public class Protocol
extends ArrayList<Perturbator>
implements IGUIXMLMappable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Map<String, PropertiesMap> properties = new TreeMap<String, PropertiesMap>();
    List<NetworkState> states = new ArrayList<NetworkState>();
    List<Perturbator> perturbations = new ArrayList<Perturbator>();

    public Protocol(List<Perturbator> perts, List<NetworkState> states) {
        this.perturbations = perts;
        this.states = states;
        this.getPropertyMaps().put("level", new PropertiesMap("level", 1.0, Double.class));
    }

    public List<NetworkState> getStates() {
        return this.states;
    }

    public List<Perturbator> getPerturbations() {
        return this.perturbations;
    }

    @Override
    public String getNodeType() {
        return "protocol";
    }

    @Override
    public String getNodeTypeReadable() {
        return "Protocol of perturbations";
    }

    @Override
    public Map<String, PropertiesMap> getPropertyMaps() {
        return this.properties;
    }

    @Override
    public Element getXmlElement() {
        Element pr = new Element(this.getNodeType());
        for (PropertiesMap prt : this.getPropertyMaps().values()) {
            pr.getAttributes().add(new Attribute(prt.propertyName, prt.value.toString()));
        }
        Element allPerurbations = new Element("perturbations");
        for (Perturbator p : this.perturbations) {
            allPerurbations.getChildren().add(p.getXmlElement());
        }
        pr.getChildren().add(allPerurbations);
        Element allStates = new Element("states");
        for (NetworkState st : this.states) {
            allStates.getChildren().add(st.getXmlElement());
        }
        pr.getChildren().add(allStates);
        return pr;
    }

    public Document getXMLDocument() {
        Document dr = new Document(this.getXmlElement());
        return dr;
    }

    @Override
    public void addChildMappableObject(Object child) {
        if (child.getClass().equals(Perturbator.class)) {
            Perturbator nt = (Perturbator)child;
            this.perturbations.add(nt);
        } else if (child.getClass().equals(NetworkState.class)) {
            NetworkState nt = (NetworkState)child;
            this.states.add(nt);
        }
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

