/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.perturbations.pl;

import de.javasoft.plaf.synthetica.SyntheticaStandardLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.EditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import org.bounce.text.xml.XMLEditorKit;
import org.enfin.squad.bl.NetworkState;
import org.enfin.squad.bl.NodeValueState;
import org.enfin.squad.dl.GraphContainer;
import org.enfin.squad.guiutils.IGUIXMLMappable;
import org.enfin.squad.guiutils.XMLTree;
import org.enfin.squad.perturbations.bl.AbstractGraphAction;
import org.enfin.squad.perturbations.bl.Perturbator;
import org.enfin.squad.perturbations.bl.Protocol;
import org.enfin.squad.perturbations.bl.ProtocolFactory;
import org.enfin.squad.perturbations.pl.PerturbationCreatorDialog;
import org.jdesktop.layout.GroupLayout;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class EditFrame
extends JDialog {
    private static final long serialVersionUID = 1L;
    private XMLTree tree;
    private Protocol prot;
    private DefaultMutableTreeNode currentNode;
    private GraphContainer gr;
    private int value = 2;
    private Map<String, ?> currentComboBoxList;
    private JButton butAdd;
    private JButton butCancel;
    private JButton butDelete;
    private JButton butEdit;
    private JButton butSave;
    private JComboBox comboAdd;
    private JEditorPane editText;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JScrollPane pnlScroll;

    public static void main(String[] args) {
        try {
            JFrame mainFrame = new JFrame();
            mainFrame.setVisible(true);
            GraphContainer gr = new GraphContainer("samples/2states.net");
            Protocol prot = ProtocolFactory.generate("samples/2states_perturbation.xml");
            EditFrame fr = new EditFrame(gr, prot);
            fr.setVisible(true);
        }
        catch (HeadlessException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EditFrame() {
        this.initComponents();
        this.setSize(750, 450);
    }

    public EditFrame(GraphContainer gr, Protocol prot) {
        this();
        this.gr = gr;
        this.prot = prot;
        this.setSize(750, 450);
        try {
            this.loadDataOnEditor();
            this.loadViews();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fillAddActionCombo();
    }

    public EditFrame(GraphContainer gr) {
        this();
        try {
            this.gr = gr;
            this.prot = ProtocolFactory.generateDefaultProtocol(gr);
            this.loadDataOnEditor();
            this.loadViews();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fillAddActionCombo();
    }

    public Protocol getProtocol() {
        return this.prot;
    }

    private void editAction() {
        if (this.currentNode != null) {
            if (this.currentNode.getLevel() > 1) {
                IGUIXMLMappable mp = this.retrieveNode(this.currentNode);
                if (mp != null) {
                    PerturbationCreatorDialog pert = new PerturbationCreatorDialog(mp, this.prot, this.gr, this);
                    pert.setVisible(true);
                    this.refreshTree();
                }
            } else {
                JOptionPane.showMessageDialog(null, "This level of the document is not editable", "Edit Node", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "You need to select a node first", "Edit Node", 2);
        }
    }

    private IGUIXMLMappable retrieveNode(DefaultMutableTreeNode nd) {
        if (nd.getLevel() == 2 && nd.toString().contains("perturbation")) {
            int indexInList = nd.getParent().getIndex(nd);
            return this.prot.getPerturbations().get(indexInList);
        }
        if (nd.getLevel() == 2 && nd.toString().contains("state")) {
            int indexInList = nd.getParent().getIndex(nd);
            return this.prot.getStates().get(indexInList);
        }
        if (nd.getLevel() == 3 && nd.getParent().toString().contains("perturbation")) {
            int indexInList = nd.getParent().getIndex(nd);
            int indxPerturbation = nd.getParent().getParent().getIndex(nd.getParent());
            return this.prot.getPerturbations().get(indxPerturbation).getActionNodes().get(indexInList);
        }
        if (nd.getLevel() == 3 && nd.toString().contains("activenode")) {
            NetworkState nt = (NetworkState)this.retrieveNode((DefaultMutableTreeNode)nd.getParent());
            String ndString = nd.toString();
            ndString = ndString.replaceAll("<.*?>|,", "");
            Matcher m = Pattern.compile("id=(.*)\\s|\\)", 128).matcher(ndString);
            if (m.find()) {
                String nodeName = m.group(1);
                return nt.getNode(nodeName);
            }
        } else if (nd.getLevel() == 1) {
            return this.prot;
        }
        return null;
    }

    private void refreshTree() {
        this.loadViews();
    }

    private void loadDataOnEditor() {
        try {
            XMLOutputter xOut = new XMLOutputter(Format.getPrettyFormat());
            StringReader rd = new StringReader(xOut.outputString(this.prot.getXMLDocument()));
            XMLEditorKit kit = new XMLEditorKit(true);
            kit.setWrapStyleWord(true);
            this.editText.setEditorKit((EditorKit)kit);
            this.editText.setFont(new Font("Courier", 0, 12));
            this.editText.getDocument().putProperty("tabSize", new Integer(1));
            this.editText.getDocument().putProperty("autoIndentation", new Boolean(true));
            this.editText.getDocument().putProperty("tagCompletion", new Boolean(true));
            kit.setStyle("attribute-value", Color.red, 1);
            kit.setStyle("element-name", Color.blue, 1);
            this.setSize(new Dimension(650, 500));
            this.editText.setText("");
            this.editText.read(rd, null);
            rd.close();
            this.editText.doLayout();
            this.editText.setEditable(true);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadViews() {
        this.currentNode = null;
        this.tree = new XMLTree(this.prot.getXMLDocument());
        this.pnlScroll.getViewport().add(this.tree);
        this.tree.setRootVisible(false);
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                EditFrame.this.selectionChanged(event);
            }
        });
        this.loadDataOnEditor();
    }

    private void selectionChanged(TreeSelectionEvent event) {
        this.currentNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        this.fillAddActionCombo();
    }

    private void addActionMode() {
        if (this.comboAdd.getItemCount() == 0) {
            return;
        }
        if (this.currentNode != null) {
            IGUIXMLMappable parentObject = this.retrieveNode(this.currentNode);
            IGUIXMLMappable objToAdd = (IGUIXMLMappable)this.currentComboBoxList.get(this.comboAdd.getSelectedItem());
            PerturbationCreatorDialog prt = new PerturbationCreatorDialog(objToAdd, this.prot, this.gr, this);
            prt.setVisible(true);
            if (prt.getValue() == 0) {
                parentObject.addChildMappableObject(objToAdd);
                this.loadViews();
            }
        } else {
            JOptionPane.showMessageDialog(this, "You need to select a parent node first", "Add Node", 2);
        }
    }

    private void deleteNode() {
        IGUIXMLMappable ob = this.retrieveNode(this.currentNode);
        if (ob != null) {
            if (ob.getClass().equals(NetworkState.class)) {
                this.prot.getStates().remove(ob);
            } else if (ob.getClass().equals(NodeValueState.class)) {
                NetworkState nt = (NetworkState)this.retrieveNode((DefaultMutableTreeNode)this.currentNode.getParent());
                nt.getNodeStates().remove(((NodeValueState)ob).getId());
            } else if (ob.getClass().equals(Perturbator.class)) {
                this.prot.getPerturbations().remove(ob);
            } else if (ob.getClass().getGenericSuperclass().equals(AbstractGraphAction.class)) {
                Perturbator pt = (Perturbator)this.retrieveNode((DefaultMutableTreeNode)this.currentNode.getParent());
                pt.getActionNodes().remove(ob);
            }
        }
        this.loadViews();
    }

    private void fillAddActionCombo() {
        this.currentComboBoxList = null;
        this.comboAdd.removeAllItems();
        if (this.currentNode != null) {
            if (this.currentNode.getLevel() > 1) {
                IGUIXMLMappable mp = this.retrieveNode(this.currentNode);
                if (mp == null) {
                    this.comboAdd.setEnabled(false);
                    this.butAdd.setEnabled(false);
                    return;
                }
                if (mp.getClass().equals(Perturbator.class)) {
                    this.currentComboBoxList = ProtocolFactory.getDefaultActions(this.gr);
                } else if (mp.getClass().equals(NetworkState.class)) {
                    this.currentComboBoxList = ProtocolFactory.getDefaultActiveNodeList(this.gr);
                }
            } else if (this.currentNode.toString().equals("perturbations")) {
                List<NetworkState> ntList = this.prot.getStates();
                if (ntList != null && ntList.size() > 0) {
                    this.currentComboBoxList = ProtocolFactory.getDefaultPerturbationList(this.gr, ntList);
                } else {
                    JOptionPane.showMessageDialog(this, "You need to create an initial state before creating a perturbation", "", 1);
                }
            } else if (this.currentNode.toString().equals("states")) {
                this.currentComboBoxList = ProtocolFactory.getDefaultNetworkStateList(this.gr);
            }
        }
        if (this.currentComboBoxList != null && this.currentComboBoxList.size() > 0) {
            for (String title : this.currentComboBoxList.keySet()) {
                this.comboAdd.addItem(title);
            }
            this.comboAdd.setEnabled(true);
            this.butAdd.setEnabled(true);
        } else {
            this.comboAdd.setEnabled(false);
            this.butAdd.setEnabled(false);
        }
    }

    public static void saveToFile(Protocol prt, String perturbatorFileName) throws FileNotFoundException, IOException {
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        FileWriter writer = new FileWriter(perturbatorFileName);
        out.output(prt.getXMLDocument(), (Writer)writer);
        writer.close();
    }

    public int getValue() {
        return this.value;
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.pnlScroll = new JScrollPane();
        this.comboAdd = new JComboBox();
        this.butAdd = new JButton();
        this.butEdit = new JButton();
        this.butDelete = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.editText = new JEditorPane();
        this.jPanel1 = new JPanel();
        this.butCancel = new JButton();
        this.butSave = new JButton();
        this.jScrollPane2.setViewportView(this.jList1);
        this.setDefaultCloseOperation(2);
        this.setTitle("Edit Perturbation Protocol");
        this.setResizable(false);
        this.comboAdd.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.comboAdd.setEnabled(false);
        this.butAdd.setText("Add");
        this.butAdd.setEnabled(false);
        this.butAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditFrame.this.butAddActionPerformed(evt);
            }
        });
        this.butEdit.setText("Edit");
        this.butEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditFrame.this.butEditActionPerformed(evt);
            }
        });
        this.butDelete.setText("Delete");
        this.butDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditFrame.this.butDeleteActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.butDelete, -2, 76, -2).addPreferredGap(0, 108, Short.MAX_VALUE).add((Component)this.butEdit, -2, 73, -2).addPreferredGap(0).add((Component)this.butAdd, -2, 72, -2).addPreferredGap(0).add((Component)this.comboAdd, -2, 141, -2).addContainerGap()).add(2, (Component)this.pnlScroll, -1, 502, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.pnlScroll, -1, 315, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.comboAdd, -2, -1, -2).add((Component)this.butAdd).add((Component)this.butEdit).add((Component)this.butDelete)).addContainerGap()));
        this.jTabbedPane1.addTab("Tree view", this.jPanel2);
        this.editText.setEditable(false);
        this.jScrollPane1.setViewportView(this.editText);
        this.jTabbedPane1.addTab("Text View", this.jScrollPane1);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.butCancel.setText("Cancel");
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditFrame.this.butCancelActionPerformed(evt);
            }
        });
        this.butSave.setText("OK");
        this.butSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditFrame.this.butSaveActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(321, Short.MAX_VALUE).add((Component)this.butCancel, -2, 85, -2).addPreferredGap(0).add((Component)this.butSave, -2, 85, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(16, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.butSave).add((Component)this.butCancel)).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.pack();
    }

    private void butDeleteActionPerformed(ActionEvent evt) {
        this.deleteNode();
    }

    private void butSaveActionPerformed(ActionEvent evt) {
        this.value = 0;
        this.setVisible(false);
    }

    private void butAddActionPerformed(ActionEvent evt) {
        this.addActionMode();
    }

    private void butEditActionPerformed(ActionEvent evt) {
        this.editAction();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.value = 2;
        this.setVisible(false);
    }

    static {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new SyntheticaStandardLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

