/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.perturbations.pl;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.enfin.squad.dl.GraphContainer;
import org.enfin.squad.guiutils.GUIFactory;
import org.enfin.squad.guiutils.IGUIXMLMappable;
import org.enfin.squad.guiutils.PropertiesMap;
import org.enfin.squad.perturbations.bl.GraphActionTimeConstant;
import org.enfin.squad.perturbations.bl.Protocol;
import org.enfin.squad.perturbations.bl.ProtocolFactory;
import org.jdesktop.layout.GroupLayout;

public class PerturbationCreatorDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private GraphContainer gr;
    private IGUIXMLMappable action;
    private int value = 2;
    private Protocol prot;
    private JButton butCancel;
    private JButton butOK;
    private JPanel pnlButtons;
    private JPanel pnlControls;

    public PerturbationCreatorDialog(IGUIXMLMappable action, Protocol prot, GraphContainer gr, JDialog fr) {
        super((Dialog)fr, true);
        this.initComponents();
        this.gr = gr;
        this.action = action;
        this.prot = prot;
        this.createDynamicGUI();
        this.pack();
        this.setLocationRelativeTo(fr);
    }

    public IGUIXMLMappable getMappableObject() {
        return this.action;
    }

    public int getValue() {
        return this.value;
    }

    private void createDynamicGUI() {
        int parameterNumbers = this.action.getPropertyMaps().size();
        this.pnlControls.setLayout(new GridLayout(parameterNumbers, 2, 20, 5));
        this.pnlControls.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.pnlControls.setSize(this.pnlControls.getWidth(), 5 * parameterNumbers);
        for (PropertiesMap pr : this.action.getPropertyMaps().values()) {
            JLabel lb = GUIFactory.getLabel();
            lb.setText(pr.propertyName);
            this.pnlControls.add(lb);
            this.pnlControls.add(GUIFactory.getComponent(pr, this.action, this.prot, this.gr));
        }
    }

    public PerturbationCreatorDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.pnlControls = new JPanel();
        this.pnlButtons = new JPanel();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Edit parameters");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        GroupLayout pnlControlsLayout = new GroupLayout((Container)this.pnlControls);
        this.pnlControls.setLayout((LayoutManager)pnlControlsLayout);
        pnlControlsLayout.setHorizontalGroup((GroupLayout.Group)pnlControlsLayout.createParallelGroup(1).add(0, 242, Short.MAX_VALUE));
        pnlControlsLayout.setVerticalGroup((GroupLayout.Group)pnlControlsLayout.createParallelGroup(1).add(0, 230, Short.MAX_VALUE));
        this.getContentPane().add((Component)this.pnlControls, "Center");
        this.butOK.setText("OK");
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerturbationCreatorDialog.this.butOKActionPerformed(evt);
            }
        });
        this.butCancel.setText("Cancel");
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerturbationCreatorDialog.this.butCancelActionPerformed(evt);
            }
        });
        GroupLayout pnlButtonsLayout = new GroupLayout((Container)this.pnlButtons);
        this.pnlButtons.setLayout((LayoutManager)pnlButtonsLayout);
        pnlButtonsLayout.setHorizontalGroup((GroupLayout.Group)pnlButtonsLayout.createParallelGroup(1).add(2, (GroupLayout.Group)pnlButtonsLayout.createSequentialGroup().addContainerGap().add((Component)this.butCancel, -2, 65, -2).addPreferredGap(0, 83, Short.MAX_VALUE).add((Component)this.butOK, -2, 74, -2).addContainerGap()));
        pnlButtonsLayout.setVerticalGroup((GroupLayout.Group)pnlButtonsLayout.createParallelGroup(1).add((GroupLayout.Group)pnlButtonsLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)pnlButtonsLayout.createParallelGroup(3).add((Component)this.butOK).add((Component)this.butCancel)).addContainerGap()));
        this.getContentPane().add((Component)this.pnlButtons, "South");
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.value = 2;
        this.setVisible(false);
    }

    private void butOKActionPerformed(ActionEvent evt) {
        this.value = 0;
        this.setVisible(false);
    }

    public static void main(String[] args) {
        try {
            final GraphContainer gr = new GraphContainer("samples/2states.net");
            final GraphActionTimeConstant guiMap = new GraphActionTimeConstant("D", "decay", 1.0, 1.0);
            final Protocol prot = ProtocolFactory.generate("samples/2states_perturbation.xml");
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new PerturbationCreatorDialog(guiMap, prot, gr, null).setVisible(true);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

