/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.pl;

import com.tlabs.dcolt.DecoratedDoubleMatrix2D;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaStandardLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;
import org.compbiollab.datavisualization.ReportFrame;
import org.compbiollab.dynamicalsystem.Simulator;
import org.compbiollab.squad2.AppProperties;
import org.enfin.squad.bl.AbstractGraphNode;
import org.enfin.squad.bl.IObservable;
import org.enfin.squad.bl.IObserver;
import org.enfin.squad.dl.FileFilterNetwork;
import org.enfin.squad.dl.FileUtils;
import org.enfin.squad.dl.FileViewNetwork;
import org.enfin.squad.dl.GraphContainer;
import org.enfin.squad.dl.MatrixAsTableModel;
import org.enfin.squad.dl.TabSeparatedDataFile;
import org.enfin.squad.dl.VectorTools;
import org.enfin.squad.perturbations.pl.PerturbationFrame;
import org.enfin.squad.pl.AboutDialog;
import org.enfin.squad.pl.OdeSimulatorPanel;
import org.enfin.squad.pl.PlotFrameDisplay;
import org.jdesktop.layout.GroupLayout;

public class GUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    String inputFile;
    GraphContainer grCont;
    Simulator theSimulator;
    String frameTitle;
    ProgressMonitor prgMon;
    OdeSimulatorPanel odeSimulator;
    private JMenuItem aboutMenu;
    private JMenu advancedMenu;
    private JButton butLoadNetworkGui;
    private JButton butRunAnalysis;
    private JTextField currentBlotDataTextField;
    private JTextField currentNetworkTextField;
    private JTextField currentTimeSeriesTextField;
    private JMenuItem displayManualMenuItem;
    private JPanel dynamicPanel;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JPanel generalInfoPanel;
    private JMenu helpMenu;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JMenuItem loadBlotDataMenuItem;
    private JMenuItem loadDataMenuItem;
    private JMenuBar mainMenuBar;
    private JTabbedPane mainTabbedPane;
    private JMenuItem mnuPerturbator;
    private JTextField numberOfBlotSeriesTextField;
    private JTextField numberOfEdgesTextField;
    private JTextField numberOfNodesTextField;
    private JTextField numberOfSeriesTextField;
    private JMenuItem openMenuItem;
    private JPanel pnlLogo;
    private JPanel pnlRunningAnalysis;
    private JTextField pointsPerBlotSeriesTextField;
    private JTextField pointsPerSeriesTextField;
    private JMenu prefAnalysisMenu;
    private JCheckBoxMenuItem prefExtractContinuous;
    private JRadioButtonMenuItem prefUseBDDMenuItem;
    private JRadioButtonMenuItem prefUseGLAMenuItem;
    private JProgressBar progBar;
    private JMenu runMenu;
    private JMenuItem runSimulationMenuItem;
    private JMenuItem saveMMLMenuItem;
    private JMenuItem saveSimulationDataMenuItem;
    private JButton showPlot;
    private JButton showVirtualBlotButton;
    private JButton simulationDataSaveButton;
    private JPanel simulationPanel;
    private JScrollPane simulationScrollPane;
    private JTable simulationTable;
    private JFrame tableFrame;
    private JMenuItem viewCurrentNetworkMenuItem;
    private JMenuItem viewCurrentSimulationMenuItem;
    private JMenu viewMenu;
    private JMenuItem viewVirtualBlotMenuItem;

    public GUI() {
        this.initComponents();
        ClassLoader cl = this.getClass().getClassLoader();
        ImageIcon im = new ImageIcon(cl.getResource("images/SquadLogo.png"));
        this.frameTitle = "SQUAD Suite";
        this.setTitle("SQUAD");
        this.pnlRunningAnalysis.setVisible(false);
        this.pnlLogo.setLayout(new BorderLayout());
        JLabel jl = new JLabel(im);
        this.pnlLogo.add((Component)jl, "North");
    }

    public GUI(String networkFile) {
        this();
        File nt = new File(networkFile);
        if (nt.exists()) {
            this.loadNetwork(new File(networkFile));
        } else {
            JOptionPane.showMessageDialog(this, "The file " + networkFile + "could not be found", "Load network", 0);
        }
    }

    public JButton getVirtualBlotButton() {
        return this.showVirtualBlotButton;
    }

    private void initComponents() {
        this.tableFrame = new JFrame();
        this.mainTabbedPane = new JTabbedPane();
        this.generalInfoPanel = new JPanel();
        this.pnlLogo = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.butLoadNetworkGui = new JButton();
        this.butRunAnalysis = new JButton();
        this.jLabel1 = new JLabel();
        this.currentNetworkTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.numberOfNodesTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.numberOfEdgesTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.currentTimeSeriesTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.numberOfSeriesTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.pointsPerSeriesTextField = new JTextField();
        this.jLabel8 = new JLabel();
        this.currentBlotDataTextField = new JTextField();
        this.jLabel9 = new JLabel();
        this.numberOfBlotSeriesTextField = new JTextField();
        this.jLabel10 = new JLabel();
        this.pointsPerBlotSeriesTextField = new JTextField();
        this.pnlRunningAnalysis = new JPanel();
        this.progBar = new JProgressBar();
        this.jLabel7 = new JLabel();
        this.dynamicPanel = new JPanel();
        this.simulationPanel = new JPanel();
        this.simulationScrollPane = new JScrollPane();
        this.simulationTable = new JTable();
        this.simulationDataSaveButton = new JButton();
        this.showVirtualBlotButton = new JButton();
        this.showPlot = new JButton();
        this.mainMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.loadDataMenuItem = new JMenuItem();
        this.loadBlotDataMenuItem = new JMenuItem();
        this.saveMMLMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.saveSimulationDataMenuItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.runMenu = new JMenu();
        this.runSimulationMenuItem = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.prefAnalysisMenu = new JMenu();
        this.prefExtractContinuous = new JCheckBoxMenuItem();
        this.jSeparator3 = new JSeparator();
        this.prefUseBDDMenuItem = new JRadioButtonMenuItem();
        this.prefUseGLAMenuItem = new JRadioButtonMenuItem();
        this.viewMenu = new JMenu();
        this.viewCurrentNetworkMenuItem = new JMenuItem();
        this.viewCurrentSimulationMenuItem = new JMenuItem();
        this.viewVirtualBlotMenuItem = new JMenuItem();
        this.advancedMenu = new JMenu();
        this.mnuPerturbator = new JMenuItem();
        this.helpMenu = new JMenu();
        this.displayManualMenuItem = new JMenuItem();
        this.aboutMenu = new JMenuItem();
        GroupLayout tableFrameLayout = new GroupLayout(this.tableFrame.getContentPane());
        this.tableFrame.getContentPane().setLayout((LayoutManager)tableFrameLayout);
        tableFrameLayout.setHorizontalGroup((GroupLayout.Group)tableFrameLayout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        tableFrameLayout.setVerticalGroup((GroupLayout.Group)tableFrameLayout.createParallelGroup(1).add(0, 300, Short.MAX_VALUE));
        this.setDefaultCloseOperation(3);
        this.setTitle("Modeling suite");
        this.setResizable(false);
        this.mainTabbedPane.setBackground(new Color(238, 238, 238));
        this.mainTabbedPane.setAutoscrolls(true);
        this.mainTabbedPane.setName("tabDynamical");
        GroupLayout pnlLogoLayout = new GroupLayout((Container)this.pnlLogo);
        this.pnlLogo.setLayout((LayoutManager)pnlLogoLayout);
        pnlLogoLayout.setHorizontalGroup((GroupLayout.Group)pnlLogoLayout.createParallelGroup(1).add(0, 353, Short.MAX_VALUE));
        pnlLogoLayout.setVerticalGroup((GroupLayout.Group)pnlLogoLayout.createParallelGroup(1).add(0, 69, Short.MAX_VALUE));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 94, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        this.butLoadNetworkGui.setText("Load Network");
        this.butLoadNetworkGui.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.butLoadNetworkGuiActionPerformed(evt);
            }
        });
        this.butRunAnalysis.setText("Run Analysis");
        this.butRunAnalysis.setEnabled(false);
        this.butRunAnalysis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.butRunAnalysisActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Current network");
        this.currentNetworkTextField.setEditable(false);
        this.jLabel3.setText("nodes");
        this.numberOfNodesTextField.setEditable(false);
        this.jLabel4.setText("edges");
        this.numberOfEdgesTextField.setEditable(false);
        this.jLabel2.setText("current time series");
        this.currentTimeSeriesTextField.setEditable(false);
        this.jLabel5.setText("series");
        this.numberOfSeriesTextField.setEditable(false);
        this.jLabel6.setText("points per series");
        this.pointsPerSeriesTextField.setEditable(false);
        this.jLabel8.setText("current blot data");
        this.currentBlotDataTextField.setEditable(false);
        this.jLabel9.setText("series");
        this.numberOfBlotSeriesTextField.setEditable(false);
        this.jLabel10.setText("points per series");
        this.pointsPerBlotSeriesTextField.setEditable(false);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.butLoadNetworkGui, -2, 112, -2).add(71, 71, 71).add((Component)this.butRunAnalysis, -2, 120, -2).addContainerGap()).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.jLabel1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(10, 10, 10).add((Component)this.jLabel4)).add((Component)this.jLabel3))).add(23, 23, 23).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.currentNetworkTextField, -1, 170, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2, false).add(1, (Component)this.numberOfNodesTextField).add(1, (Component)this.numberOfEdgesTextField, -1, 37, Short.MAX_VALUE))).add(125, 125, 125)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.jLabel6).add((Component)this.jLabel5).add((Component)this.jLabel2).add((Component)this.jLabel8).add((Component)this.jLabel9).add((Component)this.jLabel10)).add(13, 13, 13).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.currentBlotDataTextField, -1, 170, Short.MAX_VALUE).add((Component)this.currentTimeSeriesTextField, -2, 169, -2).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2, false).add(1, (Component)this.pointsPerSeriesTextField).add(1, (Component)this.numberOfSeriesTextField, -1, 36, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2, false).add(1, (Component)this.pointsPerBlotSeriesTextField).add(1, (Component)this.numberOfBlotSeriesTextField, -1, 39, Short.MAX_VALUE))).add(125, 125, 125)))));
        jPanel2Layout.linkSize(new Component[]{this.butLoadNetworkGui, this.butRunAnalysis}, 1);
        jPanel2Layout.linkSize(new Component[]{this.currentBlotDataTextField, this.currentNetworkTextField, this.currentTimeSeriesTextField}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.butLoadNetworkGui).add((Component)this.butRunAnalysis, -2, 23, -2)).add(14, 14, 14).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.currentNetworkTextField, -2, -1, -2)).add(9, 9, 9).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.numberOfNodesTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.numberOfEdgesTextField, -2, -1, -2)).add(15, 15, 15).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel2, -2, 25, -2).add((Component)this.currentTimeSeriesTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.numberOfSeriesTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.pointsPerSeriesTextField, -2, -1, -2)).add(24, 24, 24).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel8).add((Component)this.currentBlotDataTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel9).add((Component)this.numberOfBlotSeriesTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel10).add((Component)this.pointsPerBlotSeriesTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlRunningAnalysis.setBackground(new Color(204, 204, 255));
        this.pnlRunningAnalysis.setBorder(new LineBorder(new Color(153, 153, 255), 1, true));
        this.jLabel7.setText("Running analysis ...");
        GroupLayout pnlRunningAnalysisLayout = new GroupLayout((Container)this.pnlRunningAnalysis);
        this.pnlRunningAnalysis.setLayout((LayoutManager)pnlRunningAnalysisLayout);
        pnlRunningAnalysisLayout.setHorizontalGroup((GroupLayout.Group)pnlRunningAnalysisLayout.createParallelGroup(1).add((GroupLayout.Group)pnlRunningAnalysisLayout.createSequentialGroup().addContainerGap(90, Short.MAX_VALUE).add((Component)this.progBar, -2, 250, -2).add(68, 68, 68)).add((GroupLayout.Group)pnlRunningAnalysisLayout.createSequentialGroup().add(151, 151, 151).add((Component)this.jLabel7).addContainerGap(162, Short.MAX_VALUE)));
        pnlRunningAnalysisLayout.setVerticalGroup((GroupLayout.Group)pnlRunningAnalysisLayout.createParallelGroup(1).add(2, (GroupLayout.Group)pnlRunningAnalysisLayout.createSequentialGroup().add((Component)this.jLabel7).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.progBar, -2, -1, -2).addContainerGap()));
        GroupLayout generalInfoPanelLayout = new GroupLayout((Container)this.generalInfoPanel);
        this.generalInfoPanel.setLayout((LayoutManager)generalInfoPanelLayout);
        generalInfoPanelLayout.setHorizontalGroup((GroupLayout.Group)generalInfoPanelLayout.createParallelGroup(1).add((GroupLayout.Group)generalInfoPanelLayout.createSequentialGroup().addContainerGap(304, Short.MAX_VALUE).add((Component)this.jPanel1, -2, -1, -2).addContainerGap()).add((Component)this.pnlRunningAnalysis, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)generalInfoPanelLayout.createSequentialGroup().add(31, 31, 31).add((GroupLayout.Group)generalInfoPanelLayout.createParallelGroup(1).add((Component)this.pnlLogo, -2, -1, -2).add((Component)this.jPanel2, -2, 346, -2)).addContainerGap(24, Short.MAX_VALUE)));
        generalInfoPanelLayout.setVerticalGroup((GroupLayout.Group)generalInfoPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)generalInfoPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.pnlLogo, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).add(16, 16, 16).add((Component)this.pnlRunningAnalysis, -2, -1, -2).add(616, 616, 616).add((Component)this.jPanel1, -2, -1, -2).add(1378, 1378, 1378)));
        this.mainTabbedPane.addTab("General info", this.generalInfoPanel);
        this.dynamicPanel.setLayout(new BorderLayout());
        this.mainTabbedPane.addTab("Dynamic simulation", this.dynamicPanel);
        this.simulationScrollPane.setHorizontalScrollBarPolicy(32);
        this.simulationScrollPane.setVerticalScrollBarPolicy(22);
        this.simulationScrollPane.setEnabled(false);
        this.simulationScrollPane.setFocusable(false);
        this.simulationScrollPane.setRequestFocusEnabled(false);
        this.simulationScrollPane.setVerifyInputWhenFocusTarget(false);
        this.simulationTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.simulationTable.setAutoResizeMode(0);
        this.simulationTable.setColumnSelectionAllowed(true);
        this.simulationTable.setDragEnabled(true);
        this.simulationScrollPane.setViewportView(this.simulationTable);
        this.simulationDataSaveButton.setText("Save time series");
        this.simulationDataSaveButton.setEnabled(false);
        this.simulationDataSaveButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GUI.this.simulationDataSaveButtonMouseClicked(evt);
            }
        });
        this.showVirtualBlotButton.setText("Show VirtualBlot");
        this.showVirtualBlotButton.setEnabled(false);
        this.showVirtualBlotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.showVirtualBlotButtonActionPerformed(evt);
            }
        });
        this.showPlot.setText("Show Data Plot");
        this.showPlot.setEnabled(false);
        this.showPlot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.showPlotActionPerformed(evt);
            }
        });
        GroupLayout simulationPanelLayout = new GroupLayout((Container)this.simulationPanel);
        this.simulationPanel.setLayout((LayoutManager)simulationPanelLayout);
        simulationPanelLayout.setHorizontalGroup((GroupLayout.Group)simulationPanelLayout.createParallelGroup(1).add((GroupLayout.Group)simulationPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)simulationPanelLayout.createParallelGroup(1).add((Component)this.simulationScrollPane, -1, 388, Short.MAX_VALUE).add((GroupLayout.Group)simulationPanelLayout.createSequentialGroup().add((Component)this.simulationDataSaveButton).addPreferredGap(0, 34, Short.MAX_VALUE).add((Component)this.showPlot, -2, 106, -2).add(28, 28, 28).add((Component)this.showVirtualBlotButton))).addContainerGap()));
        simulationPanelLayout.setVerticalGroup((GroupLayout.Group)simulationPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)simulationPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.simulationScrollPane, -2, 451, -2).addPreferredGap(0).add((GroupLayout.Group)simulationPanelLayout.createParallelGroup(3).add((Component)this.simulationDataSaveButton).add((Component)this.showVirtualBlotButton).add((Component)this.showPlot)).add(145, 145, 145)));
        this.mainTabbedPane.addTab("Simulation data", this.simulationPanel);
        this.fileMenu.setText("File");
        this.openMenuItem.setText("Load network");
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.loadDataMenuItem.setText("Load time series");
        this.loadDataMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.loadDataMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.loadDataMenuItem);
        this.loadBlotDataMenuItem.setText("Load blot data");
        this.loadBlotDataMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                GUI.this.loadBlotDataMenuItemMousePressed(evt);
            }
        });
        this.fileMenu.add(this.loadBlotDataMenuItem);
        this.saveMMLMenuItem.setText("Save network (MML2.0)");
        this.saveMMLMenuItem.setToolTipText("Save the network in MML 2.0 format");
        this.saveMMLMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.saveMMLMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMMLMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.saveSimulationDataMenuItem.setText("Save simulation data");
        this.saveSimulationDataMenuItem.setEnabled(false);
        this.saveSimulationDataMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GUI.this.saveSimulationDataMenuItemMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                GUI.this.saveSimulationDataMenuItemMousePressed(evt);
            }
        });
        this.fileMenu.add(this.saveSimulationDataMenuItem);
        this.fileMenu.add(this.jSeparator2);
        this.exitMenuItem.setText("Exit system");
        this.exitMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                GUI.this.exitSystem(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.mainMenuBar.add(this.fileMenu);
        this.runMenu.setText("Run");
        this.runMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.runMenuActionPerformed(evt);
            }
        });
        this.runSimulationMenuItem.setText("Analysis of ...");
        this.runSimulationMenuItem.setEnabled(false);
        this.runSimulationMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                GUI.this.runSimulationMenuItemMousePressed(evt);
            }
        });
        this.runMenu.add(this.runSimulationMenuItem);
        this.runMenu.add(this.jSeparator4);
        this.prefAnalysisMenu.setText("Analysis Preferences");
        this.prefExtractContinuous.setSelected(true);
        this.prefExtractContinuous.setText("Extract continuous states");
        this.prefExtractContinuous.setToolTipText("When checked the continuos values are derived from each discrete steady state ");
        this.prefExtractContinuous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.prefExtractContinuousActionPerformed(evt);
            }
        });
        this.prefAnalysisMenu.add(this.prefExtractContinuous);
        this.jSeparator3.setEnabled(false);
        this.prefAnalysisMenu.add(this.jSeparator3);
        this.prefUseBDDMenuItem.setSelected(true);
        this.prefUseBDDMenuItem.setText("Use BDD to find Steady States (fast)");
        this.prefUseBDDMenuItem.setToolTipText("Finds Steady states by using Binary Decision Diagrams");
        this.prefUseBDDMenuItem.setEnabled(false);
        this.prefUseBDDMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.prefUseBDDMenuItemActionPerformed(evt);
            }
        });
        this.prefAnalysisMenu.add(this.prefUseBDDMenuItem);
        this.prefUseGLAMenuItem.setText("Use GLA to find Steady States");
        this.prefUseGLAMenuItem.setToolTipText("Iterates over all the possible states to find Steady States");
        this.prefUseGLAMenuItem.setEnabled(false);
        this.prefUseGLAMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.prefUseGLAMenuItemActionPerformed(evt);
            }
        });
        this.prefAnalysisMenu.add(this.prefUseGLAMenuItem);
        this.runMenu.add(this.prefAnalysisMenu);
        this.mainMenuBar.add(this.runMenu);
        this.viewMenu.setText("View");
        this.viewCurrentNetworkMenuItem.setText("Graph of ...");
        this.viewCurrentNetworkMenuItem.setEnabled(false);
        this.viewCurrentNetworkMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.viewCurrentNetworkMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewCurrentNetworkMenuItem);
        this.viewCurrentSimulationMenuItem.setText("Simulation as a time-series plot");
        this.viewCurrentSimulationMenuItem.setEnabled(false);
        this.viewCurrentSimulationMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.viewCurrentSimulationMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewCurrentSimulationMenuItem);
        this.viewVirtualBlotMenuItem.setText("Simulation data as VirtualBlot");
        this.viewVirtualBlotMenuItem.setEnabled(false);
        this.viewVirtualBlotMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.viewVirtualBlotMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewVirtualBlotMenuItem);
        this.mainMenuBar.add(this.viewMenu);
        this.advancedMenu.setText("Advanced");
        this.mnuPerturbator.setText("Perturbator");
        this.mnuPerturbator.setToolTipText("Loads a form for the simulation of the network with a protocol of perturbations");
        this.mnuPerturbator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.mnuPerturbatorActionPerformed(evt);
            }
        });
        this.advancedMenu.add(this.mnuPerturbator);
        this.mainMenuBar.add(this.advancedMenu);
        this.helpMenu.setText("Help");
        this.displayManualMenuItem.setText("manual");
        this.displayManualMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.displayManualMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.displayManualMenuItem);
        this.aboutMenu.setText("About SQUAD");
        this.aboutMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.aboutMenuActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenu);
        this.mainMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.mainMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.mainTabbedPane, -1, 413, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.mainTabbedPane, -2, 532, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void showVirtualBlotButtonActionPerformed(ActionEvent evt) {
        this.createTheVirtualBlot();
    }

    private void aboutMenuActionPerformed(ActionEvent evt) {
        AboutDialog ab = new AboutDialog((Frame)this, true);
        ab.setAlwaysOnTop(true);
        ab.setVisible(true);
    }

    private void displayManualMenuItemActionPerformed(ActionEvent evt) {
        this.loadHelp();
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        this.loadNetwork(null);
    }

    private void loadDataMenuItemActionPerformed(ActionEvent evt) {
        try {
            this.loadSeriesData();
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "The series data file could not be read", "Load data series", 0);
        }
    }

    private void mnuPerturbatorActionPerformed(ActionEvent evt) {
        this.loadPerturbator();
    }

    private void showPlotActionPerformed(ActionEvent evt) {
        this.showTimeSeriesPlot();
    }

    private void prefExtractContinuousActionPerformed(ActionEvent evt) {
    }

    private void runMenuActionPerformed(ActionEvent evt) {
    }

    private void prefUseGLAMenuItemActionPerformed(ActionEvent evt) {
        this.prefUseBDDMenuItem.setSelected(false);
    }

    private void prefUseBDDMenuItemActionPerformed(ActionEvent evt) {
        this.prefUseGLAMenuItem.setSelected(false);
    }

    private void saveMMLMenuItemActionPerformed(ActionEvent evt) {
        if (this.mainTabbedPane.getSelectedIndex() == 1 && this.odeSimulator != null) {
            this.odeSimulator.saveNetwork();
            return;
        }
        JFileChooser savDi = new JFileChooser();
        savDi.addChoosableFileFilter(new FileFilterNetwork(new String[]{"mml"}));
        if (savDi.showSaveDialog(this) == 0) {
            try {
                File fileOut = FileUtils.changeFileExtension("mml", savDi.getSelectedFile(), true);
                if (fileOut == null) {
                    return;
                }
                GraphContainer.saveGraphFromFile(this.grCont.getGraph(), null, fileOut, false);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "An error has occurred while saving the file", 0);
                e.printStackTrace();
            }
        }
    }

    private void butRunAnalysisActionPerformed(ActionEvent evt) {
        this.runNetworkAnalysis();
    }

    private void butLoadNetworkGuiActionPerformed(ActionEvent evt) {
        this.loadNetwork(null);
    }

    private void simulationDataSaveButtonMouseClicked(MouseEvent evt) {
        this.saveSimulationData();
    }

    private void saveSimulationDataMenuItemMousePressed(MouseEvent evt) {
        this.saveSimulationData();
    }

    private void saveSimulationDataMenuItemMouseClicked(MouseEvent evt) {
    }

    private void createTheVirtualBlot() {
        String file = this.currentTimeSeriesTextField.getText();
        if (file.equals("")) {
            try {
                File temporalFile = File.createTempFile("for_visualblot", null);
                BufferedWriter fileWriter = new BufferedWriter(new FileWriter(temporalFile.getCanonicalPath()));
                fileWriter.close();
                Vector data = new Vector(VectorTools.tableModelToMatrix(this.simulationTable.getModel()));
                TabSeparatedDataFile dataFile = new TabSeparatedDataFile(temporalFile.getCanonicalPath());
                dataFile.write(data);
                file = temporalFile.getCanonicalPath();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.createVirtualBlot(file);
    }

    private void viewVirtualBlotMenuItemActionPerformed(ActionEvent evt) {
        this.createTheVirtualBlot();
    }

    private void loadBlotDataMenuItemMousePressed(MouseEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            String fileName = file.getAbsolutePath();
            this.createVirtualBlot(fileName);
        }
    }

    private void viewCurrentSimulationMenuItemActionPerformed(ActionEvent evt) {
        this.showTimeSeriesPlot();
    }

    private void runSimulationMenuItemMousePressed(MouseEvent evt) {
        this.runNetworkAnalysis();
    }

    private void viewCurrentNetworkMenuItemActionPerformed(ActionEvent evt) {
        this.grCont.displayDirectedGraph();
    }

    private void exitSystem(MouseEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GUI("samples/THelper_network.net").setVisible(true);
            }
        });
    }

    private void loadNetwork(File inputFile) {
        File networkFile = inputFile;
        if (networkFile == null) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.addChoosableFileFilter(new FileFilterNetwork(new String[]{"mml", "net", "xml"}));
            fileChooser.setFileView(new FileViewNetwork());
            int returnVal = fileChooser.showOpenDialog(this);
            if (returnVal != 0) {
                return;
            }
            networkFile = fileChooser.getSelectedFile();
        }
        try {
            this.grCont = new GraphContainer(networkFile.getAbsolutePath());
            this.viewCurrentNetworkMenuItem.setText("Graph of " + networkFile.getName());
            this.viewCurrentNetworkMenuItem.setEnabled(true);
            this.runSimulationMenuItem.setText("Analysis of " + networkFile.getName());
            this.runSimulationMenuItem.setEnabled(true);
            this.currentNetworkTextField.setText(networkFile.getName());
            Integer value = new Integer("0");
            value = this.grCont.getNumberOfNodes();
            this.numberOfNodesTextField.setText(value.toString());
            value = this.grCont.getNumberOfEdges();
            this.numberOfEdgesTextField.setText(value.toString());
            this.mainTabbedPane.setSelectedIndex(0);
            this.dynamicPanel.removeAll();
            this.simulationPanel = null;
            this.butRunAnalysis.setEnabled(true);
            if (this.grCont.getStates() != null) {
                if (JOptionPane.showConfirmDialog(this, "The file contains some pre-calculated steady states, would you like to skip the analysis?", "Network load", 0) == 0) {
                    this.displaySimulationPanel(true);
                } else {
                    this.grCont.getStates().clear();
                }
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "File error", 0);
            e.printStackTrace();
        }
    }

    private void showTimeSeriesPlot() {
        try {
            File temporalFile = File.createTempFile("for_plot", null);
            String fileName = temporalFile.getAbsolutePath();
            TabSeparatedDataFile dataFile = new TabSeparatedDataFile(fileName);
            DecoratedDoubleMatrix2D data = ((MatrixAsTableModel)this.simulationTable.getModel()).getAllData();
            dataFile.writeMatrix(data);
            PlotFrameDisplay pl = new PlotFrameDisplay(fileName);
            pl.setTitle(this.frameTitle);
            pl.setVisible(true);
            temporalFile.delete();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void loadSeriesData() throws IOException {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileFilterNetwork(new String[]{"res"}));
        fileChooser.setFileView(new FileViewNetwork());
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            String fileName = file.getAbsolutePath();
            TabSeparatedDataFile dataFile = new TabSeparatedDataFile(fileName);
            this.showResults(this.grCont.getNodes(), dataFile.readMatrix());
            this.currentTimeSeriesTextField.setText(file.getAbsolutePath());
            this.showPlot.setEnabled(true);
            this.showVirtualBlotButton.setEnabled(true);
            this.viewVirtualBlotMenuItem.setEnabled(true);
            this.saveSimulationDataMenuItem.setEnabled(true);
        }
    }

    private void runNetworkAnalysis() {
        this.mainTabbedPane.setSelectedIndex(0);
        this.theSimulator = new Simulator(this.grCont);
        int numberOfNodes = this.theSimulator.getGraphContainer().getNumberOfNodes();
        int totalStates = Double.valueOf(Math.pow(2.0, numberOfNodes)).intValue();
        this.pnlRunningAnalysis.setVisible(true);
        this.progBar.setValue(0);
        this.progBar.setMaximum(totalStates - 1);
        boolean useBDDAnalysis = this.prefUseBDDMenuItem.isSelected();
        if (totalStates > 5000 || useBDDAnalysis) {
            this.progBar.setIndeterminate(true);
            this.progBar.setStringPainted(false);
        } else {
            this.progBar.setIndeterminate(false);
            this.progBar.setStringPainted(true);
        }
        NetworkAnalyseTask worker = new NetworkAnalyseTask(useBDDAnalysis, this.prefExtractContinuous.isSelected());
        worker.execute();
    }

    public void displaySimulationPanel(boolean loadFromFile) {
        try {
            this.pnlRunningAnalysis.setVisible(false);
            this.odeSimulator = new OdeSimulatorPanel(this.grCont, (Container)this);
            this.mainTabbedPane.setSelectedIndex(1);
            this.dynamicPanel.removeAll();
            this.dynamicPanel.add((Component)this.odeSimulator, "Center");
            this.dynamicPanel.validate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadHelp() {
        try {
            Desktop.getDesktop().browse(new URI(AppProperties.HELP_URL));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private void loadAbout() {
    }

    public void showResults(List<AbstractGraphNode> nodes, DecoratedDoubleMatrix2D allData) {
        DecoratedDoubleMatrix2D myData = allData;
        MatrixAsTableModel dataModel = new MatrixAsTableModel(myData);
        this.simulationTable.setModel(dataModel);
        this.simulationTable.setColumnSelectionAllowed(true);
        this.simulationTable.setCellSelectionEnabled(false);
        Integer value = new Integer(this.simulationTable.getModel().getColumnCount() - 1);
        this.numberOfSeriesTextField.setText(value.toString());
        value = new Integer(this.simulationTable.getModel().getRowCount());
        this.pointsPerSeriesTextField.setText(value.toString());
        this.viewCurrentSimulationMenuItem.setEnabled(true);
        this.showPlot.setEnabled(true);
        this.showVirtualBlotButton.setEnabled(true);
        this.simulationDataSaveButton.setEnabled(true);
        this.mainTabbedPane.setSelectedIndex(2);
    }

    public void eraseResults() {
        DefaultTableModel mod = (DefaultTableModel)this.simulationTable.getModel();
        mod.fireTableDataChanged();
        this.numberOfSeriesTextField.setText("");
        this.pointsPerSeriesTextField.setText("");
        this.viewCurrentSimulationMenuItem.setEnabled(false);
        this.showPlot.setEnabled(false);
        this.showVirtualBlotButton.setEnabled(false);
        this.simulationDataSaveButton.setEnabled(false);
        this.mainTabbedPane.setSelectedIndex(2);
    }

    private void createVirtualBlot(String fileName) {
        try {
            TabSeparatedDataFile dataFile = new TabSeparatedDataFile(fileName);
            DecoratedDoubleMatrix2D dataMAtrix = dataFile.readMatrix();
            ReportFrame rep = new ReportFrame(dataMAtrix, this.frameTitle);
            rep.setVisible(true);
            this.numberOfBlotSeriesTextField.setText(String.valueOf(dataMAtrix.columns()));
            this.pointsPerBlotSeriesTextField.setText(String.valueOf(dataMAtrix.rows()));
        }
        catch (IOException e) {
            e.printStackTrace();
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "The series data file could not be read", "Load data series", 0);
        }
    }

    private void saveSimulationData() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileFilterNetwork(new String[]{"res"}));
        fileChooser.setFileView(new FileViewNetwork());
        int returnValue = fileChooser.showSaveDialog(this);
        if (returnValue == 0) {
            File fileOut = FileUtils.changeFileExtension("res", fileChooser.getSelectedFile(), true);
            if (fileOut == null) {
                return;
            }
            String fileName = fileOut.getAbsolutePath();
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(fileName));
                for (int i = 0; i < this.simulationTable.getModel().getColumnCount(); ++i) {
                    out.write(this.simulationTable.getModel().getColumnName(i) + "\t");
                }
                out.write("\n");
                for (int row = 0; row < this.simulationTable.getModel().getRowCount(); ++row) {
                    for (int column = 0; column < this.simulationTable.getModel().getColumnCount(); ++column) {
                        out.write(this.simulationTable.getModel().getValueAt(row, column).toString() + "\t");
                    }
                    out.write("\n");
                }
                this.currentTimeSeriesTextField.setText(fileName);
                Integer value = new Integer(this.simulationTable.getModel().getColumnCount() - 1);
                this.numberOfSeriesTextField.setText(value.toString());
                value = new Integer(this.simulationTable.getModel().getRowCount());
                this.pointsPerSeriesTextField.setText(value.toString());
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void loadPerturbator() {
        PerturbationFrame prtF = new PerturbationFrame(this.grCont);
        prtF.setDefaultCloseOperation(2);
        prtF.setVisible(true);
    }

    static {
        try {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new SyntheticaStandardLookAndFeel());
                String sysVersion = System.getProperty("java.version");
                if (Integer.parseInt(((Object)sysVersion.subSequence(2, 3)).toString()) < 6) {
                    JOptionPane.showMessageDialog(null, "JAVA version 1.6 or above is required to run this applications, some features might not function properly ", "Java Version Warning", 2);
                }
                if (!System.getProperty("os.name").startsWith("Windows")) {
                    SyntheticaLookAndFeel.setExtendedFileChooserEnabled((boolean)false);
                }
            }
            catch (UnsupportedLookAndFeelException e) {
                e.printStackTrace();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private class NetworkAnalyseTask
    extends SwingWorker<Void, Integer>
    implements IObserver {
        boolean useBDD = true;
        boolean extractContState = true;

        public NetworkAnalyseTask(boolean useBDDforSearch, boolean extractContinuousSteadtStates) {
            this.useBDD = useBDDforSearch;
            this.extractContState = extractContinuousSteadtStates;
        }

        @Override
        protected Void doInBackground() throws Exception {
            GUI.this.theSimulator.setUseBDDnalysis(this.useBDD);
            if (!this.extractContState) {
                GUI.this.theSimulator.setExtractContinuousState(false);
            }
            GUI.this.theSimulator.run();
            return null;
        }

        @Override
        protected void done() {
            GUI.this.displaySimulationPanel(false);
        }

        @Override
        public void updateObserver(IObservable obsvble, Object args) {
            GUI.this.progBar.setValue((Integer)args);
        }
    }
}

