/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.pl;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.DirectionalEdgeArrowFunction;
import edu.uci.ics.jung.graph.decorators.EdgeArrowFunction;
import edu.uci.ics.jung.graph.decorators.EdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.decorators.VertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexStringer;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.PickSupport;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.SettableVertexLocationFunction;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.StaticLayout;
import edu.uci.ics.jung.visualization.VertexLocationFunction;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.control.ViewScalingControl;
import java.awt.AWTException;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MenuComponent;
import java.awt.Paint;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.RenderedImage;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.enfin.squad.bl.AbstractGraphNode;
import org.enfin.squad.bl.IEdge;
import org.enfin.squad.bl.IObservable;
import org.enfin.squad.bl.IObserver;
import org.enfin.squad.bl.NetworkState;
import org.enfin.squad.bl.ode.ODESystemSolver;
import org.enfin.squad.dl.GraphContainer;
import org.enfin.squad.perturbations.bl.Protocol;
import org.enfin.squad.perturbations.bl.ProtocolFactory;
import org.enfin.squad.pl.ConstantCircleLayout;
import org.enfin.squad.pl.NodePositioner;
import org.enfin.squad.pl.PlotFrameDisplay;

public class GraphAnimator
implements IObserver {
    private Graph theGraph;
    private PluggableRenderer theRenderer;
    private static VisualizationViewer vv;
    private JDialog delegate;
    private JPanel pnlButtons;
    protected DefaultModalGraphMouse gm;
    private AbstractLayout ll;
    private SettableVertexLocationFunction vertexLocations;

    public static void showAnimation(String networkFile, String perturbatorFile) {
        ODESystemSolver oss = null;
        try {
            GraphContainer grContainer = new GraphContainer(networkFile);
            Graph gr = grContainer.getGraph();
            final GraphAnimator anim = new GraphAnimator(gr, GraphAnimator.ANIMATED_COLOR());
            try {
                if (perturbatorFile != "") {
                    Protocol pert = ProtocolFactory.generate(perturbatorFile);
                    if (pert.getPerturbations().size() > 0) {
                        oss = new ODESystemSolver(grContainer, pert.getPerturbations().get(0));
                    }
                } else {
                    oss = new ODESystemSolver(grContainer);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            anim.setDefaultCloseOperation(2);
            final PlotFrameDisplay plot = new PlotFrameDisplay("time", "state", "dynamic simulation", null);
            plot.clearDatasets();
            plot.setAutoscaleX(true);
            oss.registerObserver(plot);
            Thread tr1 = new Thread(){

                @Override
                public void run() {
                    anim.setVisible(true);
                }
            };
            try {
                SwingUtilities.invokeAndWait(tr1);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
            Thread tr2 = new Thread(){

                @Override
                public void run() {
                    plot.setVisible(true);
                }
            };
            SwingUtilities.invokeLater(tr2);
            oss.initialize();
            for (int m = 0; m < 100; ++m) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                oss.run();
                plot.repaint();
                anim.updateDisplay();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void displayGraphFromFile(String networkFile) {
        try {
            GraphContainer grContainer = new GraphContainer(networkFile);
            Graph gr = grContainer.getGraph();
            ArrayList<AbstractGraphNode> nodes = grContainer.getNodes();
            ArrayList<IEdge> edges = grContainer.getEdges();
            final GraphAnimator anim = new GraphAnimator(gr, GraphAnimator.ANIMATED_COLOR());
            anim.initializeGraph(GraphAnimator.DEFAULT_COLOR());
            Thread tr1 = new Thread(){

                @Override
                public void run() {
                    anim.setVisible(true);
                }
            };
            try {
                SwingUtilities.invokeAndWait(tr1);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public GraphAnimator(Graph gr, VertexPaintFunction colorRules) {
        this.theGraph = gr;
        this.initializeGraph(colorRules);
    }

    public void setButtonsVisible(boolean isVisible) {
        this.pnlButtons.setVisible(isVisible);
    }

    public void initializeGraph(VertexPaintFunction colorRules) {
        int height;
        int width;
        this.theRenderer = new PluggableRenderer();
        StringLabeller theLabeller = StringLabeller.getLabeller((Graph)this.theGraph);
        Vector allVertices = new Vector(this.theGraph.getVertices());
        for (int i = 0; i < allVertices.size(); ++i) {
            String theLabel = theLabeller.getLabel((ArchetypeVertex)allVertices.get(i));
            if (theLabel != null) continue;
            String id = ((Vertex)allVertices.get(i)).getUserDatum((Object)"id").toString();
            try {
                theLabeller.setLabel((Vertex)allVertices.get(i), id);
                continue;
            }
            catch (StringLabeller.UniqueLabelException ex) {
                ex.printStackTrace();
            }
        }
        this.theRenderer.setVertexStringer((VertexStringer)theLabeller);
        this.theRenderer.setVertexLabelCentering(false);
        EdgePaintFunction epf = new EdgePaintFunction(){

            public Paint getDrawPaint(Edge e) {
                if (e.getUserDatum((Object)"sign").equals("positive")) {
                    return Color.GREEN;
                }
                if (e.getUserDatum((Object)"sign").equals("negative")) {
                    GraphAnimator.this.theRenderer.getEdgeArrowFunction().getArrow(e).getPathIterator(AffineTransform.getRotateInstance(50.0), 50.0);
                    return Color.RED;
                }
                return Color.BLACK;
            }

            public Paint getFillPaint(Edge e) {
                return null;
            }
        };
        DirectionalEdgeArrowFunction arr = new DirectionalEdgeArrowFunction(10, 10, 0);
        this.theRenderer.setEdgeArrowFunction((EdgeArrowFunction)arr);
        this.theRenderer.setEdgePaintFunction(epf);
        if (colorRules != null) {
            this.theRenderer.setVertexPaintFunction(colorRules);
        }
        boolean hasCoord = false;
        for (Vertex vt : this.theGraph.getVertices()) {
            if (vt.getUserDatum((Object)"posx") == null || vt.getUserDatum((Object)"posy") == null) continue;
            hasCoord = true;
        }
        this.vertexLocations = new NodePositioner();
        if (hasCoord) {
            this.makeDefinedLayout();
        } else if (this.theGraph.getVertices().size() <= 10) {
            this.makeCircleLayout();
        } else {
            this.makeRandomLayout();
        }
        vv = new VisualizationViewer((Layout)this.ll, (Renderer)this.theRenderer);
        vv.setBorder((Border)new LineBorder(Color.black));
        if (this.theGraph.getUserDatum((Object)"sizex") != null) {
            width = Integer.parseInt(this.theGraph.getUserDatum((Object)"sizex").toString());
            height = Integer.parseInt(this.theGraph.getUserDatum((Object)"sizey").toString());
        } else {
            width = 200;
            height = 200;
        }
        vv.setSize(new Dimension(width, height));
        vv.getViewTransformer().setScale(1.0, 1.0, (Point2D)new Point2D.Double(width - 50, height - 50));
        vv.getViewTransformer().setTranslate(20.0, 20.0);
        this.ll.restart();
        this.gm = new DefaultModalGraphMouse();
        this.gm.setZoomAtMouse(true);
        vv.setGraphMouse((VisualizationViewer.GraphMouse)this.gm);
        vv.setPickSupport((PickSupport)new ShapePickSupport());
        GraphZoomScrollPane scroller = new GraphZoomScrollPane(vv);
        scroller.setPreferredSize(new Dimension(width, height));
        this.delegate = new JDialog();
        this.delegate.setLayout(new BorderLayout());
        this.delegate.getContentPane().add((Component)scroller, "Center");
        ViewScalingControl scaler = new ViewScalingControl();
        JButton butPlus = new JButton("Zoom +");
        butPlus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(vv, 1.1f, vv.getCenter());
            }
        });
        JButton butMinus = new JButton("Zoom -");
        butMinus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(vv, 0.9090909f, vv.getCenter());
            }
        });
        JButton butSaveLayOut = new JButton("Save layout");
        butSaveLayOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphAnimator.this.saveLayout();
            }
        });
        JButton butSaveImage = new JButton("Save image");
        butSaveImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GraphAnimator.this.saveImage();
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(GraphAnimator.this.delegate, e1.getMessage());
                }
            }
        });
        JComboBox modeBox = this.gm.getModeComboBox();
        modeBox.setAlignmentX(0.5f);
        JPanel modePanel = new JPanel(new BorderLayout()){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        modePanel.setBorder(BorderFactory.createTitledBorder("Mouse Mode"));
        modePanel.add(modeBox);
        this.pnlButtons = new JPanel();
        this.pnlButtons.setLayout(new FlowLayout(1));
        this.pnlButtons.add(butPlus);
        this.pnlButtons.add(butMinus);
        this.pnlButtons.add(butSaveLayOut);
        this.pnlButtons.add(butSaveImage);
        this.pnlButtons.add(modePanel);
        this.delegate.getContentPane().add((Component)this.pnlButtons, "South");
        this.delegate.setPreferredSize(new Dimension(450, 450));
        this.delegate.pack();
    }

    private void makeRandomLayout() {
        this.ll = new StaticLayout(this.theGraph);
        this.ll.initialize(new Dimension(200, 200));
    }

    private void makeCircleLayout() {
        this.ll = new ConstantCircleLayout(this.theGraph);
        this.ll.initialize(new Dimension(200, 200));
    }

    private void makeDefinedLayout() {
        this.ll = new StaticLayout(this.theGraph);
        Double x = 0.0;
        Double y = 0.0;
        int vertexCounter = 1;
        for (Vertex vt : this.theGraph.getVertices()) {
            if (vt.getUserDatum((Object)"posx") != null && vt.getUserDatum((Object)"posy") != null) {
                x = Double.parseDouble(vt.getUserDatum((Object)"posx").toString());
                y = Double.parseDouble(vt.getUserDatum((Object)"posy").toString());
            } else {
                x = 0.0;
                y = (double)vertexCounter * 50.0;
            }
            this.vertexLocations.setLocation((ArchetypeVertex)vt, (Point2D)new Coordinates(x.doubleValue(), y.doubleValue()));
            ++vertexCounter;
        }
        this.ll.initialize(new Dimension(200, 200), (VertexLocationFunction)this.vertexLocations);
    }

    @Override
    public void updateObserver(IObservable obsvble, Object args) {
        if (obsvble.getClass() == ODESystemSolver.class) {
            this.updateDisplay();
        }
    }

    public void saveImage() throws IOException {
        String selFileName;
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Save current graph image");
        if (fc.showSaveDialog(this.delegate) == 0) {
            // empty if block
        }
        if ((selFileName = fc.getSelectedFile().getAbsolutePath()).contains(".")) {
            selFileName.replaceFirst("\\..*", "");
        }
        try {
            ImageIO.write((RenderedImage)this.getImage(), "jpg", new File(selFileName + ".jpg"));
            JOptionPane.showMessageDialog(this.delegate, "The file has been saved");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("The image could not be saved");
        }
    }

    public BufferedImage getImage() {
        vv.setDoubleBuffered(false);
        BufferedImage bi = new BufferedImage(GraphAnimator.vv.getSize().width, GraphAnimator.vv.getSize().height, 1);
        Graphics2D graphics = bi.createGraphics();
        graphics.setColor(vv.getBackground());
        graphics.fillRect(0, 0, GraphAnimator.vv.getSize().width, vv.getHeight());
        vv.paint((Graphics)graphics);
        vv.setDoubleBuffered(true);
        return bi;
    }

    public void saveLayout() {
        for (Vertex vt : this.theGraph.getVertices()) {
            Double x = this.ll.getLocation((ArchetypeVertex)vt).getX();
            Double y = this.ll.getLocation((ArchetypeVertex)vt).getY();
            if (vt.getUserDatum((Object)"posx") == null && vt.getUserDatum((Object)"posy") == null) {
                vt.addUserDatum((Object)"posx", (Object)x, UserData.SHARED);
                vt.addUserDatum((Object)"posy", (Object)y, UserData.SHARED);
                continue;
            }
            vt.setUserDatum((Object)"posx", (Object)x, UserData.SHARED);
            vt.setUserDatum((Object)"posy", (Object)y, UserData.SHARED);
        }
    }

    public static VertexPaintFunction ANIMATED_COLOR() {
        return new VertexPaintFunction(){

            public Paint getFillPaint(Vertex vt) {
                double stateValue = Double.parseDouble(vt.getUserDatum((Object)"state").toString());
                return Color.getHSBColor(52.0f, 0.0f, 1.0f - Double.valueOf(stateValue).floatValue());
            }

            public Paint getDrawPaint(Vertex vt) {
                return Color.BLACK;
            }
        };
    }

    public static VertexPaintFunction STEADYSTATE_COLOR(final NetworkState nt) {
        return new VertexPaintFunction(){

            public Paint getFillPaint(Vertex vt) {
                if (nt.getContinuousValue(vt.getUserDatum((Object)"id")) != null) {
                    double sstateValue = nt.getContinuousValue(vt.getUserDatum((Object)"id"));
                    if (sstateValue == 1.0) {
                        return Color.RED;
                    }
                    if (sstateValue > 0.0) {
                        return Color.orange;
                    }
                }
                return Color.white;
            }

            public Paint getDrawPaint(Vertex vt) {
                return Color.BLACK;
            }
        };
    }

    public static VertexPaintFunction DEFAULT_COLOR() {
        return new VertexPaintFunction(){

            public Paint getFillPaint(Vertex vt) {
                return Color.white;
            }

            public Paint getDrawPaint(Vertex vt) {
                return Color.BLACK;
            }
        };
    }

    public void updateDisplay() {
        vv.repaint();
    }

    public boolean action(Event evt, Object what) {
        return this.delegate.action(evt, what);
    }

    public Component add(Component comp, int index) {
        return this.delegate.add(comp, index);
    }

    public void add(Component comp, Object constraints, int index) {
        this.delegate.add(comp, constraints, index);
    }

    public void add(Component comp, Object constraints) {
        this.delegate.add(comp, constraints);
    }

    public Component add(Component comp) {
        return this.delegate.add(comp);
    }

    public void add(PopupMenu popup) {
        this.delegate.add(popup);
    }

    public Component add(String name, Component comp) {
        return this.delegate.add(name, comp);
    }

    public void addComponentListener(ComponentListener l) {
        this.delegate.addComponentListener(l);
    }

    public void addContainerListener(ContainerListener l) {
        this.delegate.addContainerListener(l);
    }

    public void addFocusListener(FocusListener l) {
        this.delegate.addFocusListener(l);
    }

    public void addHierarchyBoundsListener(HierarchyBoundsListener l) {
        this.delegate.addHierarchyBoundsListener(l);
    }

    public void addHierarchyListener(HierarchyListener l) {
        this.delegate.addHierarchyListener(l);
    }

    public void addInputMethodListener(InputMethodListener l) {
        this.delegate.addInputMethodListener(l);
    }

    public void addKeyListener(KeyListener l) {
        this.delegate.addKeyListener(l);
    }

    public void addMouseListener(MouseListener l) {
        this.delegate.addMouseListener(l);
    }

    public void addMouseMotionListener(MouseMotionListener l) {
        this.delegate.addMouseMotionListener(l);
    }

    public void addMouseWheelListener(MouseWheelListener l) {
        this.delegate.addMouseWheelListener(l);
    }

    public void addNotify() {
        this.delegate.addNotify();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.delegate.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.delegate.addPropertyChangeListener(propertyName, listener);
    }

    public void addWindowFocusListener(WindowFocusListener l) {
        this.delegate.addWindowFocusListener(l);
    }

    public void addWindowListener(WindowListener l) {
        this.delegate.addWindowListener(l);
    }

    public void addWindowStateListener(WindowStateListener l) {
        this.delegate.addWindowStateListener(l);
    }

    public void applyComponentOrientation(ComponentOrientation o) {
        this.delegate.applyComponentOrientation(o);
    }

    public void applyResourceBundle(ResourceBundle rb) {
        this.delegate.applyResourceBundle(rb);
    }

    public void applyResourceBundle(String rbName) {
        this.delegate.applyResourceBundle(rbName);
    }

    public boolean areFocusTraversalKeysSet(int id) {
        return this.delegate.areFocusTraversalKeysSet(id);
    }

    public Rectangle bounds() {
        return this.delegate.bounds();
    }

    public int checkImage(Image image, ImageObserver observer) {
        return this.delegate.checkImage(image, observer);
    }

    public int checkImage(Image image, int width, int height, ImageObserver observer) {
        return this.delegate.checkImage(image, width, height, observer);
    }

    public boolean contains(int x, int y) {
        return this.delegate.contains(x, y);
    }

    public boolean contains(Point p) {
        return this.delegate.contains(p);
    }

    public int countComponents() {
        return this.delegate.countComponents();
    }

    public void createBufferStrategy(int numBuffers, BufferCapabilities caps) throws AWTException {
        this.delegate.createBufferStrategy(numBuffers, caps);
    }

    public void createBufferStrategy(int numBuffers) {
        this.delegate.createBufferStrategy(numBuffers);
    }

    public Image createImage(ImageProducer producer) {
        return this.delegate.createImage(producer);
    }

    public Image createImage(int width, int height) {
        return this.delegate.createImage(width, height);
    }

    public VolatileImage createVolatileImage(int width, int height, ImageCapabilities caps) throws AWTException {
        return this.delegate.createVolatileImage(width, height, caps);
    }

    public VolatileImage createVolatileImage(int width, int height) {
        return this.delegate.createVolatileImage(width, height);
    }

    public void deliverEvent(Event e) {
        this.delegate.deliverEvent(e);
    }

    public void disable() {
        this.delegate.disable();
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public void doLayout() {
        this.delegate.doLayout();
    }

    public void enable() {
        this.delegate.enable();
    }

    public void enable(boolean b) {
        this.delegate.enable(b);
    }

    public void enableInputMethods(boolean enable) {
        this.delegate.enableInputMethods(enable);
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public Component findComponentAt(int x, int y) {
        return this.delegate.findComponentAt(x, y);
    }

    public Component findComponentAt(Point p) {
        return this.delegate.findComponentAt(p);
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        this.delegate.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        this.delegate.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        this.delegate.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        this.delegate.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        this.delegate.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        this.delegate.firePropertyChange(propertyName, oldValue, newValue);
    }

    public AccessibleContext getAccessibleContext() {
        return this.delegate.getAccessibleContext();
    }

    public float getAlignmentX() {
        return this.delegate.getAlignmentX();
    }

    public float getAlignmentY() {
        return this.delegate.getAlignmentY();
    }

    public Color getBackground() {
        return this.delegate.getBackground();
    }

    public int getBaseline(int width, int height) {
        return this.delegate.getBaseline(width, height);
    }

    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        return this.delegate.getBaselineResizeBehavior();
    }

    public Rectangle getBounds() {
        return this.delegate.getBounds();
    }

    public Rectangle getBounds(Rectangle rv) {
        return this.delegate.getBounds(rv);
    }

    public BufferStrategy getBufferStrategy() {
        return this.delegate.getBufferStrategy();
    }

    public ColorModel getColorModel() {
        return this.delegate.getColorModel();
    }

    public Component getComponent(int n) {
        return this.delegate.getComponent(n);
    }

    public Component getComponentAt(int x, int y) {
        return this.delegate.getComponentAt(x, y);
    }

    public Component getComponentAt(Point p) {
        return this.delegate.getComponentAt(p);
    }

    public int getComponentCount() {
        return this.delegate.getComponentCount();
    }

    public ComponentListener[] getComponentListeners() {
        return this.delegate.getComponentListeners();
    }

    public ComponentOrientation getComponentOrientation() {
        return this.delegate.getComponentOrientation();
    }

    public Component[] getComponents() {
        return this.delegate.getComponents();
    }

    public int getComponentZOrder(Component comp) {
        return this.delegate.getComponentZOrder(comp);
    }

    public ContainerListener[] getContainerListeners() {
        return this.delegate.getContainerListeners();
    }

    public Container getContentPane() {
        return this.delegate.getContentPane();
    }

    public Cursor getCursor() {
        return this.delegate.getCursor();
    }

    public int getDefaultCloseOperation() {
        return this.delegate.getDefaultCloseOperation();
    }

    public DropTarget getDropTarget() {
        return this.delegate.getDropTarget();
    }

    public boolean getFocusableWindowState() {
        return this.delegate.getFocusableWindowState();
    }

    public Container getFocusCycleRootAncestor() {
        return this.delegate.getFocusCycleRootAncestor();
    }

    public FocusListener[] getFocusListeners() {
        return this.delegate.getFocusListeners();
    }

    public Component getFocusOwner() {
        return this.delegate.getFocusOwner();
    }

    public Set<AWTKeyStroke> getFocusTraversalKeys(int id) {
        return this.delegate.getFocusTraversalKeys(id);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return this.delegate.getFocusTraversalKeysEnabled();
    }

    public FocusTraversalPolicy getFocusTraversalPolicy() {
        return this.delegate.getFocusTraversalPolicy();
    }

    public Font getFont() {
        return this.delegate.getFont();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.delegate.getFontMetrics(font);
    }

    public Color getForeground() {
        return this.delegate.getForeground();
    }

    public Component getGlassPane() {
        return this.delegate.getGlassPane();
    }

    public Graphics getGraphics() {
        return this.delegate.getGraphics();
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.delegate.getGraphicsConfiguration();
    }

    public int getHeight() {
        return this.delegate.getHeight();
    }

    public HierarchyBoundsListener[] getHierarchyBoundsListeners() {
        return this.delegate.getHierarchyBoundsListeners();
    }

    public HierarchyListener[] getHierarchyListeners() {
        return this.delegate.getHierarchyListeners();
    }

    public List<Image> getIconImages() {
        return this.delegate.getIconImages();
    }

    public boolean getIgnoreRepaint() {
        return this.delegate.getIgnoreRepaint();
    }

    public InputContext getInputContext() {
        return this.delegate.getInputContext();
    }

    public InputMethodListener[] getInputMethodListeners() {
        return this.delegate.getInputMethodListeners();
    }

    public InputMethodRequests getInputMethodRequests() {
        return this.delegate.getInputMethodRequests();
    }

    public Insets getInsets() {
        return this.delegate.getInsets();
    }

    public JMenuBar getJMenuBar() {
        return this.delegate.getJMenuBar();
    }

    public KeyListener[] getKeyListeners() {
        return this.delegate.getKeyListeners();
    }

    public JLayeredPane getLayeredPane() {
        return this.delegate.getLayeredPane();
    }

    public LayoutManager getLayout() {
        return this.delegate.getLayout();
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.delegate.getListeners(listenerType);
    }

    public Locale getLocale() {
        return this.delegate.getLocale();
    }

    public Point getLocation() {
        return this.delegate.getLocation();
    }

    public Point getLocation(Point rv) {
        return this.delegate.getLocation(rv);
    }

    public Point getLocationOnScreen() {
        return this.delegate.getLocationOnScreen();
    }

    public Dimension getMaximumSize() {
        return this.delegate.getMaximumSize();
    }

    public Dimension getMinimumSize() {
        return this.delegate.getMinimumSize();
    }

    public Dialog.ModalExclusionType getModalExclusionType() {
        return this.delegate.getModalExclusionType();
    }

    public Dialog.ModalityType getModalityType() {
        return this.delegate.getModalityType();
    }

    public Component getMostRecentFocusOwner() {
        return this.delegate.getMostRecentFocusOwner();
    }

    public MouseListener[] getMouseListeners() {
        return this.delegate.getMouseListeners();
    }

    public MouseMotionListener[] getMouseMotionListeners() {
        return this.delegate.getMouseMotionListeners();
    }

    public Point getMousePosition() throws HeadlessException {
        return this.delegate.getMousePosition();
    }

    public Point getMousePosition(boolean allowChildren) throws HeadlessException {
        return this.delegate.getMousePosition(allowChildren);
    }

    public MouseWheelListener[] getMouseWheelListeners() {
        return this.delegate.getMouseWheelListeners();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public Window[] getOwnedWindows() {
        return this.delegate.getOwnedWindows();
    }

    public Window getOwner() {
        return this.delegate.getOwner();
    }

    public Container getParent() {
        return this.delegate.getParent();
    }

    public ComponentPeer getPeer() {
        return this.delegate.getPeer();
    }

    public Dimension getPreferredSize() {
        return this.delegate.getPreferredSize();
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.delegate.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.delegate.getPropertyChangeListeners(propertyName);
    }

    public JRootPane getRootPane() {
        return this.delegate.getRootPane();
    }

    public Dimension getSize() {
        return this.delegate.getSize();
    }

    public Dimension getSize(Dimension rv) {
        return this.delegate.getSize(rv);
    }

    public String getTitle() {
        return this.delegate.getTitle();
    }

    public Toolkit getToolkit() {
        return this.delegate.getToolkit();
    }

    public TransferHandler getTransferHandler() {
        return this.delegate.getTransferHandler();
    }

    public int getWidth() {
        return this.delegate.getWidth();
    }

    public WindowFocusListener[] getWindowFocusListeners() {
        return this.delegate.getWindowFocusListeners();
    }

    public WindowListener[] getWindowListeners() {
        return this.delegate.getWindowListeners();
    }

    public WindowStateListener[] getWindowStateListeners() {
        return this.delegate.getWindowStateListeners();
    }

    public int getX() {
        return this.delegate.getX();
    }

    public int getY() {
        return this.delegate.getY();
    }

    public boolean gotFocus(Event evt, Object what) {
        return this.delegate.gotFocus(evt, what);
    }

    public boolean handleEvent(Event evt) {
        return this.delegate.handleEvent(evt);
    }

    public boolean hasFocus() {
        return this.delegate.hasFocus();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public void hide() {
        this.delegate.hide();
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        return this.delegate.imageUpdate(img, infoflags, x, y, w, h);
    }

    public void invalidate() {
        this.delegate.invalidate();
    }

    public boolean isActive() {
        return this.delegate.isActive();
    }

    public boolean isAlwaysOnTopSupported() {
        return this.delegate.isAlwaysOnTopSupported();
    }

    public boolean isAncestorOf(Component c) {
        return this.delegate.isAncestorOf(c);
    }

    public boolean isBackgroundSet() {
        return this.delegate.isBackgroundSet();
    }

    public boolean isCursorSet() {
        return this.delegate.isCursorSet();
    }

    public boolean isDisplayable() {
        return this.delegate.isDisplayable();
    }

    public boolean isDoubleBuffered() {
        return this.delegate.isDoubleBuffered();
    }

    public boolean isEnabled() {
        return this.delegate.isEnabled();
    }

    public boolean isFocusable() {
        return this.delegate.isFocusable();
    }

    public boolean isFocusCycleRoot() {
        return this.delegate.isFocusCycleRoot();
    }

    public boolean isFocusCycleRoot(Container container) {
        return this.delegate.isFocusCycleRoot(container);
    }

    public boolean isFocused() {
        return this.delegate.isFocused();
    }

    public boolean isFocusOwner() {
        return this.delegate.isFocusOwner();
    }

    public boolean isFocusTraversable() {
        return this.delegate.isFocusTraversable();
    }

    public boolean isFocusTraversalPolicySet() {
        return this.delegate.isFocusTraversalPolicySet();
    }

    public boolean isFontSet() {
        return this.delegate.isFontSet();
    }

    public boolean isForegroundSet() {
        return this.delegate.isForegroundSet();
    }

    public boolean isLightweight() {
        return this.delegate.isLightweight();
    }

    public boolean isLocationByPlatform() {
        return this.delegate.isLocationByPlatform();
    }

    public boolean isMaximumSizeSet() {
        return this.delegate.isMaximumSizeSet();
    }

    public boolean isMinimumSizeSet() {
        return this.delegate.isMinimumSizeSet();
    }

    public boolean isModal() {
        return this.delegate.isModal();
    }

    public boolean isOpaque() {
        return this.delegate.isOpaque();
    }

    public boolean isPreferredSizeSet() {
        return this.delegate.isPreferredSizeSet();
    }

    public boolean isResizable() {
        return this.delegate.isResizable();
    }

    public boolean isShowing() {
        return this.delegate.isShowing();
    }

    public boolean isUndecorated() {
        return this.delegate.isUndecorated();
    }

    public boolean isValid() {
        return this.delegate.isValid();
    }

    public boolean isVisible() {
        return this.delegate.isVisible();
    }

    public boolean keyDown(Event evt, int key) {
        return this.delegate.keyDown(evt, key);
    }

    public boolean keyUp(Event evt, int key) {
        return this.delegate.keyUp(evt, key);
    }

    public void layout() {
        this.delegate.layout();
    }

    public void list() {
        this.delegate.list();
    }

    public void list(PrintStream out, int indent) {
        this.delegate.list(out, indent);
    }

    public void list(PrintStream out) {
        this.delegate.list(out);
    }

    public void list(PrintWriter out, int indent) {
        this.delegate.list(out, indent);
    }

    public void list(PrintWriter out) {
        this.delegate.list(out);
    }

    public Component locate(int x, int y) {
        return this.delegate.locate(x, y);
    }

    public Point location() {
        return this.delegate.location();
    }

    public boolean lostFocus(Event evt, Object what) {
        return this.delegate.lostFocus(evt, what);
    }

    public Dimension minimumSize() {
        return this.delegate.minimumSize();
    }

    public boolean mouseDown(Event evt, int x, int y) {
        return this.delegate.mouseDown(evt, x, y);
    }

    public boolean mouseDrag(Event evt, int x, int y) {
        return this.delegate.mouseDrag(evt, x, y);
    }

    public boolean mouseEnter(Event evt, int x, int y) {
        return this.delegate.mouseEnter(evt, x, y);
    }

    public boolean mouseExit(Event evt, int x, int y) {
        return this.delegate.mouseExit(evt, x, y);
    }

    public boolean mouseMove(Event evt, int x, int y) {
        return this.delegate.mouseMove(evt, x, y);
    }

    public boolean mouseUp(Event evt, int x, int y) {
        return this.delegate.mouseUp(evt, x, y);
    }

    public void move(int x, int y) {
        this.delegate.move(x, y);
    }

    public void nextFocus() {
        this.delegate.nextFocus();
    }

    public void pack() {
        this.delegate.pack();
    }

    public void paint(Graphics g) {
        this.delegate.paint(g);
    }

    public void paintAll(Graphics g) {
        this.delegate.paintAll(g);
    }

    public void paintComponents(Graphics g) {
        this.delegate.paintComponents(g);
    }

    public boolean postEvent(Event e) {
        return this.delegate.postEvent(e);
    }

    public Dimension preferredSize() {
        return this.delegate.preferredSize();
    }

    public boolean prepareImage(Image image, ImageObserver observer) {
        return this.delegate.prepareImage(image, observer);
    }

    public boolean prepareImage(Image image, int width, int height, ImageObserver observer) {
        return this.delegate.prepareImage(image, width, height, observer);
    }

    public void print(Graphics g) {
        this.delegate.print(g);
    }

    public void printAll(Graphics g) {
        this.delegate.printAll(g);
    }

    public void printComponents(Graphics g) {
        this.delegate.printComponents(g);
    }

    public void remove(Component comp) {
        this.delegate.remove(comp);
    }

    public void remove(int index) {
        this.delegate.remove(index);
    }

    public void remove(MenuComponent popup) {
        this.delegate.remove(popup);
    }

    public void removeAll() {
        this.delegate.removeAll();
    }

    public void removeComponentListener(ComponentListener l) {
        this.delegate.removeComponentListener(l);
    }

    public void removeContainerListener(ContainerListener l) {
        this.delegate.removeContainerListener(l);
    }

    public void removeFocusListener(FocusListener l) {
        this.delegate.removeFocusListener(l);
    }

    public void removeHierarchyBoundsListener(HierarchyBoundsListener l) {
        this.delegate.removeHierarchyBoundsListener(l);
    }

    public void removeHierarchyListener(HierarchyListener l) {
        this.delegate.removeHierarchyListener(l);
    }

    public void removeInputMethodListener(InputMethodListener l) {
        this.delegate.removeInputMethodListener(l);
    }

    public void removeKeyListener(KeyListener l) {
        this.delegate.removeKeyListener(l);
    }

    public void removeMouseListener(MouseListener l) {
        this.delegate.removeMouseListener(l);
    }

    public void removeMouseMotionListener(MouseMotionListener l) {
        this.delegate.removeMouseMotionListener(l);
    }

    public void removeMouseWheelListener(MouseWheelListener l) {
        this.delegate.removeMouseWheelListener(l);
    }

    public void removeNotify() {
        this.delegate.removeNotify();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.delegate.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.delegate.removePropertyChangeListener(propertyName, listener);
    }

    public void removeWindowFocusListener(WindowFocusListener l) {
        this.delegate.removeWindowFocusListener(l);
    }

    public void removeWindowListener(WindowListener l) {
        this.delegate.removeWindowListener(l);
    }

    public void removeWindowStateListener(WindowStateListener l) {
        this.delegate.removeWindowStateListener(l);
    }

    public void repaint() {
        this.delegate.repaint();
    }

    public void repaint(int x, int y, int width, int height) {
        this.delegate.repaint(x, y, width, height);
    }

    public void repaint(long time, int x, int y, int width, int height) {
        this.delegate.repaint(time, x, y, width, height);
    }

    public void repaint(long tm) {
        this.delegate.repaint(tm);
    }

    public void requestFocus() {
        this.delegate.requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.delegate.requestFocusInWindow();
    }

    public void reshape(int x, int y, int width, int height) {
        this.delegate.reshape(x, y, width, height);
    }

    public void resize(Dimension d) {
        this.delegate.resize(d);
    }

    public void resize(int width, int height) {
        this.delegate.resize(width, height);
    }

    public void setBackground(Color c) {
        this.delegate.setBackground(c);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.delegate.setBounds(x, y, width, height);
    }

    public void setBounds(Rectangle r) {
        this.delegate.setBounds(r);
    }

    public void setComponentOrientation(ComponentOrientation o) {
        this.delegate.setComponentOrientation(o);
    }

    public void setComponentZOrder(Component comp, int index) {
        this.delegate.setComponentZOrder(comp, index);
    }

    public void setContentPane(Container contentPane) {
        this.delegate.setContentPane(contentPane);
    }

    public void setCursor(Cursor cursor) {
        this.delegate.setCursor(cursor);
    }

    public void setDefaultCloseOperation(int operation) {
        this.delegate.setDefaultCloseOperation(operation);
    }

    public void setDropTarget(DropTarget dt) {
        this.delegate.setDropTarget(dt);
    }

    public void setEnabled(boolean b) {
        this.delegate.setEnabled(b);
    }

    public void setFocusable(boolean focusable) {
        this.delegate.setFocusable(focusable);
    }

    public void setFocusableWindowState(boolean focusableWindowState) {
        this.delegate.setFocusableWindowState(focusableWindowState);
    }

    public void setFocusCycleRoot(boolean focusCycleRoot) {
        this.delegate.setFocusCycleRoot(focusCycleRoot);
    }

    public void setFocusTraversalKeys(int id, Set<? extends AWTKeyStroke> keystrokes) {
        this.delegate.setFocusTraversalKeys(id, keystrokes);
    }

    public void setFocusTraversalKeysEnabled(boolean focusTraversalKeysEnabled) {
        this.delegate.setFocusTraversalKeysEnabled(focusTraversalKeysEnabled);
    }

    public void setFocusTraversalPolicy(FocusTraversalPolicy policy) {
        this.delegate.setFocusTraversalPolicy(policy);
    }

    public void setFont(Font f) {
        this.delegate.setFont(f);
    }

    public void setForeground(Color c) {
        this.delegate.setForeground(c);
    }

    public void setGlassPane(Component glassPane) {
        this.delegate.setGlassPane(glassPane);
    }

    public void setIconImage(Image image) {
        this.delegate.setIconImage(image);
    }

    public void setIconImages(List<? extends Image> icons) {
        this.delegate.setIconImages(icons);
    }

    public void setIgnoreRepaint(boolean ignoreRepaint) {
        this.delegate.setIgnoreRepaint(ignoreRepaint);
    }

    public void setJMenuBar(JMenuBar menu) {
        this.delegate.setJMenuBar(menu);
    }

    public void setLayeredPane(JLayeredPane layeredPane) {
        this.delegate.setLayeredPane(layeredPane);
    }

    public void setLayout(LayoutManager manager) {
        this.delegate.setLayout(manager);
    }

    public void setLocale(Locale l) {
        this.delegate.setLocale(l);
    }

    public void setLocation(int x, int y) {
        this.delegate.setLocation(x, y);
    }

    public void setLocation(Point p) {
        this.delegate.setLocation(p);
    }

    public void setLocationByPlatform(boolean locationByPlatform) {
        this.delegate.setLocationByPlatform(locationByPlatform);
    }

    public void setLocationRelativeTo(Component c) {
        this.delegate.setLocationRelativeTo(c);
    }

    public void setMaximumSize(Dimension maximumSize) {
        this.delegate.setMaximumSize(maximumSize);
    }

    public void setMinimumSize(Dimension minimumSize) {
        this.delegate.setMinimumSize(minimumSize);
    }

    public void setModal(boolean modal) {
        this.delegate.setModal(modal);
    }

    public void setModalExclusionType(Dialog.ModalExclusionType exclusionType) {
        this.delegate.setModalExclusionType(exclusionType);
    }

    public void setModalityType(Dialog.ModalityType type) {
        this.delegate.setModalityType(type);
    }

    public void setName(String name) {
        this.delegate.setName(name);
    }

    public void setPreferredSize(Dimension preferredSize) {
        this.delegate.setPreferredSize(preferredSize);
    }

    public void setResizable(boolean resizable) {
        this.delegate.setResizable(resizable);
    }

    public void setSize(Dimension d) {
        this.delegate.setSize(d);
    }

    public void setSize(int width, int height) {
        this.delegate.setSize(width, height);
    }

    public void setTitle(String title) {
        this.delegate.setTitle(title);
    }

    public void setTransferHandler(TransferHandler newHandler) {
        this.delegate.setTransferHandler(newHandler);
    }

    public void setUndecorated(boolean undecorated) {
        this.delegate.setUndecorated(undecorated);
    }

    public void setVisible(boolean b) {
        this.delegate.setVisible(b);
    }

    public void show() {
        this.delegate.show();
    }

    public void show(boolean b) {
        this.delegate.show(b);
    }

    public Dimension size() {
        return this.delegate.size();
    }

    public void toBack() {
        this.delegate.toBack();
    }

    public void toFront() {
        this.delegate.toFront();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void transferFocus() {
        this.delegate.transferFocus();
    }

    public void transferFocusBackward() {
        this.delegate.transferFocusBackward();
    }

    public void transferFocusDownCycle() {
        this.delegate.transferFocusDownCycle();
    }

    public void transferFocusUpCycle() {
        this.delegate.transferFocusUpCycle();
    }

    public void update(Graphics g) {
        this.delegate.update(g);
    }

    public void validate() {
        this.delegate.validate();
    }

    public static void main(String[] args) {
        GraphAnimator.displayGraphFromFile("samples/mml2.mml");
    }
}

