/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.pl;

import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.enfin.squad.bl.AbstractGraphNode;

public class InitialStateTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    String[] columnNames = new String[]{"Display", "Name", "State", "Decay", "Gain"};
    AbstractGraphNode[] nodeList;

    public InitialStateTableModel() {
    }

    public InitialStateTableModel(AbstractGraphNode[] nodes) {
        this.nodeList = nodes;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.nodeList.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        AbstractGraphNode nd = this.nodeList[row];
        switch (col) {
            case 0: {
                return nd.isVisible();
            }
            case 1: {
                return nd.getName();
            }
            case 2: {
                return nd.getInitialState();
            }
            case 3: {
                return nd.getInitialDecay();
            }
            case 4: {
                return nd.getInitialGain();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        AbstractGraphNode myNode = this.nodeList[rowIndex];
        switch (columnIndex) {
            case 0: {
                myNode.setVisible((Boolean)aValue);
                super.setValueAt(aValue, rowIndex, columnIndex);
                break;
            }
            case 2: {
                myNode.setInitialState((Double)aValue, true);
                super.setValueAt(aValue, rowIndex, columnIndex);
                break;
            }
            case 3: {
                myNode.setInitialDecay((Double)aValue, true);
                super.setValueAt(aValue, rowIndex, columnIndex);
                break;
            }
            case 4: {
                myNode.setInitialGain((Double)aValue, true);
                super.setValueAt(aValue, rowIndex, columnIndex);
            }
        }
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return true;
        }
        return col >= 2;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public static void changeDisplay(JTable table) {
    }
}

