/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.pl;

import java.awt.Color;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.enfin.squad.pl.PlotColorDataContainer;

public class LineColorDispatcher {
    static Color[] lineColors = new Color[]{Color.red, Color.green, Color.blue, Color.yellow.darker(), Color.black, Color.cyan, Color.lightGray, Color.magenta, Color.darkGray, Color.orange, Color.pink};
    static Shape[] shapesLegend = new Shape[]{new Ellipse2D.Double(9.5, 1.0, 10.0, 10.0), new Rectangle2D.Double(9.5, 1.0, 10.0, 10.0), LineColorDispatcher.getTriangleDownLegend(), LineColorDispatcher.getTriangleUpLegend(), LineColorDispatcher.getRectHorizLegend(), LineColorDispatcher.getRectVertLegend(), LineColorDispatcher.getTriangleRight(), LineColorDispatcher.getRhomboidLegend()};
    static Shape[] shapesPlot = new Shape[]{new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0), new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0), LineColorDispatcher.getTriangleDownPlot(), LineColorDispatcher.getTriangleUpPLot(), LineColorDispatcher.getRectHorizPlot(), LineColorDispatcher.getRectVertPlot(), LineColorDispatcher.getTriangleRightPlot(), LineColorDispatcher.getRhomboidPlot()};

    public static void main(String[] args) {
    }

    public static Color colorFromString(String str, int colorShader, boolean reverse) {
        String strHexValues;
        Integer intValues;
        if (str.length() > 3) {
            str = str.trim().substring(0, 3);
        }
        String strValues = "";
        if (!reverse) {
            char[] arr$ = str.toCharArray();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Character cr = Character.valueOf(arr$[i$]);
                strValues = strValues + Integer.toString(Character.getNumericValue(cr.charValue()));
            }
        } else {
            char[] chrSet = str.toCharArray();
            for (int x = chrSet.length - 1; x > -1; --x) {
                strValues = strValues + Integer.toString(Character.getNumericValue(chrSet[x]));
            }
        }
        if ((strValues = strValues.replace("-", "")).length() > 15) {
            intValues = Integer.parseInt(strValues.substring(0, 15)) * colorShader;
            strHexValues = Integer.toHexString(intValues);
        } else {
            intValues = Integer.parseInt(strValues) * colorShader;
            strHexValues = Integer.toHexString(intValues);
        }
        while (strHexValues.length() < 6) {
            strHexValues = "0" + strHexValues;
        }
        String strOneSet = strHexValues.substring(2, 5);
        Integer intRed = Integer.parseInt(strOneSet, 16);
        Color c = new Color(intValues);
        return c;
    }

    public static PlotColorDataContainer getPlotColorDataFromName(String name) {
        PlotColorDataContainer pltCol = new PlotColorDataContainer();
        pltCol.markerColor = LineColorDispatcher.colorFromString(name, 50, false);
        pltCol.lineColor = LineColorDispatcher.colorFromString(name, 10, true);
        pltCol.markerShape = LineColorDispatcher.getShapeForPlot(name.length());
        pltCol.legendrShape = LineColorDispatcher.getShapeForLegend(name.length());
        return pltCol;
    }

    public static PlotColorDataContainer getPlotColorDataFromIndex(int index) {
        PlotColorDataContainer pltCol = new PlotColorDataContainer();
        pltCol.markerColor = LineColorDispatcher.getFillColor(index);
        pltCol.lineColor = LineColorDispatcher.getLineColor(index);
        pltCol.markerShape = LineColorDispatcher.getShapeForPlot(index);
        pltCol.legendrShape = LineColorDispatcher.getShapeForLegend(index);
        return pltCol;
    }

    public static Color getLineColor(int index) {
        if (index < lineColors.length) {
            return lineColors[index];
        }
        if (index == lineColors.length) {
            return lineColors[0];
        }
        Integer repeat = index / lineColors.length;
        Integer relIndex = index - repeat * lineColors.length;
        return lineColors[relIndex];
    }

    public static Color getFillColor(int index) {
        if (index < lineColors.length) {
            return lineColors[index];
        }
        if (index == lineColors.length) {
            return lineColors[0];
        }
        if (index >= lineColors.length * shapesPlot.length) {
            Integer repeat = index / lineColors.length;
            Integer relIndex = index - repeat * lineColors.length + 1;
            if (relIndex >= lineColors.length) {
                relIndex = 0;
            }
            return lineColors[relIndex];
        }
        Integer repeat = index / lineColors.length;
        Integer relIndex = index - repeat * lineColors.length;
        return lineColors[relIndex];
    }

    public static Shape getShapeForPlot(Integer index) {
        if (index < shapesPlot.length) {
            return shapesPlot[index];
        }
        if (index == shapesPlot.length) {
            return shapesPlot[0];
        }
        Integer repeat = index / shapesPlot.length;
        Integer relIndex = index - repeat * shapesPlot.length;
        return shapesPlot[relIndex];
    }

    public static Shape getShapeForLegend(int index) {
        if (index < shapesLegend.length) {
            return shapesLegend[index];
        }
        if (index == shapesLegend.length) {
            return shapesLegend[0];
        }
        Integer repeat = index / shapesLegend.length;
        Integer relIndex = index - repeat * shapesLegend.length;
        return shapesLegend[relIndex];
    }

    private static Shape getTriangleUpLegend() {
        Polygon poly = new Polygon();
        poly.addPoint(15, 0);
        poly.addPoint(9, 13);
        poly.addPoint(22, 13);
        return poly;
    }

    private static Shape getTriangleRight() {
        Polygon poly = new Polygon();
        poly.addPoint(9, 0);
        poly.addPoint(9, 13);
        poly.addPoint(22, 6);
        return poly;
    }

    private static Shape getRectHorizLegend() {
        Rectangle2D.Double rec = new Rectangle2D.Double(9.5, 1.0, 10.0, 5.0);
        return rec;
    }

    private static Shape getRectVertLegend() {
        Rectangle2D.Double rec = new Rectangle2D.Double(9.5, 1.0, 5.0, 10.0);
        return rec;
    }

    private static Shape getRhomboidLegend() {
        Polygon poly = new Polygon();
        poly.addPoint(15, 0);
        poly.addPoint(9, 6);
        poly.addPoint(15, 13);
        poly.addPoint(22, 6);
        return poly;
    }

    private static Shape getTriangleDownLegend() {
        Polygon poly = new Polygon();
        poly.addPoint(9, 0);
        poly.addPoint(22, 0);
        poly.addPoint(15, 13);
        return poly;
    }

    private static Shape getTriangleUpPLot() {
        Polygon poly = new Polygon();
        poly.addPoint(0, -4);
        poly.addPoint(-5, 6);
        poly.addPoint(5, 6);
        return poly;
    }

    private static Shape getTriangleDownPlot() {
        Polygon poly = new Polygon();
        poly.addPoint(-5, -3);
        poly.addPoint(5, -3);
        poly.addPoint(0, 7);
        return poly;
    }

    private static Shape getTriangleRightPlot() {
        Polygon poly = new Polygon();
        poly.addPoint(-5, -5);
        poly.addPoint(-5, 5);
        poly.addPoint(5, 0);
        return poly;
    }

    private static Shape getRectHorizPlot() {
        Rectangle2D.Double rec = new Rectangle2D.Double(-4.0, -2.0, 8.0, 4.0);
        return rec;
    }

    private static Shape getRectVertPlot() {
        Rectangle2D.Double rec = new Rectangle2D.Double(-2.0, -4.0, 4.0, 8.0);
        return rec;
    }

    private static Shape getRhomboidPlot() {
        Polygon poly = new Polygon();
        poly.addPoint(0, -4);
        poly.addPoint(-5, 1);
        poly.addPoint(0, 6);
        poly.addPoint(5, 1);
        return poly;
    }
}

