/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.dcolt;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.AbstractMatrix2D;
import cern.colt.matrix.impl.RCDoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.jet.math.Functions;
import com.tlabs.dcolt.BlockDenseDoubleMatrix2D;
import com.tlabs.dcolt.DynamicDoubleFactory2D;
import com.tlabs.dcolt.DynamicDoubleMatrix2D;
import com.tlabs.dcolt.ProxiedMatrix;
import com.tlabs.dcolt.ProxyDirectImplementation;
import org.apache.log4j.Logger;

abstract class BlockDoubleMatrix2D
extends DynamicDoubleMatrix2D {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$tlabs$dcolt$BlockDoubleMatrix2D == null ? (class$com$tlabs$dcolt$BlockDoubleMatrix2D = BlockDoubleMatrix2D.class$("com.tlabs.dcolt.BlockDoubleMatrix2D")) : class$com$tlabs$dcolt$BlockDoubleMatrix2D));
    protected static final int DEFAULT_TILE_SIZE = 1400;
    protected int blockRowSize;
    protected int blockColSize;
    static /* synthetic */ Class class$com$tlabs$dcolt$BlockDoubleMatrix2D;

    protected BlockDoubleMatrix2D(int rowsize, int colsize) {
        this.blockRowSize = rowsize;
        this.blockColSize = colsize;
    }

    public Object clone() {
        this.ensureCapacity(this.rows, this.columns);
        return super.clone();
    }

    public void extendTo(int rows, int columns) {
        this.setUp(rows, columns);
    }

    protected abstract void ensureCapacity(int var1, int var2);

    protected void internalSetDiskMode() {
        int r = this.internalStorageRows();
        for (int i = 0; i < r; ++i) {
            int c = this.internalStorageColumns();
            for (int j = 0; j < c; ++j) {
                ProxyDirectImplementation proxy = this.internalGetProxy(i, j);
                if (proxy == null) continue;
                proxy.setDiskMode();
            }
        }
    }

    protected void internalSetMemoryMode() {
        int r = this.internalStorageRows();
        for (int i = 0; i < r; ++i) {
            int c = this.internalStorageColumns();
            for (int j = 0; j < c; ++j) {
                ProxyDirectImplementation proxy = this.internalGetProxy(i, j);
                if (proxy == null) continue;
                proxy.setMemoryMode();
            }
        }
    }

    protected abstract DoubleMatrix2D internalGetStorage(int var1, int var2);

    protected abstract ProxyDirectImplementation internalGetProxy(int var1, int var2);

    protected abstract int internalStorageRows();

    protected abstract int internalStorageColumns();

    protected abstract void internalVDiceStorage();

    public void logBatchState() {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        int br = -1;
        int bc = -1;
        ProxiedMatrix cache = this.logCacheState();
        StringBuffer buf = new StringBuffer(DynamicDoubleFactory2D.identityToString(this) + " logging batch state\n");
        int r = this.internalStorageRows();
        for (int i = 0; i < r; ++i) {
            int c = this.internalStorageColumns();
            for (int j = 0; j < c; ++j) {
                ProxyDirectImplementation store = this.internalGetProxy(i, j);
                if (cache != null && cache == store) {
                    br = i;
                    bc = j;
                }
                buf.append(DynamicDoubleFactory2D.identityToString(store));
                buf.append(" [");
                buf.append(store == null ? 0 : store.getBatch());
                buf.append("] ");
            }
            buf.append('\n');
        }
        LOG.debug((Object)buf.toString());
        if (cache != null) {
            LOG.debug((Object)(DynamicDoubleFactory2D.identityToString(this) + " cache at [" + br + ", " + bc + "]"));
        }
    }

    protected DoubleMatrix2D getStorage(int sr, int sc) {
        int tile0row = this.rowZero / this.blockRowSize;
        int tile0col = this.columnZero / this.blockColSize;
        int tile0row0 = this.rowZero % this.blockRowSize;
        int tile0col0 = this.columnZero % this.blockColSize;
        int rowN = this.rowZero + (this.rows - 1) * this.rowStride;
        int columnN = this.columnZero + (this.columns - 1) * this.columnStride;
        int tileNrow = rowN / this.blockRowSize;
        int tileNcol = columnN / this.blockColSize;
        int tileNrowN = rowN % this.blockRowSize;
        int tileNcolumnN = columnN % this.blockColSize;
        int tileRow0 = 0;
        int tileColumn0 = 0;
        int tileRowN = this.blockRowSize - 1;
        int tileColumnN = this.blockColSize - 1;
        if (sr == 0) {
            tileRow0 = tile0row0;
        }
        if (sr == tileNrow) {
            tileRowN = tileNrowN;
        }
        if (sc == 0) {
            tileColumn0 = tile0col0;
        }
        if (sc == tileNcol) {
            tileColumnN = tileNcolumnN;
        }
        int tileRows = tileRowN - tileRow0 + 1;
        int tileColumns = tileColumnN - tileColumn0 + 1;
        int tileRow = tile0row + sr;
        int tileColumn = tile0col + sc;
        this.ensureStorageBlock(tileRow, tileColumn);
        return this.internalGetStorage(tileRow, tileColumn).viewPart(tileRow0, tileColumn0, tileRows, tileColumns);
    }

    protected DoubleMatrix2D getStorage(int sr, int sc, DoubleMatrix2D B) {
        return this.getStorage(sr, sc, B, this.blockRowSize, this.blockColSize, this.rowZero, this.columnZero);
    }

    protected DoubleMatrix2D getStorage(int sr, int sc, DoubleMatrix2D B, int brSize, int bcSize) {
        return this.getStorage(sr, sc, B, brSize, bcSize, 0, 0);
    }

    protected DoubleMatrix2D getStorage(int sr, int sc, DoubleMatrix2D B, int brSize, int bcSize, int r0, int c0) {
        int btrow0;
        if (B instanceof BlockDoubleMatrix2D) {
            BlockDoubleMatrix2D db = (BlockDoubleMatrix2D)B;
            if (db.blockRowSize == bcSize && db.blockColSize == brSize) {
                return db.getStorage(sr, sc);
            }
        }
        int tile0row = r0 / brSize;
        int tile0col = c0 / bcSize;
        int tile0row0 = r0 % brSize;
        int tile0col0 = c0 % bcSize;
        int rowN = r0 + B.rows() * this.rowStride - 1;
        int columnN = c0 + B.columns() * this.columnStride - 1;
        int tileNrow = rowN / brSize;
        int tileNcol = columnN / bcSize;
        int tileNrowN = rowN % brSize;
        int tileNcolumnN = columnN % bcSize;
        int tileRow0 = 0;
        int tileColumn0 = 0;
        int tileRowN = brSize - 1;
        int tileColumnN = bcSize - 1;
        if (sr == 0) {
            tileRow0 = tile0row0;
        }
        if (sr == tileNrow) {
            tileRowN = tileNrowN;
        }
        if (sc == 0) {
            tileColumn0 = tile0col0;
        }
        if (sc == tileNcol) {
            tileColumnN = tileNcolumnN;
        }
        int tileRows = tileRowN - tileRow0 + 1;
        int tileColumns = tileColumnN - tileColumn0 + 1;
        int n = sr == 0 ? 0 : (btrow0 = (sr - (tile0row == 0 ? 0 : 1)) * brSize + tile0row - r0);
        int btcol0 = sc == 0 ? 0 : (sc - (tile0col == 0 ? 0 : 1)) * bcSize + tile0col - c0;
        return B.viewPart(btrow0 / this.rowStride, btcol0 / this.columnStride, tileRows / this.rowStride, tileColumns / this.columnStride);
    }

    protected int getStorageColumns() {
        return (this.columnZero + (this.columns - 1) * this.columnStride) / this.blockColSize - this.columnZero / this.blockColSize + 1;
    }

    protected int getStorageRows() {
        return (this.rowZero + (this.rows - 1) * this.rowStride) / this.blockRowSize - this.rowZero / this.blockRowSize + 1;
    }

    protected void ensureStorage(int nbrows, int nbcols) {
        int sr = (nbrows - 1) / this.blockRowSize;
        int sc = (nbcols - 1) / this.blockColSize;
        for (int i = 0; i <= sr; ++i) {
            for (int j = 0; j <= sc; ++j) {
                this.ensureStorageBlock(i, j);
            }
        }
    }

    protected abstract void ensureStorageBlock(int var1, int var2);

    public boolean equals(Object obj) {
        if (this.rowStride != 1 || this.columnStride != 1) {
            return super.equals(obj);
        }
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DoubleMatrix2D)) {
            return false;
        }
        DoubleMatrix2D mat = (DoubleMatrix2D)obj;
        this.prepareBatchOperation();
        if (mat instanceof ProxiedMatrix) {
            ((ProxiedMatrix)mat).prepareBatchOperation();
        }
        boolean b = true;
        int i = this.getStorageRows();
        block0: while (--i >= 0) {
            int j = this.getStorageColumns();
            while (--j >= 0) {
                DoubleMatrix2D blockB;
                DoubleMatrix2D blockA = this.getStorage(i, j);
                if (blockA.equals((Object)(blockB = this.getStorage(i, j, mat)))) continue;
                b = false;
                break block0;
            }
        }
        this.endBatchOperation();
        if (mat instanceof ProxiedMatrix) {
            ((ProxiedMatrix)mat).endBatchOperation();
        }
        return b;
    }

    public double getQuick(int row, int column) {
        int realrow = this.rowZero + row * this.rowStride;
        int realcolumn = this.columnZero + column * this.columnStride;
        int rowtile = realrow / this.blockRowSize;
        int coltile = realcolumn / this.blockColSize;
        if (rowtile >= this.internalStorageRows() || coltile >= this.internalStorageColumns()) {
            return 0.0;
        }
        DoubleMatrix2D proxiedMatrixImp = this.internalGetStorage(rowtile, coltile);
        if (proxiedMatrixImp == null) {
            return 0.0;
        }
        int rownb = realrow % this.blockRowSize;
        int colnb = realcolumn % this.blockColSize;
        return proxiedMatrixImp.getQuick(rownb, colnb);
    }

    public void setQuick(int row, int column, double value) {
        int realrow = this.rowZero + row * this.rowStride;
        int rowtile = realrow / this.blockRowSize;
        int realcolumn = this.columnZero + column * this.columnStride;
        int coltile = realcolumn / this.blockColSize;
        DoubleMatrix2D proxiedMatrixImp = this.internalGetStorage(rowtile, coltile);
        if (proxiedMatrixImp == null) {
            if (value == 0.0) {
                return;
            }
            this.ensureStorage(realrow + 1, realcolumn + 1);
            proxiedMatrixImp = this.internalGetStorage(rowtile, coltile);
        }
        int rownb = realrow % this.blockRowSize;
        int colnb = realcolumn % this.blockColSize;
        proxiedMatrixImp.setQuick(rownb, colnb, value);
    }

    protected void setUp(int rows, int columns) {
        super.setUp(rows, columns);
        this.rowStride = 1;
        this.columnStride = 1;
        this.ensureCapacity(rows, columns);
    }

    protected AbstractMatrix2D vDice() {
        super.vDice();
        int t = this.blockRowSize;
        this.blockRowSize = this.blockColSize;
        this.blockColSize = t;
        this.internalVDiceStorage();
        return this;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D B, DoubleMatrix2D C, double alpha, double beta, boolean transposeA, boolean transposeB) {
        if (this.rowStride != 1 || this.columnStride != 1) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (transposeA) {
            return this.viewDice().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (!this.diskMode && (B instanceof SparseDoubleMatrix2D || B instanceof RCDoubleMatrix2D)) {
            if (C == null) {
                this.prepareBatchOperation();
                DoubleMatrix2D doubleMatrix2D = B.zMult((DoubleMatrix2D)this, null, alpha, beta, !transposeB, true).viewDice();
                this.endBatchOperation();
                return doubleMatrix2D;
            }
            this.prepareBatchOperation();
            if (C instanceof ProxiedMatrix) {
                ((ProxiedMatrix)C).prepareBatchOperation();
                if (C instanceof DynamicDoubleMatrix2D) {
                    ((DynamicDoubleMatrix2D)C).ensureStorage();
                }
            }
            DoubleMatrix2D c = C.viewDice();
            B.zMult((DoubleMatrix2D)this, c, alpha, beta, !transposeB, true);
            this.endBatchOperation();
            if (C instanceof ProxiedMatrix) {
                if (C instanceof ProxyDirectImplementation) {
                    ((ProxyDirectImplementation)C).flagAsModified();
                }
                ((ProxiedMatrix)C).endBatchOperation();
            }
            return C;
        }
        if (transposeB) {
            return this.zMult(B.viewDice(), C, alpha, beta, transposeA, false);
        }
        int m = this.rows;
        int n = this.columns;
        int p = B.columns();
        boolean cCreated = false;
        if (C == null) {
            C = this.like(m, p);
            cCreated = true;
        }
        if (B.rows() != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != m || C.columns() != p) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        int dm = this.getStorageRows();
        int dn = this.getStorageColumns();
        int dp = (B.columns() - 1) / this.blockRowSize + 1;
        BlockDoubleMatrix2D dC = C instanceof BlockDoubleMatrix2D && (cCreated || beta == 0.0) ? (BlockDoubleMatrix2D)C : new BlockDenseDoubleMatrix2D(C.rows(), C.columns(), this.blockRowSize, this.blockRowSize);
        if (C instanceof ProxiedMatrix && ((ProxiedMatrix)C).isDiskMode()) {
            dC.setDiskMode();
        }
        this.prepareBatchOperation();
        if (B instanceof ProxiedMatrix) {
            ((ProxiedMatrix)B).prepareBatchOperation();
        }
        dC.prepareBatchOperation();
        dC.ensureStorage();
        int j = dp;
        while (--j >= 0) {
            int i = dm;
            while (--i >= 0) {
                DoubleMatrix2D cs = this.getStorage(i, j, dC, this.blockRowSize, this.blockRowSize);
                int k = dn;
                while (--k >= 0) {
                    DoubleMatrix2D as = this.getStorage(i, k);
                    DoubleMatrix2D bs = this.getStorage(k, j, B, this.blockColSize, this.blockRowSize);
                    as.zMult(bs, cs, alpha, 1.0, transposeA, transposeB);
                }
            }
        }
        if (dC != C) {
            C.assign(Functions.mult((double)beta)).assign((DoubleMatrix2D)dC, Functions.plus);
            dC.endBatchOperation();
            dC.dispose();
        } else {
            dC.endBatchOperation();
        }
        if (B instanceof ProxiedMatrix) {
            ((ProxiedMatrix)B).endBatchOperation();
        }
        this.endBatchOperation();
        return C;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

