/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.dcolt;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import com.tlabs.dcolt.BlockDenseDoubleMatrix2D;
import com.tlabs.dcolt.BlockSparseDoubleMatrix2D;
import com.tlabs.dcolt.DecoratedDoubleMatrix2D;
import com.tlabs.dcolt.DynamicDoubleMatrix2D;
import com.tlabs.dcolt.DynamicStringVector;
import com.tlabs.dcolt.ProxiedMatrix;
import com.tlabs.dcolt.bench.Benchmark;
import com.tlabs.util.Resource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DynamicDoubleFactory2D
extends DoubleFactory2D {
    public static final DynamicDoubleFactory2D rowdynamic_dense;
    public static final DynamicDoubleFactory2D rowdynamic_sparse;
    public static final DynamicDoubleFactory2D fulldynamic_dense;
    public static final DynamicDoubleFactory2D fulldynamic_sparse;
    private static Map identityMap;

    protected DynamicDoubleFactory2D() {
    }

    public DecoratedDoubleMatrix2D makeDecorated(int rows, int columns) {
        if (this == rowdynamic_dense) {
            return new DecoratedDoubleMatrix2D(new BlockDenseDoubleMatrix2D(rows, columns), new DynamicStringVector(columns), new DynamicStringVector(), new Properties());
        }
        if (this == rowdynamic_sparse) {
            return new DecoratedDoubleMatrix2D(new BlockSparseDoubleMatrix2D(rows, columns), new DynamicStringVector(columns), new DynamicStringVector(), new Properties());
        }
        if (this == fulldynamic_dense) {
            return new DecoratedDoubleMatrix2D(new BlockDenseDoubleMatrix2D(rows, columns, 1400, 1400), new DynamicStringVector(), new DynamicStringVector(), new Properties());
        }
        if (this == fulldynamic_sparse) {
            return new DecoratedDoubleMatrix2D(new BlockSparseDoubleMatrix2D(rows, columns, 1400, 1400), new DynamicStringVector(), new DynamicStringVector(), new Properties());
        }
        throw new IllegalStateException("Error in call to static factory");
    }

    public DoubleMatrix2D make(int rows, int columns) {
        if (this == rowdynamic_dense) {
            return new BlockDenseDoubleMatrix2D(rows, columns);
        }
        if (this == rowdynamic_sparse) {
            return new BlockSparseDoubleMatrix2D(rows, columns);
        }
        if (this == fulldynamic_dense) {
            return new BlockDenseDoubleMatrix2D(rows, columns, 1400, 1400);
        }
        if (this == fulldynamic_sparse) {
            return new BlockSparseDoubleMatrix2D(rows, columns, 1400, 1400);
        }
        throw new IllegalStateException("Error in call to static factory");
    }

    public DoubleMatrix2D make(double[][] values) {
        if (this == rowdynamic_dense) {
            return new BlockDenseDoubleMatrix2D(values);
        }
        if (this == rowdynamic_sparse) {
            return new BlockSparseDoubleMatrix2D(values);
        }
        throw new IllegalStateException("Error in call to static factory");
    }

    public static DoubleMatrix2D zMult(DoubleMatrix2D A, DoubleMatrix2D B, DoubleMatrix2D C) {
        return DynamicDoubleFactory2D.zMult(A, B, C, 1.0, C == null ? 1 : 0, false, false);
    }

    public static DoubleMatrix2D zMult(DoubleMatrix2D A, DoubleMatrix2D B, DoubleMatrix2D C, double alpha, double beta, boolean transposeA, boolean transposeB) {
        if (A instanceof ProxiedMatrix || !(B instanceof ProxiedMatrix)) {
            return A.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (C == null) {
            return B.zMult(A, null, alpha, beta, !transposeB, true).viewDice();
        }
        B.zMult(A, C.viewDice(), alpha, beta, !transposeB, true);
        return C;
    }

    public static boolean areEquals(DoubleMatrix2D A, DoubleMatrix2D B) {
        if (A instanceof ProxiedMatrix || !(B instanceof ProxiedMatrix)) {
            return A.equals((Object)B);
        }
        return B.equals((Object)A);
    }

    public static String identityToString(Object o) {
        String name;
        if (o == null) {
            return "null";
        }
        String classname = o.getClass().getName();
        String its = classname.substring(classname.lastIndexOf(46) + 1) + '@' + System.identityHashCode(o);
        if (!Benchmark.debug) {
            return its;
        }
        if (identityMap == null) {
            identityMap = new HashMap();
        }
        if ((name = (String)identityMap.get(its)) == null) {
            char c = (char)(65 + identityMap.size());
            name = Character.toString(c);
            identityMap.put(its, name);
        }
        return name;
    }

    public DoubleMatrix2D appendColumns(DoubleMatrix2D A, DoubleMatrix2D B) {
        if (A.rows() != B.rows()) {
            throw new IllegalArgumentException("Not the same size");
        }
        if (A instanceof DecoratedDoubleMatrix2D && B instanceof DecoratedDoubleMatrix2D) {
            DecoratedDoubleMatrix2D dA = (DecoratedDoubleMatrix2D)A;
            DecoratedDoubleMatrix2D dB = (DecoratedDoubleMatrix2D)B;
            DynamicStringVector ids = dA.getIds();
            if (!ids.equals(dB.getIds())) {
                throw new IllegalArgumentException("Unable to append: row ids not equals");
            }
            DecoratedDoubleMatrix2D dC = new DecoratedDoubleMatrix2D((DynamicDoubleMatrix2D)super.appendColumns(A, B), new DynamicStringVector(), null, new Properties());
            DynamicStringVector header = dC.getHeader();
            header.addAll(dA.getColumnHeaders());
            header.addAll(dB.getColumnHeaders());
            dC.setIds(ids);
            double[] maxs = new double[dC.columns()];
            double[] maxsA = dA.getMaxs();
            System.arraycopy(maxsA, 0, maxs, 0, maxsA.length);
            double[] maxsB = dB.getMaxs();
            System.arraycopy(maxsB, 0, maxs, maxsA.length, maxsB.length);
            dC.setMaxs(maxs);
            double[] mins = new double[dC.columns()];
            double[] minsA = dA.getMins();
            System.arraycopy(minsA, 0, mins, 0, minsA.length);
            double[] minsB = dB.getMins();
            System.arraycopy(minsB, 0, mins, minsA.length, minsB.length);
            dC.setMins(mins);
            Class[] datatypes = new Class[dC.columns()];
            System.arraycopy(dA.getDataType(), 0, datatypes, 0, dA.columns());
            System.arraycopy(dB.getDataType(), 0, datatypes, dA.columns(), dB.columns());
            dC.setDataType(datatypes);
            return dC;
        }
        return super.appendColumns(A, B);
    }

    public DoubleMatrix2D appendRows(DoubleMatrix2D A, DoubleMatrix2D B) {
        if (A.columns() != B.columns()) {
            throw new IllegalArgumentException("Not the same size");
        }
        if (A instanceof DecoratedDoubleMatrix2D && B instanceof DecoratedDoubleMatrix2D) {
            DecoratedDoubleMatrix2D dA = (DecoratedDoubleMatrix2D)A;
            DecoratedDoubleMatrix2D dB = (DecoratedDoubleMatrix2D)B;
            DynamicStringVector header = dA.getHeader();
            if (!header.equals(dB.getHeader())) {
                throw new IllegalArgumentException("Unable to append: column headers not equals");
            }
            Object[] dataType = dA.getDataType();
            if (!Arrays.equals(dataType, dB.getDataType())) {
                throw new IllegalArgumentException("Unable to append: data types do not match");
            }
            DecoratedDoubleMatrix2D dC = new DecoratedDoubleMatrix2D((DynamicDoubleMatrix2D)super.appendRows(A, B), null, new DynamicStringVector(), new Properties());
            DynamicStringVector ids = dC.getIds();
            ids.addAll(dA.getRowIds());
            ids.addAll(dB.getRowIds());
            dC.setHeader(header);
            int cols = dC.columns();
            double[] maxs = new double[cols];
            System.arraycopy(dA.getMaxs(), 0, maxs, 0, cols);
            double[] mins = new double[cols];
            System.arraycopy(dA.getMins(), 0, mins, 0, cols);
            double[] maxsB = dB.getMaxs();
            double[] minsB = dB.getMins();
            for (int i = 0; i < cols; ++i) {
                if (maxsB[i] > maxs[i]) {
                    maxs[i] = maxsB[i];
                }
                if (!(minsB[i] > mins[i])) continue;
                mins[i] = minsB[i];
            }
            dC.setMaxs(maxs);
            dC.setMins(mins);
            dC.setDataType((Class[])dataType);
            return dC;
        }
        return super.appendRows(A, B);
    }

    static {
        Resource.getInstance().add("/ColtDataMatrix");
        rowdynamic_dense = new DynamicDoubleFactory2D();
        rowdynamic_sparse = new DynamicDoubleFactory2D();
        fulldynamic_dense = new DynamicDoubleFactory2D();
        fulldynamic_sparse = new DynamicDoubleFactory2D();
    }
}

