/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.dcolt;

import com.tlabs.dcolt.ProxiedStringVector;
import com.tlabs.dcolt.SimpleStringVector;
import com.tlabs.dcolt.StringVector;
import com.tlabs.util.Resource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class DynamicStringVector
implements StringVector {
    private static Resource _res = Resource.getInstance();
    private final int INITIAL_SIZE = 16;
    private ProxiedStringVector[] _composite = new ProxiedStringVector[16];
    private ProxiedStringVector _last;
    private transient boolean _batchReading;
    private int _lastpos;
    private int _maxsize;
    private int _tileSize;

    DynamicStringVector() {
        this(100000);
    }

    DynamicStringVector(int tileSize) {
        this._tileSize = tileSize;
        this._last = this._composite[0];
        this._lastpos = -1;
        this._maxsize = 0;
    }

    private void ensureCapacity(int pos) {
        if (pos >= this._maxsize) {
            throw new IndexOutOfBoundsException(_res.formatString("StringVector.CapacityError", new Object[]{new Integer(pos), new Integer(this._maxsize)}));
        }
        int tile = pos / this._tileSize;
        while (tile >= this._composite.length) {
            ProxiedStringVector[] newComposite = new ProxiedStringVector[this._composite.length + 16];
            System.arraycopy(this._composite, 0, newComposite, 0, this._composite.length);
            this._composite = newComposite;
        }
        ProxiedStringVector proxiedStringVector = this._composite[tile];
        if (this._last != null && this._last != proxiedStringVector) {
            this._last.release();
        }
        if (proxiedStringVector == null) {
            this._composite[tile] = proxiedStringVector = new ProxiedStringVector(new SimpleStringVector(this._tileSize));
        }
        this._last = proxiedStringVector;
    }

    public String get(int pos) {
        if (pos < 0 || pos > this._lastpos) {
            return null;
        }
        ProxiedStringVector psv = this._composite[pos / this._tileSize];
        if (this._last != null && this._last != psv) {
            this._last.release();
            this._last = psv;
            if (this._batchReading) {
                this._last.prepareBatchReading();
            }
        }
        return this._last == null ? "" : this._last.get(pos % this._tileSize);
    }

    public int indexOf(String s) {
        int rep;
        if (this._last != null) {
            rep = this._last.indexOf(s);
            if (rep != -1) {
                for (int i = 0; i < this._composite.length; ++i) {
                    if (this._composite[i] != this._last) continue;
                    return i * this._tileSize + rep;
                }
            }
            this._last.release();
        }
        ProxiedStringVector psv = null;
        for (int i = 0; i < this._composite.length; ++i) {
            psv = this._composite[i];
            if (psv == null) continue;
            if (psv != this._last && (rep = psv.indexOf(s)) != -1) {
                this._last = psv;
                return i * this._tileSize + rep;
            }
            psv.release();
        }
        return -1;
    }

    public void add(String st) {
        this.ensureCapacity(++this._lastpos);
        ProxiedStringVector psv = this._composite[this._lastpos / this._tileSize];
        if (this._last != null && this._last != psv) {
            this._last.release();
            this._last = psv;
            if (this._batchReading) {
                this._last.prepareBatchReading();
            }
        }
        this._last.add(st);
    }

    public void addAll(List list) {
        this.prepareBatchReading();
        this.ensureCapacity(this._lastpos + list.size());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.add((String)it.next());
        }
        this.endBatchReading();
    }

    public void set(int pos, String st) {
        this.ensureCapacity(pos);
        if (pos > this._lastpos) {
            this._lastpos = pos;
        }
        ProxiedStringVector psv = this._composite[pos / this._tileSize];
        if (this._last != null && this._last != psv) {
            this._last.release();
        }
        this._last = psv;
        this._last.set(pos % this._tileSize, st);
    }

    public List getAll() {
        this.prepareBatchReading();
        ArrayList<String> retList = new ArrayList<String>();
        for (int i = 0; i <= this._lastpos; ++i) {
            retList.add(this.get(i));
        }
        this.endBatchReading();
        return retList;
    }

    public void setAll(List list) {
        this.dispose();
        this._composite = new ProxiedStringVector[16];
        this._composite[0] = new ProxiedStringVector(new SimpleStringVector(this._tileSize));
        this._last = this._composite[0];
        this._lastpos = -1;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.add((String)it.next());
        }
    }

    public int size() {
        return this._maxsize;
    }

    public int getLastPos() {
        return this._lastpos;
    }

    public void clear() {
        this._lastpos = -1;
        for (int i = 0; i < this._composite.length; ++i) {
            this._last = this._composite[i];
            if (this._last == null) continue;
            this._last.clear();
        }
    }

    void extendTo(int size) {
        this._maxsize = size;
    }

    void trimToSize() {
        this._maxsize = this._lastpos + 1;
    }

    public void dispose() {
        this._last = null;
        int i = this._composite.length;
        while (--i >= 0) {
            if (this._composite[i] == null) continue;
            this._composite[i].dispose();
        }
    }

    public void prepareBatchReading() {
        this._batchReading = true;
    }

    public void endBatchReading() {
        this._batchReading = false;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof StringVector)) {
            return false;
        }
        this.prepareBatchReading();
        StringVector o = (StringVector)obj;
        int i = this._maxsize;
        while (--i >= 0) {
            String s = this.get(i);
            String os = o.get(i);
            if ((s != null || s == os) && (s == null || s.equals(os))) continue;
            this.endBatchReading();
            return false;
        }
        this.endBatchReading();
        return true;
    }
}

