/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.dcolt;

import cern.colt.function.ObjectFunction;
import cern.colt.function.ObjectObjectFunction;
import cern.colt.list.IntArrayList;
import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.impl.DenseObjectMatrix2D;
import com.tlabs.dcolt.DynamicObjectFactory2D;
import com.tlabs.dcolt.ProxiedMatrix;
import com.tlabs.dcolt.ProxyDirectImplementation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;

class ProxiedDenseObjectMatrix2D
extends DenseObjectMatrix2D
implements ProxyDirectImplementation {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$tlabs$dcolt$ProxiedDenseObjectMatrix2D == null ? (class$com$tlabs$dcolt$ProxiedDenseObjectMatrix2D = ProxiedDenseObjectMatrix2D.class$("com.tlabs.dcolt.ProxiedDenseObjectMatrix2D")) : class$com$tlabs$dcolt$ProxiedDenseObjectMatrix2D));
    private volatile transient boolean needFileUpdate;
    private volatile transient boolean diskMode;
    private volatile transient int batch;
    private transient File proxy;
    private transient RandomAccessFile access;
    private transient long[] elementPosition;
    private int elementsSize;
    private ProxiedDenseObjectMatrix2D viewRef;
    static /* synthetic */ Class class$com$tlabs$dcolt$ProxiedDenseObjectMatrix2D;

    public ProxiedDenseObjectMatrix2D(int rows, int columns) {
        super(rows, columns);
        this.init();
    }

    public ProxiedDenseObjectMatrix2D(Object[][] values) {
        super(values);
        this.init();
    }

    private void init() {
        this.needFileUpdate = true;
        this.diskMode = false;
        this.batch = 0;
        this.proxy = null;
        this.access = null;
        this.elementsSize = this.elements.length;
        this.elementPosition = null;
        this.viewRef = null;
    }

    public void setDiskMode() {
        this.setDiskMode(0);
    }

    protected void setDiskMode(int startBatch) {
        if (this.diskMode) {
            return;
        }
        this.diskMode = true;
        if (this.viewRef != null) {
            this.viewRef.setDiskMode(startBatch);
            this.needFileUpdate = this.viewRef.needFileUpdate;
            this.elements = this.viewRef.elements;
            this.createRandomAccess();
        } else if (startBatch == 0) {
            if (this.needFileUpdate) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " going on disk"));
                    }
                    this.writeElements();
                    this.needFileUpdate = false;
                    this.elements = null;
                    this.createRandomAccess();
                }
                catch (IOException e) {
                    LOG.error((Object)"Unable to write content", (Throwable)e);
                }
            } else {
                this.elements = null;
            }
        }
    }

    public void setMemoryMode() {
        if (!this.diskMode) {
            return;
        }
        if (this.viewRef != null) {
            this.viewRef.setMemoryMode();
            this.needFileUpdate = this.viewRef.needFileUpdate;
            this.elements = this.viewRef.elements;
            this.closeRandomAccess();
        }
        if (this.batch > 0) {
            LOG.warn((Object)(DynamicObjectFactory2D.identityToString(this) + "switching from batch " + this.batch + " to memory"));
            this.batch = 0;
            this.diskMode = false;
            this.closeRandomAccess();
        } else if (this.elements == null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " going in memory"));
                }
                this.readElements();
                this.diskMode = false;
                this.closeRandomAccess();
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to load back the matrix", (Throwable)e);
            }
        }
    }

    public int getBatch() {
        return this.batch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeElements() throws IOException {
        FilterOutputStream out = null;
        try {
            if (this.proxy == null) {
                this.proxy = File.createTempFile("_mat_", ".tmp");
            }
            if (this.elementPosition == null) {
                this.elementPosition = new long[this.elementsSize + 1];
                this.elementPosition[0] = 0L;
            }
            out = new BufferedOutputStream(new FileOutputStream(this.proxy));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            int l = this.elementsSize;
            for (int i = 0; i < l; ++i) {
                oos.writeObject(this.elements[i]);
                oos.flush();
                this.elementPosition[i + 1] = this.elementPosition[i] + (long)baos.size();
                baos.writeTo(out);
                baos.reset();
            }
            Object var7_6 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to close output data stream", (Throwable)e);
            }
            throw throwable;
        }
        try {
            out.close();
            return;
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to close output data stream", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readElements() throws IOException, ClassNotFoundException {
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.proxy)));
            this.elements = new Object[this.elementsSize];
            for (int i = 0; i < this.elementsSize; ++i) {
                this.elements[i] = in.readObject();
            }
            this.needFileUpdate = false;
            Object var4_3 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to close input data stream", (Throwable)e);
            }
            throw throwable;
        }
        try {
            in.close();
            return;
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to close input data stream", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createRandomAccess() {
        if (this.proxy == null) {
            if (this.viewRef != null) {
                this.proxy = this.viewRef.proxy;
                this.access = this.viewRef.access;
                return;
            }
            LOG.warn((Object)"No file for creating random access file");
            return;
        }
        try {
            this.access = new RandomAccessFile(this.proxy, "rw");
            return;
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to create random access file", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeRandomAccess() {
        try {
            this.access.close();
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to close random access file", (Throwable)e);
        }
        finally {
            this.access = null;
        }
    }

    public void prepareBatchOperation() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " beginning of batch operation"));
        }
        if (!this.diskMode) {
            return;
        }
        if (this.viewRef != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " preparing " + DynamicObjectFactory2D.identityToString(this.viewRef) + " batch operation"));
            }
            this.viewRef.prepareBatchOperation();
            this.elements = this.viewRef.elements;
        }
        if (this.batch++ == 0 && this.elements == null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " going in memory"));
                }
                this.readElements();
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to load back the matrix", (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " operating batch " + this.batch));
        }
    }

    public void endBatchOperation() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " end of batch operation"));
        }
        if (!this.diskMode) {
            return;
        }
        if (this.viewRef != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " ending " + DynamicObjectFactory2D.identityToString(this.viewRef) + " batch operation"));
            }
            this.viewRef.endBatchOperation();
            this.needFileUpdate = this.viewRef.needFileUpdate;
            this.elements = this.viewRef.elements;
        }
        if (--this.batch == 0 && this.elements != null) {
            if (this.needFileUpdate) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " going on disk"));
                    }
                    this.writeElements();
                    this.needFileUpdate = false;
                    this.elements = null;
                }
                catch (IOException e) {
                    LOG.error((Object)"Unable to write the matrix", (Throwable)e);
                }
            } else {
                this.elements = null;
            }
        }
        if (this.elements == null && this.access == null) {
            this.createRandomAccess();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " operating batch " + this.batch));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.access != null) {
            this.closeRandomAccess();
        }
        if (this.viewRef != null) {
            this.proxy = null;
            this.viewRef.dispose();
        } else if (this.proxy != null) {
            try {
                if (!this.proxy.delete()) {
                    LOG.error((Object)"Unable to delete element file");
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to delete element file", (Throwable)e);
            }
            finally {
                this.proxy = null;
            }
        }
        this.elements = null;
    }

    public boolean isDiskMode() {
        return this.diskMode;
    }

    public void flagAsModified() {
        if (LOG.isDebugEnabled() && !this.needFileUpdate) {
            LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " flag as modified"));
        }
        this.needFileUpdate = true;
        if (this.viewRef != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " flagging " + DynamicObjectFactory2D.identityToString(this.viewRef) + " as modified"));
            }
            this.viewRef.flagAsModified();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.prepareBatchOperation();
        s.defaultWriteObject();
        this.endBatchOperation();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.needFileUpdate = true;
    }

    public Object aggregate(ObjectObjectFunction aggr, ObjectFunction f) {
        this.prepareBatchOperation();
        Object value = super.aggregate(aggr, f);
        this.endBatchOperation();
        return value;
    }

    public Object aggregate(ObjectMatrix2D other, ObjectObjectFunction aggr, ObjectObjectFunction f) {
        this.prepareBatchOperation();
        if (other instanceof ProxiedMatrix) {
            ((ProxiedMatrix)other).prepareBatchOperation();
        }
        Object value = super.aggregate(other, aggr, f);
        if (other instanceof ProxiedMatrix) {
            ((ProxiedMatrix)other).endBatchOperation();
        }
        this.endBatchOperation();
        return value;
    }

    public ObjectMatrix2D assign(Object[][] values) {
        this.prepareBatchOperation();
        super.assign(values);
        this.flagAsModified();
        this.endBatchOperation();
        return this;
    }

    public ObjectMatrix2D assign(Object value) {
        this.prepareBatchOperation();
        super.assign(value);
        this.flagAsModified();
        this.endBatchOperation();
        return this;
    }

    public ObjectMatrix2D assign(ObjectFunction function) {
        this.prepareBatchOperation();
        super.assign(function);
        this.flagAsModified();
        this.endBatchOperation();
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D source) {
        this.prepareBatchOperation();
        if (source instanceof ProxiedMatrix) {
            ProxiedMatrix p = (ProxiedMatrix)source;
            p.prepareBatchOperation();
            super.assign(source);
            p.endBatchOperation();
        } else {
            super.assign(source);
        }
        this.flagAsModified();
        this.endBatchOperation();
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D y, ObjectObjectFunction function) {
        this.prepareBatchOperation();
        if (y instanceof ProxiedMatrix) {
            ProxiedMatrix p = (ProxiedMatrix)y;
            p.prepareBatchOperation();
            super.assign(y, function);
            p.endBatchOperation();
        } else {
            super.assign(y, function);
        }
        this.flagAsModified();
        this.endBatchOperation();
        return this;
    }

    public int cardinality() {
        this.prepareBatchOperation();
        int card = super.cardinality();
        this.endBatchOperation();
        return card;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        this.prepareBatchOperation();
        if (obj instanceof ProxiedMatrix) {
            ((ProxiedMatrix)obj).prepareBatchOperation();
        }
        boolean isequals = super.equals(obj);
        if (obj instanceof ProxiedMatrix) {
            ((ProxiedMatrix)obj).endBatchOperation();
        }
        this.endBatchOperation();
        return isequals;
    }

    public Object getQuick(int row, int column) {
        if (this.elements != null) {
            return super.getQuick(row, column);
        }
        if (this.access != null) {
            try {
                int pos = this.index(row, column);
                byte[] buf = new byte[(int)(this.elementPosition[pos + 1] - this.elementPosition[pos])];
                this.access.seek(this.elementPosition[pos]);
                this.access.read(buf);
                return new ObjectInputStream(new ByteArrayInputStream(buf)).readObject();
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to access random file element", (Throwable)e);
            }
        }
        LOG.error((Object)"Not in memory and unable to read from random access");
        this.prepareBatchOperation();
        Object value = super.getQuick(row, column);
        this.endBatchOperation();
        return value;
    }

    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, ObjectArrayList valueList) {
        this.prepareBatchOperation();
        super.getNonZeros(rowList, columnList, valueList);
        this.endBatchOperation();
    }

    public ObjectMatrix1D like1D(int size, int zero, int stride) {
        this.prepareBatchOperation();
        ObjectMatrix1D objectMatrix1D = super.like1D(size, zero, stride);
        this.endBatchOperation();
        return objectMatrix1D;
    }

    public void setQuick(int row, int column, Object value) {
        if (this.elements != null) {
            super.setQuick(row, column, value);
            this.flagAsModified();
            return;
        }
        LOG.warn((Object)"Setting new value in ObjectMatrix on disk");
        this.prepareBatchOperation();
        super.setQuick(row, column, value);
        this.flagAsModified();
        this.endBatchOperation();
    }

    public Object[][] toArray() {
        this.prepareBatchOperation();
        Object[][] array = super.toArray();
        this.endBatchOperation();
        return array;
    }

    protected ObjectMatrix2D view() {
        ProxiedDenseObjectMatrix2D objectMatrix2D = (ProxiedDenseObjectMatrix2D)super.view();
        objectMatrix2D.viewRef = this;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(DynamicObjectFactory2D.identityToString(this) + " creating view " + DynamicObjectFactory2D.identityToString(objectMatrix2D)));
        }
        return objectMatrix2D;
    }

    public ObjectMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        this.prepareBatchOperation();
        ObjectMatrix2D objectMatrix2D = super.viewSelectionLike(rowOffsets, columnOffsets);
        this.endBatchOperation();
        return objectMatrix2D;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

