/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.dcolt;

import com.tlabs.dcolt.SimpleStringVector;
import com.tlabs.dcolt.StringVector;
import com.tlabs.util.Resource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.List;
import org.apache.log4j.Logger;

class ProxiedStringVector
implements StringVector {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$tlabs$dcolt$ProxiedStringVector == null ? (class$com$tlabs$dcolt$ProxiedStringVector = ProxiedStringVector.class$("com.tlabs.dcolt.ProxiedStringVector")) : class$com$tlabs$dcolt$ProxiedStringVector));
    private static Resource _res = Resource.getInstance();
    private File _prox;
    private int[] _address;
    private RandomAccessFile _access;
    private transient StringVector _real;
    private int _lastpos;
    private int _maxpos;
    private boolean _isSimple;
    private boolean _modified = true;
    static /* synthetic */ Class class$com$tlabs$dcolt$ProxiedStringVector;

    public ProxiedStringVector(StringVector proxied) {
        this._maxpos = proxied.size() - 1;
        this._lastpos = proxied.getLastPos();
        this._real = proxied;
        this._isSimple = proxied instanceof SimpleStringVector;
    }

    public String get(int pos) {
        if (pos < 0 || pos > this._lastpos) {
            return null;
        }
        if (this._real != null) {
            return this._real.get(pos);
        }
        if (this._isSimple) {
            if (this._access == null) {
                this.prepareRandomReading();
            }
            try {
                this._access.seek(this._address[pos]);
                return this._access.readUTF();
            }
            catch (IOException e) {
                LOG.error((Object)("Error random accessing " + this._prox), (Throwable)e);
                return null;
            }
        }
        this.checkLoad();
        return this._real.get(pos);
    }

    public int indexOf(String s) {
        this.prepareBatchReading();
        return this._real.indexOf(s);
    }

    public void set(int pos, String st) {
        if (pos < 0) {
            throw new IndexOutOfBoundsException(_res.getString("StringVector.NegativeIndex"));
        }
        this.checkLoad();
        if (pos > this._lastpos) {
            this._lastpos = pos;
        }
        this._real.set(pos, st);
        this._modified = true;
    }

    public void add(String st) {
        this.checkLoad();
        ++this._lastpos;
        this._modified = true;
        this._real.add(st);
    }

    public void addAll(List list) {
        this.checkLoad();
        this._lastpos += list.size();
        this._modified = true;
        this._real.addAll(list);
    }

    public List getAll() {
        this.checkLoad();
        return this._real.getAll();
    }

    public void setAll(List list) {
        this.checkLoad();
        this._real.setAll(list);
        this._modified = true;
        this._lastpos = list.size();
    }

    public int size() {
        return this._maxpos;
    }

    public int getLastPos() {
        return this._lastpos;
    }

    public void clear() {
        this.checkLoad();
        this._real.clear();
        this._lastpos = -1;
        this._modified = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void release() {
        block32: {
            IOException e322;
            ObjectOutputStream oos;
            FilterOutputStream dos;
            block30: {
                if (this._access != null) {
                    try {
                        this._access.close();
                    }
                    catch (IOException e2) {
                        LOG.error((Object)"Error closing random access file", (Throwable)e2);
                    }
                    finally {
                        this._access = null;
                    }
                }
                if (!this._modified) {
                    this._real = null;
                    return;
                }
                dos = null;
                oos = null;
                if (this._prox == null) {
                    this._prox = File.createTempFile("_sv_", ".tmp");
                }
                if (this._isSimple) {
                    if (this._address == null) {
                        this._address = new int[this._real.size()];
                    }
                    dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this._prox)));
                    int i = this._real.size();
                    while (--i >= 0) {
                        this._address[i] = ((DataOutputStream)dos).size();
                        ((DataOutputStream)dos).writeUTF(this._real.get(i));
                    }
                } else {
                    oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this._prox)));
                    oos.writeObject(this._real);
                }
                this._real = null;
                this._modified = false;
                Object var5_7 = null;
                if (dos == null) break block30;
                try {
                    dos.close();
                }
                catch (IOException e322) {
                    // empty catch block
                }
            }
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e322) {}
            }
            break block32;
            {
                catch (IOException e4) {
                    IOException e322;
                    LOG.error((Object)"Error while releasing file", (Throwable)e4);
                    Object var5_8 = null;
                    if (dos != null) {
                        try {
                            dos.close();
                        }
                        catch (IOException e322) {
                            // empty catch block
                        }
                    }
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (IOException e322) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e322;
                Object var5_9 = null;
                if (dos != null) {
                    try {
                        dos.close();
                    }
                    catch (IOException e322) {
                        // empty catch block
                    }
                }
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException e322) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkLoad() {
        IOException e322;
        int i;
        ObjectInputStream ois;
        FilterInputStream dis;
        block26: {
            if (this._access != null) {
                try {
                    this._access.close();
                }
                catch (IOException e2) {
                    LOG.error((Object)"Error closing random access file", (Throwable)e2);
                }
                finally {
                    this._access = null;
                }
            }
            if (this._real != null) {
                return true;
            }
            dis = null;
            ois = null;
            if (this._isSimple) {
                dis = new DataInputStream(new BufferedInputStream(new FileInputStream(this._prox)));
                this._real = new SimpleStringVector(this._maxpos + 1);
                i = this._maxpos + 1;
                while (--i >= 0) {
                    this._real.set(i, ((DataInputStream)dis).readUTF());
                }
            } else {
                ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this._prox)));
                this._real = (StringVector)ois.readObject();
            }
            this._modified = false;
            i = 1;
            Object var7_7 = null;
            if (dis == null) break block26;
            try {
                dis.close();
            }
            catch (IOException e322) {
                // empty catch block
            }
        }
        if (ois != null) {
            try {
                ois.close();
            }
            catch (IOException e322) {
                // empty catch block
            }
        }
        return i != 0;
        catch (Exception e4) {
            IOException e322;
            boolean bl;
            block28: {
                try {
                    String msg = _res.getString("MatrixImp.ProxyError");
                    LOG.error((Object)msg, (Throwable)e4);
                    bl = false;
                    Object var7_8 = null;
                    if (dis == null) break block28;
                }
                catch (Throwable throwable) {
                    block30: {
                        IOException e322;
                        Object var7_9 = null;
                        if (dis != null) {
                            try {
                                dis.close();
                            }
                            catch (IOException e322) {
                                // empty catch block
                            }
                        }
                        if (ois == null) break block30;
                        try {
                            ois.close();
                        }
                        catch (IOException e322) {}
                    }
                    throw throwable;
                }
                try {
                    dis.close();
                }
                catch (IOException e322) {
                    // empty catch block
                }
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e322) {
                    // empty catch block
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this._isSimple && this._real != null || this.checkLoad()) {
            this._real.dispose();
        }
        if (this._access != null) {
            try {
                this._access.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Error closing random access file", (Throwable)e);
            }
            finally {
                this._access = null;
            }
        }
        if (this._prox != null) {
            this._prox.delete();
        }
    }

    public void prepareBatchReading() {
        this.checkLoad();
    }

    void prepareRandomReading() {
        if (this._isSimple && this._access == null) {
            try {
                this._access = new RandomAccessFile(this._prox, "r");
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)"Unable to retrieve the random access file", (Throwable)e);
            }
        }
    }

    public void endBatchReading() {
        this.release();
    }

    public boolean equals(Object obj) {
        this.prepareBatchReading();
        boolean b = this._real.equals(obj);
        this.endBatchReading();
        return b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

