/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.dcolt;

import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import com.tlabs.dcolt.DecoratedObjectMatrix2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

class SelectedDecoratedObjectMatrix2D
extends DecoratedObjectMatrix2D {
    private DecoratedObjectMatrix2D _original;
    private int[] _rowoffset;
    private int[] _columnoffset;

    public SelectedDecoratedObjectMatrix2D(DecoratedObjectMatrix2D original, int[] rowoffset, int[] columnoffset) {
        super(null, null, null, null);
        this.setUp(rowoffset.length, columnoffset.length);
        this._original = original;
        this._rowoffset = rowoffset;
        this._columnoffset = columnoffset;
        this.isNoView = false;
    }

    public void dispose() {
        this._original.dispose();
    }

    protected void ensureStorage(int nbrows, int nbcols) {
        throw new InternalError("Should not happen !");
    }

    protected void ensureStorage() {
        this._original.ensureStorage();
    }

    public void extendTo(int rows, int columns) {
        throw new UnsupportedOperationException("Not yet supported, please extend original matrix instead");
    }

    protected void internalSetDiskMode() {
        this._original.internalSetDiskMode();
    }

    protected void internalSetMemoryMode() {
        this._original.internalSetMemoryMode();
    }

    public void logBatchState() {
        this._original.logBatchState();
    }

    public Object getQuick(int row, int column) {
        return this._original.getQuick(this._rowoffset[row], this._columnoffset[column]);
    }

    public ObjectMatrix2D like(int rows, int columns) {
        return this._original.like(rows, columns);
    }

    public void setQuick(int row, int column, Object value) {
        this._original.setQuick(this._rowoffset[row], this._columnoffset[column], value);
    }

    public ObjectMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDecoratedObjectMatrix2D(this, rowOffsets, columnOffsets);
    }

    public ObjectMatrix1D like1D(int size) {
        return this._original.like1D(size);
    }

    protected int _rowOffset(int absRank) {
        return this._rowoffset[absRank];
    }

    protected int _columnOffset(int absRank) {
        return this._columnoffset[absRank];
    }

    public String getColumnHeader(int col) {
        return this._original.getColumnHeader(this._columnoffset[col]);
    }

    public List getColumnHeaders() {
        ArrayList<String> l = new ArrayList<String>();
        this.prepareBatchOperation();
        int i = this.columns;
        while (--i >= 0) {
            l.add(this.getColumnHeader(i));
        }
        this.endBatchOperation();
        return l;
    }

    public ObjectMatrix2D getContent() {
        return this._original.getContent();
    }

    public Class[] getDataType() {
        Class[] c = new Class[this.columns];
        int i = this.columns;
        while (--i >= 0) {
            c[i] = this.getDataType(i);
        }
        return c;
    }

    public Class getDataType(int column) {
        return this._original.getDataType(this._columnoffset[column]);
    }

    public Properties getProperties() {
        return this._original.getProperties();
    }

    public String getProperty(String key) {
        return this._original.getProperty(key);
    }

    public Object[] getRow(int row) {
        Object[] datarow = new Object[this.columns];
        int i = this.columns;
        while (--i >= 0) {
            datarow[i] = this.getQuick(row, i);
        }
        return datarow;
    }

    public String getRowId(int row) {
        return this._original.getRowId(this._rowoffset[row]);
    }

    public List getRowIds() {
        ArrayList<String> l = new ArrayList<String>();
        this.prepareBatchOperation();
        int i = this.rows;
        while (--i >= 0) {
            l.add(this.getRowId(i));
        }
        this.endBatchOperation();
        return l;
    }

    public int getRowIndexFromRowId(String rowId) {
        List ids = this.getRowIds();
        int i = this.rows;
        while (--i >= 0) {
            if (!rowId.equals(ids.get(i))) continue;
            return i;
        }
        return -1;
    }

    public void setColumnHeader(int col, String header) {
        this._original.setColumnHeader(this._columnoffset[col], header);
    }

    public void setColumnHeaders(List headers) {
        this.prepareBatchOperation();
        int i = this.columns;
        while (--i >= 0) {
            this.setColumnHeader(i, (String)headers.get(i));
        }
        this.endBatchOperation();
    }

    public void setDataType(int column, Class dataType) {
        this._original.setDataType(this._columnoffset[column], dataType);
    }

    public void setDataType(Class[] dataType) {
        int i = this.columns;
        while (--i >= 0) {
            this.setDataType(i, dataType[i]);
        }
    }

    public void setProperties(Properties properties) {
        this._original.setProperties(properties);
    }

    public void setProperty(String key, String value) {
        this._original.setProperty(key, value);
    }

    public void setRow(int row, Object[] values) {
        int i = this.columns;
        while (--i >= 0) {
            this.setQuick(row, i, values[i]);
        }
    }

    public void setRowId(int row, String rowId) {
        this._original.setRowId(this._rowoffset[row], rowId);
    }

    public void setRowIds(List rowIds) {
        this.prepareBatchOperation();
        int i = this.rows;
        while (--i >= 0) {
            this.setRowId(i, (String)rowIds.get(i));
        }
        this.endBatchOperation();
    }

    public ObjectMatrix1D viewRow(int row) {
        int[] sel = new int[this._columnoffset.length];
        int i = sel.length;
        while (--i >= 0) {
            sel[i] = this._columnOffset(this._columnoffset[i]);
        }
        return this._original.viewRow(this._rowoffset[row]).viewSelection(sel);
    }

    public ObjectMatrix1D viewColumn(int column) {
        int[] sel = new int[this._rowoffset.length];
        int i = sel.length;
        while (--i >= 0) {
            sel[i] = this._rowOffset(this._columnoffset[i]);
        }
        return this._original.viewColumn(this._columnoffset[column]).viewSelection(sel);
    }

    public ObjectMatrix2D view() {
        SelectedDecoratedObjectMatrix2D view = (SelectedDecoratedObjectMatrix2D)super.view();
        view._original = (DecoratedObjectMatrix2D)this._original.view();
        return view;
    }

    public void prepareBatchOperation() {
        this._original.prepareBatchOperation();
    }

    public void endBatchOperation() {
        this._original.endBatchOperation();
    }
}

