/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.dcolt.bench;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.ObjectFactory2D;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.impl.AbstractMatrix2D;
import com.tlabs.dcolt.DynamicDoubleFactory2D;
import com.tlabs.dcolt.DynamicDoubleMatrix2D;
import com.tlabs.dcolt.DynamicObjectFactory2D;
import com.tlabs.dcolt.ProxiedMatrix;
import java.util.Random;

public class Benchmark {
    public static boolean debug = false;
    private long _start;
    private DoubleMatrix2D and;
    private DoubleMatrix2D bnd;
    private DoubleMatrix2D cnd;
    private ObjectMatrix2D oand;
    private ObjectMatrix2D obnd;
    private DoubleMatrix2D ans;
    private DoubleMatrix2D bns;
    private DoubleMatrix2D cns;
    private ObjectMatrix2D oans;
    private ObjectMatrix2D obns;
    private int arows;
    private int common;
    private int bcolumns;
    private String size;
    private String sizeA;
    private String sizeB;
    private String sizeC;

    private void init(int arows, int common, int bcolumns) {
        this.setSize(arows, common, bcolumns);
        this.printTest("Initializing dense references");
        DoubleFactory2D dense = DynamicDoubleFactory2D.dense;
        this.and = this.createDenseA(dense);
        this.bnd = this.createDenseB(dense);
        this.cnd = this.createC(dense);
        this.testMultiply(this.and, this.bnd, this.cnd, this.cnd);
        this.printTest("Initializing sparse references");
        DoubleFactory2D sparse = DynamicDoubleFactory2D.sparse;
        this.ans = debug ? this.createAssign(sparse, this.and) : this.createSparseA(sparse);
        this.bns = debug ? this.createAssign(sparse, this.bnd) : this.createSparseB(sparse);
        this.cns = this.createC(sparse);
        this.testMultiply(this.ans, this.bns, this.cns, this.cns);
    }

    private void initObject(int arows, int common, int bcolumns) {
        this.setSize(arows, common, bcolumns);
        this.printTest("Initializing dense references");
        ObjectFactory2D odense = DynamicObjectFactory2D.dense;
        this.oand = this.createObjectDenseA(odense);
        this.obnd = this.createObjectDenseB(odense);
        this.printTest("Initializing sparse references");
        ObjectFactory2D osparse = DynamicObjectFactory2D.sparse;
        this.oans = debug ? this.createAssign(osparse, this.oand) : this.createObjectSparseA(osparse);
        this.obns = debug ? this.createAssign(osparse, this.obnd) : this.createObjectSparseB(osparse);
    }

    private void setSize(int arows, int common, int bcolumns) {
        this.arows = arows;
        this.common = common;
        this.bcolumns = bcolumns;
        this.sizeA = "{" + this.arows + "," + this.common + "}";
        this.sizeB = "{" + this.common + "," + this.bcolumns + "}";
        this.sizeC = "{" + this.arows + "," + this.bcolumns + "}";
        this.size = this.sizeA + "x" + this.sizeB;
    }

    private void startMonitoring() {
        if (this._start != 0L) {
            throw new IllegalStateException("Already monitoring !");
        }
        this._start = System.currentTimeMillis();
    }

    private void printTime(String msg) {
        if (this._start == 0L) {
            throw new IllegalStateException("No monitoring !");
        }
        long elapsed = System.currentTimeMillis() - this._start;
        System.out.println(msg + " in " + elapsed / 60000L + " mn " + elapsed % 60000L / 1000L + " s " + elapsed % 1000L + " ms");
        this._start = 0L;
    }

    private void printTest(String m) {
        System.out.println();
        System.out.println("------------------- " + m + " ------------------ ");
        System.out.println();
    }

    private DoubleMatrix2D createDenseA(DoubleFactory2D F) {
        this.startMonitoring();
        DoubleMatrix2D A = F.random(this.arows, this.common);
        this.printTime(this.getMatrixType((AbstractMatrix2D)A) + " matrix " + this.sizeA + " created random");
        return A;
    }

    private ObjectMatrix2D createObjectDenseA(ObjectFactory2D F) {
        this.startMonitoring();
        ObjectMatrix2D A = F.make(this.arows, this.common);
        for (int i = 0; i < this.arows; ++i) {
            for (int j = 0; j < this.common; ++j) {
                A.setQuick(i, j, (Object)new Integer(i + j));
            }
        }
        this.printTime(this.getMatrixType((AbstractMatrix2D)A) + " matrix " + this.sizeA + " created");
        return A;
    }

    private DoubleMatrix2D createDenseB(DoubleFactory2D F) {
        this.startMonitoring();
        DoubleMatrix2D B = F.random(this.common, this.bcolumns);
        this.printTime(this.getMatrixType((AbstractMatrix2D)B) + " matrix " + this.sizeB + " created random");
        return B;
    }

    private ObjectMatrix2D createObjectDenseB(ObjectFactory2D F) {
        this.startMonitoring();
        ObjectMatrix2D A = F.make(this.common, this.bcolumns);
        for (int i = 0; i < this.common; ++i) {
            for (int j = 0; j < this.bcolumns; ++j) {
                A.setQuick(i, j, (Object)new Integer(i + j));
            }
        }
        this.printTime(this.getMatrixType((AbstractMatrix2D)A) + " matrix " + this.sizeB + " created");
        return A;
    }

    private DoubleMatrix2D createSparseA(DoubleFactory2D F) {
        this.startMonitoring();
        DoubleMatrix2D A = F.sample(this.arows, this.common, 0.549817, 0.1);
        this.printTime(this.getMatrixType((AbstractMatrix2D)A) + " matrix " + this.sizeA + " created sparse");
        return A;
    }

    private ObjectMatrix2D createObjectSparseA(ObjectFactory2D F) {
        this.startMonitoring();
        Random r = new Random();
        ObjectMatrix2D A = F.make(this.arows, this.common);
        for (int i = 0; i < this.arows; ++i) {
            for (int j = 0; j < this.common; ++j) {
                if (!(r.nextDouble() < 0.2)) continue;
                A.setQuick(i, j, (Object)new Integer(i + j));
            }
        }
        this.printTime(this.getMatrixType((AbstractMatrix2D)A) + " matrix " + this.sizeA + " created sparse");
        return A;
    }

    private DoubleMatrix2D createSparseB(DoubleFactory2D F) {
        this.startMonitoring();
        DoubleMatrix2D B = F.sample(this.common, this.bcolumns, 2.364418, 0.08);
        this.printTime(this.getMatrixType((AbstractMatrix2D)B) + " matrix " + this.sizeB + " created sparse");
        return B;
    }

    private ObjectMatrix2D createObjectSparseB(ObjectFactory2D F) {
        this.startMonitoring();
        Random r = new Random();
        ObjectMatrix2D A = F.make(this.common, this.bcolumns);
        for (int i = 0; i < this.common; ++i) {
            for (int j = 0; j < this.bcolumns; ++j) {
                if (!(r.nextDouble() < 0.2)) continue;
                A.setQuick(i, j, (Object)new Integer(i + j));
            }
        }
        this.printTime(this.getMatrixType((AbstractMatrix2D)A) + " matrix " + this.sizeB + " created sparse");
        return A;
    }

    private DoubleMatrix2D createAssign(DoubleFactory2D F, DoubleMatrix2D mat) {
        this.startMonitoring();
        DoubleMatrix2D newmat = F.make(mat.rows(), mat.columns()).assign(mat);
        this.printTime(this.getMatrixName((AbstractMatrix2D)newmat) + " matrix assigned");
        return newmat;
    }

    private ObjectMatrix2D createAssign(ObjectFactory2D F, ObjectMatrix2D mat) {
        this.startMonitoring();
        ObjectMatrix2D newmat = F.make(mat.rows(), mat.columns()).assign(mat);
        this.printTime(this.getMatrixName((AbstractMatrix2D)newmat) + " matrix assigned");
        return newmat;
    }

    private DoubleMatrix2D createC(DoubleFactory2D F) {
        DoubleMatrix2D C = F.make(this.arows, this.bcolumns);
        return C;
    }

    private String getMatrixType(AbstractMatrix2D mat) {
        String className = mat.getClass().getName();
        String matrixName = className.substring(className.lastIndexOf(46) + 1);
        if (mat instanceof ProxiedMatrix) {
            matrixName = matrixName + (((ProxiedMatrix)mat).isDiskMode() ? "[disk]" : "[memory]");
        }
        return matrixName;
    }

    private String getMatrixName(AbstractMatrix2D mat) {
        return this.getMatrixType(mat) + this.getMatrixSize(mat);
    }

    private String getMatrixSize(AbstractMatrix2D mat) {
        return "{" + mat.rows() + "," + mat.columns() + "}";
    }

    private DoubleMatrix2D testMultiply(DoubleMatrix2D A, DoubleMatrix2D B, DoubleMatrix2D C, DoubleMatrix2D result) {
        if (C == null) {
            System.out.println("zmult: matrix C created by " + this.getMatrixName((AbstractMatrix2D)A));
        }
        this.startMonitoring();
        C = A.zMult(B, C);
        this.printTime(this.getMatrixType((AbstractMatrix2D)A) + this.sizeA + " x " + this.getMatrixType((AbstractMatrix2D)B) + this.sizeB + " = " + this.getMatrixType((AbstractMatrix2D)C) + this.sizeC);
        try {
            this.assertFactoryEquals(C, result);
        }
        catch (IllegalStateException e) {
            if (debug) {
                System.out.println("A = " + A);
                System.out.println("x");
                System.out.println("B = " + B);
                System.out.println("=");
                System.out.println("C = " + C);
                System.out.println("instead of");
                System.out.println("retult = " + result);
            }
            throw (IllegalStateException)e.fillInStackTrace();
        }
        return C;
    }

    private DoubleMatrix2D testFactoryMultiply(DoubleMatrix2D A, DoubleMatrix2D B, DoubleMatrix2D C, DoubleMatrix2D result) {
        if (C == null) {
            System.out.println("zmult: matrix C created by " + this.getMatrixName((AbstractMatrix2D)A));
        }
        this.startMonitoring();
        C = DynamicDoubleFactory2D.zMult(A, B, C);
        this.printTime(this.getMatrixType((AbstractMatrix2D)A) + this.sizeA + "x" + this.getMatrixType((AbstractMatrix2D)B) + this.sizeB + "=" + this.getMatrixType((AbstractMatrix2D)C) + this.sizeC);
        if (A instanceof DynamicDoubleMatrix2D) {
            ((DynamicDoubleMatrix2D)A).logBatchState();
            ((DynamicDoubleMatrix2D)B).logBatchState();
            ((DynamicDoubleMatrix2D)C).logBatchState();
        }
        try {
            this.assertFactoryEquals(C, result);
        }
        catch (IllegalStateException e) {
            if (debug) {
                System.out.println("A = " + A);
                System.out.println("x");
                System.out.println("B = " + B);
                System.out.println("=");
                System.out.println("C = " + C);
                System.out.println("instead of");
                System.out.println("retult = " + result);
            }
            throw (IllegalStateException)e.fillInStackTrace();
        }
        return C;
    }

    private void assertEquals(DoubleMatrix2D A, DoubleMatrix2D B) {
        if (!this.testEquals(A, B)) {
            if (debug) {
                System.out.println("A = " + A);
                System.out.println("B = " + B);
            }
            throw new IllegalStateException("Unsuccessful");
        }
    }

    private void assertEquals(ObjectMatrix2D A, ObjectMatrix2D B) {
        if (!this.testEquals(A, B)) {
            if (debug) {
                System.out.println("A = " + A);
                System.out.println("B = " + B);
            }
            throw new IllegalStateException("Unsuccessful");
        }
    }

    private void assertFactoryEquals(DoubleMatrix2D A, DoubleMatrix2D B) {
        if (!this.testFactoryEquals(A, B)) {
            if (debug) {
                System.out.println("A = " + A);
                System.out.println("B = " + B);
            }
            throw new IllegalStateException("Unsuccessful");
        }
    }

    private void assertFactoryEquals(ObjectMatrix2D A, ObjectMatrix2D B) {
        if (!this.testFactoryEquals(A, B)) {
            if (debug) {
                System.out.println("A = " + A);
                System.out.println("B = " + B);
            }
            throw new IllegalStateException("Unsuccessful");
        }
    }

    private boolean testEquals(DoubleMatrix2D A, DoubleMatrix2D B) {
        this.startMonitoring();
        boolean b = A.equals((Object)B);
        this.printTime(this.getMatrixName((AbstractMatrix2D)A) + " tested equals to " + this.getMatrixName((AbstractMatrix2D)B));
        return b;
    }

    private boolean testEquals(ObjectMatrix2D A, ObjectMatrix2D B) {
        this.startMonitoring();
        boolean b = A.equals((Object)B);
        this.printTime(this.getMatrixName((AbstractMatrix2D)A) + " tested equals to " + this.getMatrixName((AbstractMatrix2D)B));
        return b;
    }

    private boolean testFactoryEquals(DoubleMatrix2D A, DoubleMatrix2D B) {
        this.startMonitoring();
        boolean b = DynamicDoubleFactory2D.areEquals(A, B);
        this.printTime(this.getMatrixName((AbstractMatrix2D)A) + " tested equals to " + this.getMatrixName((AbstractMatrix2D)B));
        return b;
    }

    private boolean testFactoryEquals(ObjectMatrix2D A, ObjectMatrix2D B) {
        this.startMonitoring();
        boolean b = DynamicObjectFactory2D.areEquals(A, B);
        this.printTime(this.getMatrixName((AbstractMatrix2D)A) + " tested equals to " + this.getMatrixName((AbstractMatrix2D)B));
        return b;
    }

    private void testFactory(DoubleFactory2D F, DoubleMatrix2D A, DoubleMatrix2D B, DoubleMatrix2D C, boolean useFactory) {
        DoubleMatrix2D apd = this.createAssign(F, A);
        DoubleMatrix2D bpd = this.createAssign(F, B);
        this.printTest("Testing equals");
        this.assertEquals(apd, A);
        this.assertEquals(A, apd);
        this.printTest("Testing viewDice");
        DoubleMatrix2D apd_view = apd.viewDice();
        DoubleMatrix2D A_view = A.viewDice();
        this.assertEquals(apd_view, A_view);
        this.assertEquals(A_view, apd_view);
        this.printTest("Testing viewColumnFlip");
        apd_view = apd.viewColumnFlip();
        A_view = A.viewColumnFlip();
        this.assertEquals(apd_view, A_view);
        this.assertEquals(A_view, apd_view);
        this.printTest("Testing viewRowFlip");
        apd_view = apd.viewRowFlip();
        A_view = A.viewRowFlip();
        this.assertEquals(apd_view, A_view);
        this.assertEquals(A_view, apd_view);
        this.printTest("Testing viewPart");
        apd_view = apd.viewPart(A.rows() / 10, A.columns() / 10, A.rows() / 3, A.columns() / 3);
        A_view = A.viewPart(A.rows() / 10, A.columns() / 10, A.rows() / 3, A.columns() / 3);
        this.assertEquals(apd_view, A_view);
        this.assertEquals(A_view, apd_view);
        this.printTest("Testing viewStrides");
        apd_view = apd.viewStrides(3, 3);
        A_view = A.viewStrides(3, 3);
        this.assertEquals(apd_view, A_view);
        this.assertEquals(A_view, apd_view);
        this.printTest("Testing viewSelection");
        Random r = new Random();
        int rs = r.nextInt(apd.rows());
        int cs = r.nextInt(apd.columns());
        int[] rss = new int[rs];
        for (int i = 0; i < rs; ++i) {
            rss[i] = r.nextInt(apd.rows());
        }
        int[] css = new int[cs];
        for (int i = 0; i < cs; ++i) {
            css[i] = r.nextInt(apd.columns());
        }
        apd_view = apd.viewSelection(rss, css);
        A_view = A.viewSelection(rss, css);
        this.assertEquals(apd_view, A_view);
        this.assertEquals(A_view, apd_view);
        this.printTest("Testing A * B");
        DoubleMatrix2D cpd = this.createC(F);
        this.testMultiply(apd, bpd, cpd, C);
        this.printTest("Testing A * Bref");
        cpd = this.createC(F);
        this.testMultiply(apd, B, cpd, C);
        this.printTest("Testing Aref * B (direct)");
        cpd = this.createC(F);
        this.testMultiply(A, bpd, cpd, C);
        this.printTest("Testing Aref * B (factory)");
        cpd = this.createC(F);
        this.testFactoryMultiply(A, bpd, cpd, C);
        if (!(apd instanceof ProxiedMatrix)) {
            return;
        }
        if (apd instanceof DynamicDoubleMatrix2D) {
            ((DynamicDoubleMatrix2D)apd).logBatchState();
            ((DynamicDoubleMatrix2D)bpd).logBatchState();
        }
        this.printTest("Going on disk");
        ((ProxiedMatrix)apd).setDiskMode();
        if (apd instanceof DynamicDoubleMatrix2D) {
            ((DynamicDoubleMatrix2D)apd).logBatchState();
        }
        ((ProxiedMatrix)bpd).setDiskMode();
        if (bpd instanceof DynamicDoubleMatrix2D) {
            ((DynamicDoubleMatrix2D)bpd).logBatchState();
        }
        this.printTest("Testing equals");
        this.assertEquals(apd, A);
        if (apd instanceof DynamicDoubleMatrix2D) {
            ((DynamicDoubleMatrix2D)apd).logBatchState();
        }
        if (useFactory) {
            this.assertFactoryEquals(A, apd);
        } else {
            this.assertEquals(A, apd);
        }
        this.printTest("Testing A * B");
        cpd = this.createC(F);
        if (cpd instanceof DynamicDoubleMatrix2D) {
            ((DynamicDoubleMatrix2D)cpd).logBatchState();
        }
        ((ProxiedMatrix)cpd).setDiskMode();
        if (cpd instanceof DynamicDoubleMatrix2D) {
            ((DynamicDoubleMatrix2D)cpd).logBatchState();
        }
        this.testMultiply(apd, bpd, cpd, C);
        if (apd instanceof DynamicDoubleMatrix2D) {
            ((DynamicDoubleMatrix2D)apd).logBatchState();
            ((DynamicDoubleMatrix2D)bpd).logBatchState();
            ((DynamicDoubleMatrix2D)cpd).logBatchState();
        }
        ((ProxiedMatrix)cpd).dispose();
        this.printTest("Testing A * Bref");
        cpd = this.createC(F);
        ((ProxiedMatrix)cpd).setDiskMode();
        if (cpd instanceof DynamicDoubleMatrix2D) {
            ((DynamicDoubleMatrix2D)cpd).logBatchState();
        }
        this.testMultiply(apd, B, cpd, C);
        if (cpd instanceof DynamicDoubleMatrix2D) {
            ((DynamicDoubleMatrix2D)cpd).logBatchState();
        }
        ((ProxiedMatrix)cpd).dispose();
        cpd = this.createC(F);
        if (cpd instanceof DynamicDoubleMatrix2D) {
            ((DynamicDoubleMatrix2D)cpd).logBatchState();
        }
        ((ProxiedMatrix)cpd).setDiskMode();
        if (cpd instanceof DynamicDoubleMatrix2D) {
            ((DynamicDoubleMatrix2D)cpd).logBatchState();
        }
        if (useFactory) {
            this.printTest("Testing Aref * B (factory)");
            this.testFactoryMultiply(A, bpd, cpd, C);
        } else {
            this.printTest("Testing Aref * B (direct)");
            this.testMultiply(A, bpd, cpd, C);
        }
        if (apd instanceof DynamicDoubleMatrix2D) {
            ((DynamicDoubleMatrix2D)apd).logBatchState();
            ((DynamicDoubleMatrix2D)bpd).logBatchState();
            ((DynamicDoubleMatrix2D)cpd).logBatchState();
        }
        ((ProxiedMatrix)apd).dispose();
        ((ProxiedMatrix)bpd).dispose();
        ((ProxiedMatrix)cpd).dispose();
    }

    private void testFactory(ObjectFactory2D F, ObjectMatrix2D A, ObjectMatrix2D B, boolean useFactory) {
        ObjectMatrix2D apd = this.createAssign(F, A);
        ObjectMatrix2D bpd = this.createAssign(F, B);
        this.printTest("Testing equals");
        this.assertEquals(apd, A);
        this.assertEquals(A, apd);
        this.printTest("Testing viewDice");
        ObjectMatrix2D apd_view = apd.viewDice();
        ObjectMatrix2D A_view = A.viewDice();
        this.assertEquals(apd_view, A_view);
        this.assertEquals(A_view, apd_view);
        this.printTest("Testing viewColumnFlip");
        apd_view = apd.viewColumnFlip();
        A_view = A.viewColumnFlip();
        this.assertEquals(apd_view, A_view);
        this.assertEquals(A_view, apd_view);
        this.printTest("Testing viewRowFlip");
        apd_view = apd.viewRowFlip();
        A_view = A.viewRowFlip();
        this.assertEquals(apd_view, A_view);
        this.assertEquals(A_view, apd_view);
        this.printTest("Testing viewPart");
        apd_view = apd.viewPart(A.rows() / 10, A.columns() / 10, A.rows() / 3, A.columns() / 3);
        A_view = A.viewPart(A.rows() / 10, A.columns() / 10, A.rows() / 3, A.columns() / 3);
        this.assertEquals(apd_view, A_view);
        this.assertEquals(A_view, apd_view);
        this.printTest("Testing viewStrides");
        apd_view = apd.viewStrides(3, 3);
        A_view = A.viewStrides(3, 3);
        this.assertEquals(apd_view, A_view);
        this.assertEquals(A_view, apd_view);
        this.printTest("Testing viewSelection");
        Random r = new Random();
        int rs = r.nextInt(apd.rows());
        int cs = r.nextInt(apd.columns());
        int[] rss = new int[rs];
        for (int i = 0; i < rs; ++i) {
            rss[i] = r.nextInt(apd.rows());
        }
        int[] css = new int[cs];
        for (int i = 0; i < cs; ++i) {
            css[i] = r.nextInt(apd.columns());
        }
        apd_view = apd.viewSelection(rss, css);
        A_view = A.viewSelection(rss, css);
        this.assertEquals(apd_view, A_view);
        this.assertEquals(A_view, apd_view);
        if (!(apd instanceof ProxiedMatrix)) {
            return;
        }
        this.printTest("Going on disk");
        ((ProxiedMatrix)apd).setDiskMode();
        ((ProxiedMatrix)bpd).setDiskMode();
        this.printTest("Testing equals");
        this.assertEquals(apd, A);
        if (useFactory) {
            this.assertFactoryEquals(A, apd);
        } else {
            this.assertEquals(A, apd);
        }
        ((ProxiedMatrix)apd).dispose();
        ((ProxiedMatrix)bpd).dispose();
    }

    public void run() {
        if (debug) {
            this.init(5, 6, 3);
        } else {
            this.init(35, 16, 28);
        }
        this.printTest("Running all tests " + this.size);
        this.doRowDynamicDenseTests();
        this.doRowDynamicSparseTests();
        this.doFullDynamicDenseTests();
        this.doFullDynamicSparseTests();
        if (debug) {
            this.initObject(5, 6, 3);
        } else {
            this.initObject(35, 16, 28);
        }
        this.printTest("Running all tests " + this.size);
        this.doObjectRowDynamicDenseTests();
        this.doObjectRowDynamicSparseTests();
        this.doObjectFullDynamicDenseTests();
        this.doObjectFullDynamicSparseTests();
    }

    private void doRowDynamicDenseTests() {
        this.printTest("Testing Row Dynamic Dense");
        this.testFactory(DynamicDoubleFactory2D.rowdynamic_dense, this.and, this.bnd, this.cnd, true);
        this.printTest("End test");
    }

    private void doRowDynamicSparseTests() {
        this.printTest("Testing Row Dynamic Sparse");
        this.testFactory(DynamicDoubleFactory2D.rowdynamic_sparse, this.ans, this.bns, this.cns, true);
        this.printTest("End test");
    }

    private void doFullDynamicDenseTests() {
        this.printTest("Testing Full Dynamic Dense");
        this.testFactory(DynamicDoubleFactory2D.fulldynamic_dense, this.and, this.bnd, this.cnd, true);
        this.printTest("End test");
    }

    private void doFullDynamicSparseTests() {
        this.printTest("Testing Full Dynamic Sparse");
        this.testFactory(DynamicDoubleFactory2D.fulldynamic_sparse, this.ans, this.bns, this.cns, true);
        this.printTest("End test");
    }

    private void doObjectRowDynamicDenseTests() {
        this.printTest("Testing Row Dynamic Dense");
        this.testFactory(DynamicObjectFactory2D.rowdynamic_dense, this.oand, this.obnd, true);
        this.printTest("End test");
    }

    private void doObjectRowDynamicSparseTests() {
        this.printTest("Testing Row Dynamic Sparse");
        this.testFactory(DynamicObjectFactory2D.rowdynamic_sparse, this.oans, this.obns, true);
        this.printTest("End test");
    }

    private void doObjectFullDynamicDenseTests() {
        this.printTest("Testing Full Dynamic Dense");
        this.testFactory(DynamicObjectFactory2D.fulldynamic_dense, this.oand, this.obnd, true);
        this.printTest("End test");
    }

    private void doObjectFullDynamicSparseTests() {
        this.printTest("Testing Full Dynamic Sparse");
        this.testFactory(DynamicObjectFactory2D.fulldynamic_sparse, this.oans, this.obns, true);
        this.printTest("End test");
    }

    public static void main(String[] args) {
        try {
            new Benchmark().run();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(3);
        }
    }
}

