/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Frame;
import java.text.DecimalFormat;
import org.opensourcephysics.controls.Animation;
import org.opensourcephysics.controls.Control;

public abstract class AbstractAnimation
implements Animation,
Runnable {
    protected Control control;
    protected volatile Thread animationThread;
    protected int delayTime = 100;
    protected DecimalFormat decimalFormat = new DecimalFormat("0.00E0");

    public void setControl(Control control) {
        this.control = control;
        if (control != null) {
            control.setLockValues(true);
            this.resetAnimation();
            control.setLockValues(false);
            if (control instanceof Frame) {
                ((Frame)((Object)control)).pack();
            }
        }
    }

    public Control getControl() {
        return this.control;
    }

    public void initializeAnimation() {
        this.control.clearMessages();
    }

    protected abstract void doStep();

    public synchronized void stopAnimation() {
        if (this.animationThread == null) {
            return;
        }
        Thread tempThread = this.animationThread;
        this.animationThread = null;
        if (Thread.currentThread() == tempThread) {
            return;
        }
        if (tempThread != null && tempThread != Thread.currentThread()) {
            try {
                tempThread.interrupt();
                tempThread.join(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public final boolean isRunning() {
        return this.animationThread != null;
    }

    public synchronized void stepAnimation() {
        if (this.animationThread != null) {
            this.stopAnimation();
        }
        this.doStep();
    }

    public synchronized void startAnimation() {
        if (this.animationThread != null) {
            return;
        }
        this.animationThread = new Thread(this);
        this.animationThread.setPriority(1);
        this.animationThread.setDaemon(true);
        this.animationThread.start();
    }

    public void resetAnimation() {
        if (this.animationThread != null) {
            this.stopAnimation();
        }
        this.control.clearMessages();
    }

    public void run() {
        long sleepTime = this.delayTime;
        while (this.animationThread == Thread.currentThread()) {
            long currentTime = System.currentTimeMillis();
            this.doStep();
            sleepTime = Math.max(10L, (long)this.delayTime - (System.currentTimeMillis() - currentTime));
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException ie) {}
        }
    }
}

