/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.TextFrame;

public class ControlUtils {
    static String version = "1.0.4";
    static String releaseDate = "Sept 15, 2006";
    static DecimalFormat format2 = new DecimalFormat("#0.00");
    static DecimalFormat format3 = new DecimalFormat("#0.000");
    static DecimalFormat format4 = new DecimalFormat("#0.0000");
    static DecimalFormat format_E2 = new DecimalFormat("0.00E0");
    static DecimalFormat format_E3 = new DecimalFormat("0.000E0");
    static DecimalFormat format_E4 = new DecimalFormat("0.0000E0");
    protected static JFileChooser chooser;
    private static TextFrame sysPropFrame;

    public static String f2(double d) {
        return format2.format(d);
    }

    public static String f3(double d) {
        return format3.format(d);
    }

    public static String e2(double d) {
        return format_E2.format(d);
    }

    public static String e3(double d) {
        return format_E3.format(d);
    }

    public static String e4(double d) {
        return format_E4.format(d);
    }

    public static String f4(double d) {
        return format4.format(d);
    }

    private ControlUtils() {
    }

    public static JFrame showSystemProperties(boolean vis) {
        if (sysPropFrame == null) {
            sysPropFrame = new TextFrame(null, null);
            sysPropFrame.getTextPane().setText(ControlUtils.getSystemProperties());
            ((Component)sysPropFrame).setSize(300, 400);
        }
        ((Component)sysPropFrame).setVisible(vis);
        return sysPropFrame;
    }

    public static String getSystemProperties() {
        StringBuffer buffer = new StringBuffer();
        try {
            Properties sysProps = System.getProperties();
            int i = 0;
            Enumeration<?> names = sysProps.propertyNames();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                buffer.append(++i + ". " + key + " = " + sysProps.getProperty(key) + "\n");
            }
        }
        catch (Exception e) {
            String[] key = new String[]{"java.version", "java.vendor", "java.class.version", "os.name", "os.arch", "os.version", "file.separator", "path.separator", "line.separator"};
            for (int i = 0; i < key.length; ++i) {
                buffer.append(i + ". " + key[i] + " = " + System.getProperty(key[i]) + "\n");
            }
        }
        return buffer.toString();
    }

    public static void loadParameters(Control control, Component parent) {
        JFileChooser chooser = new JFileChooser(new File(OSPFrame.chooserDir));
        int result = chooser.showOpenDialog(parent);
        if (result == 0) {
            try {
                BufferedReader inFile = new BufferedReader(new FileReader(chooser.getSelectedFile()));
                ControlUtils.readFile(control, inFile);
                inFile.close();
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        }
    }

    public static void saveToFile(Object object, Component parent) {
        int selected;
        JFileChooser fileChooser = new JFileChooser(new File(OSPFrame.chooserDir));
        int result = fileChooser.showSaveDialog(parent);
        if (result != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (file.exists() && (selected = JOptionPane.showConfirmDialog(parent, "A file named " + file.getName() + " already exists. Are you sure you want to replace it?", "Warning", 1)) != 0) {
            return;
        }
        try {
            FileWriter fw = new FileWriter(file);
            PrintWriter pw = new PrintWriter(fw);
            pw.print(object.toString());
            pw.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(parent, "An error occurred while saving your file. Please try again.", "Error", 0);
        }
    }

    public static void saveXML(Object obj) {
        int result = ControlUtils.getXMLFileChooser().showSaveDialog(null);
        if (result == 0) {
            int selected;
            File file = chooser.getSelectedFile();
            if (file.exists() && (selected = JOptionPane.showConfirmDialog(null, "Replace existing " + file.getName() + "?", "Replace File", 1)) != 0) {
                return;
            }
            String fileName = XML.getRelativePath(file.getAbsolutePath());
            if (fileName == null || fileName.trim().equals("")) {
                return;
            }
            int i = fileName.toLowerCase().lastIndexOf(".xml");
            if (i != fileName.length() - 4) {
                fileName = fileName + ".xml";
            }
            XMLControlElement xml = new XMLControlElement(obj);
            xml.write(fileName);
        }
    }

    public static JFileChooser getXMLFileChooser() {
        if (chooser != null) {
            return chooser;
        }
        chooser = new JFileChooser(new File(OSPFrame.chooserDir));
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                String extension = null;
                String name = f.getName();
                int i = name.lastIndexOf(46);
                if (i > 0 && i < name.length() - 1) {
                    extension = name.substring(i + 1).toLowerCase();
                }
                return extension != null && (extension.equals("xml") || extension.equals("osp"));
            }

            public String getDescription() {
                return "XML files";
            }
        };
        chooser.addChoosableFileFilter(filter);
        return chooser;
    }

    private static void readFile(Control control, BufferedReader inFile) throws IOException {
        String nextLine = inFile.readLine();
        while (nextLine != null) {
            String par = ControlUtils.parseParameter(nextLine);
            if (par != null && !par.equals("")) {
                control.setValue(par, ControlUtils.parseValue(nextLine));
            }
            nextLine = inFile.readLine();
        }
    }

    private static String parseParameter(String aLine) {
        int index = aLine.indexOf(61);
        if (index < 1) {
            return null;
        }
        return aLine.substring(0, index).trim();
    }

    private static String parseValue(String aLine) {
        int index = aLine.indexOf(61);
        if (index >= aLine.length() - 1) {
            return "";
        }
        return aLine.substring(index + 1).trim();
    }
}

