/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.opensourcephysics.controls.ControlFrame;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTable;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.numerics.DoubleArray;
import org.opensourcephysics.numerics.IntegerArray;
import org.opensourcephysics.numerics.Util;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.TranslatorTool;

public class OSPControl
extends ControlFrame
implements PropertyChangeListener {
    XMLControl control = new XMLControlElement();
    XMLTable table = new XMLTable(this.control);
    JScrollPane controlScrollPane = new JScrollPane(this.table);
    JTextArea messageTextArea;
    JLabel clearLabel;
    JLabel messageLabel;
    JLabel inputLabel;
    JSplitPane splitPane;
    JMenuItem translateItem;
    private boolean lockValues = false;
    HashMap valueCache = new HashMap();
    static final Color PANEL_BACKGROUND = UIManager.getColor("Panel.background");
    static final Color NOT_EDITABLE_BACKGROUND = Color.WHITE;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$opensourcephysics$numerics$DoubleArray;
    static /* synthetic */ Class class$org$opensourcephysics$numerics$IntegerArray;

    public OSPControl(Object _model) {
        super(ControlsRes.getString("OSPControl.Default_Title"));
        this.model = _model;
        if (this.model != null) {
            TranslatorTool.associate(this, this.model.getClass());
            String name = this.model.getClass().getName();
            this.setTitle(name.substring(1 + name.lastIndexOf(".")) + ControlsRes.getString("OSPControl.Controller"));
        }
        ToolsRes.addPropertyChangeListener("locale", this);
        Font labelFont = new Font("Dialog", 1, 12);
        this.inputLabel = new JLabel(ControlsRes.getString("OSPControl.Input_Parameters"), 0);
        this.inputLabel.setFont(labelFont);
        this.messageTextArea = new JTextArea(5, 5);
        JScrollPane messageScrollPane = new JScrollPane(this.messageTextArea);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)this.inputLabel, "North");
        topPanel.add((Component)this.controlScrollPane, "Center");
        this.buttonPanel.setVisible(true);
        topPanel.add((Component)this.buttonPanel, "South");
        JPanel clearPanel = new JPanel(new BorderLayout());
        clearPanel.addMouseListener(new ClearMouseAdapter());
        this.clearLabel = new JLabel(ControlsRes.getString("OSPControl.Clear"));
        this.clearLabel.setFont(new Font(this.clearLabel.getFont().getFamily(), 0, 9));
        this.clearLabel.setForeground(Color.black);
        clearPanel.add((Component)this.clearLabel, "West");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        this.messageLabel = new JLabel(ControlsRes.getString("OSPControl.Messages"), 0);
        this.messageLabel.setFont(labelFont);
        bottomPanel.add((Component)this.messageLabel, "North");
        bottomPanel.add((Component)messageScrollPane, "Center");
        bottomPanel.add((Component)clearPanel, "South");
        Container cp = this.getContentPane();
        this.splitPane = new JSplitPane(0, topPanel, bottomPanel);
        this.splitPane.setOneTouchExpandable(true);
        cp.add((Component)this.splitPane, "Center");
        this.messageTextArea.setEditable(false);
        this.controlScrollPane.setPreferredSize(new Dimension(350, 200));
        this.controlScrollPane.setMinimumSize(new Dimension(0, 50));
        messageScrollPane.setPreferredSize(new Dimension(350, 75));
        TranslatorTool.associate(this.table, this.model.getClass());
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        this.init();
    }

    protected JMenu loadDisplayMenu() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return null;
        }
        JMenu menu = super.loadDisplayMenu();
        this.translateItem = new JMenuItem();
        this.translateItem.setText(ControlsRes.getString("OSPControl.Translate"));
        this.translateItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TranslatorTool tool = TranslatorTool.getTool();
                tool.showProperties(OSPControl.this.model.getClass());
                tool.setKeepHidden(false);
                tool.setVisible(true);
            }
        });
        this.translateItem.setEnabled(OSPFrame.authorMode);
        this.languageMenu.add((Component)this.translateItem, 0);
        if (this.languageMenu.getItemCount() > 1) {
            this.languageMenu.insertSeparator(1);
        }
        return menu;
    }

    protected void refreshGUI() {
        super.refreshGUI();
        this.messageLabel.setText(ControlsRes.getString("OSPControl.Messages"));
        this.clearLabel.setText(ControlsRes.getString("OSPControl.Clear"));
        this.inputLabel.setText(ControlsRes.getString("OSPControl.Input_Parameters"));
        this.table.refresh();
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("translation") || name.equals("locale")) {
            this.refreshGUI();
        } else {
            this.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
        }
    }

    protected void init() {
        this.splitPane.setDividerLocation(-1);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    public Object getModel() {
        return this.model;
    }

    public void setDividerLocation(int loc) {
        this.splitPane.setDividerLocation(loc);
    }

    public void setEditable(String parameter, boolean editable) {
        this.table.setEditable(parameter, editable);
    }

    public void setLockValues(boolean lock) {
        this.control.setLockValues(lock);
        this.lockValues = lock;
        if (!this.lockValues) {
            this.table.refresh();
        }
    }

    public String toString() {
        return this.table.toString();
    }

    public void setValue(String par, Object val) {
        this.control.setValue(par, val);
        if (!this.lockValues) {
            this.table.refresh();
        }
    }

    public void setValue(String par, boolean val) {
        this.control.setValue(par, val);
    }

    public void setValue(String par, double val) {
        this.setValue(par, Double.toString(val));
        if (!Double.isNaN(val)) {
            this.valueCache.put(par, new Double(val));
        }
    }

    public void setValue(String par, int val) {
        this.setValue(par, Integer.toString(val));
        this.valueCache.put(par, new Double(val));
    }

    public void removeParameter(String par) {
        this.control.setValue(par, null);
    }

    public double getDouble(String par) {
        String str = this.control.getString(par);
        Color color = (Color)this.table.cellColors.get(par);
        boolean editable = this.table.isEditable(par);
        try {
            double val = Double.parseDouble(str);
            if (editable && color != Color.WHITE) {
                this.table.setBackgroundColor(par, Color.WHITE);
                this.table.refresh();
            } else if (!editable && color != NOT_EDITABLE_BACKGROUND) {
                this.table.setBackgroundColor(par, NOT_EDITABLE_BACKGROUND);
                this.table.refresh();
            }
            this.valueCache.put(par, new Double(val));
            return val;
        }
        catch (NumberFormatException ex) {
            double val = Util.evalMath(str);
            if (Double.isNaN(val) && color != Color.PINK) {
                this.table.setBackgroundColor(par, Color.PINK);
                this.table.refresh();
            } else if (editable && color != Color.WHITE) {
                this.table.setBackgroundColor(par, Color.WHITE);
                this.table.refresh();
            } else if (!editable && color != NOT_EDITABLE_BACKGROUND) {
                this.table.setBackgroundColor(par, NOT_EDITABLE_BACKGROUND);
                this.table.refresh();
            }
            if (Double.isNaN(val) && this.valueCache.containsKey(par)) {
                val = (Double)this.valueCache.get(par);
            } else {
                this.valueCache.put(par, new Double(val));
            }
            return val;
        }
    }

    public int getInt(String par) {
        String str = this.control.getString(par);
        Color color = (Color)this.table.cellColors.get(par);
        boolean editable = this.table.isEditable(par);
        try {
            int val = Integer.parseInt(par);
            if (editable && color != Color.WHITE) {
                this.table.setBackgroundColor(par, Color.WHITE);
                this.table.refresh();
            } else if (!editable && color != NOT_EDITABLE_BACKGROUND) {
                this.table.setBackgroundColor(par, NOT_EDITABLE_BACKGROUND);
                this.table.refresh();
            }
            this.valueCache.put(par, new Double(val));
            return val;
        }
        catch (NumberFormatException ex) {
            try {
                int val = (int)Double.parseDouble(par);
                if (editable && color != Color.WHITE) {
                    this.table.setBackgroundColor(par, Color.WHITE);
                    this.table.refresh();
                } else if (!editable && color != NOT_EDITABLE_BACKGROUND) {
                    this.table.setBackgroundColor(par, NOT_EDITABLE_BACKGROUND);
                    this.table.refresh();
                }
                this.valueCache.put(par, new Double(val));
                return val;
            }
            catch (NumberFormatException ex2) {
                double dval = Util.evalMath(str);
                if (Double.isNaN(dval) && color != Color.PINK) {
                    this.table.setBackgroundColor(par, Color.PINK);
                    this.table.refresh();
                    if (this.valueCache.containsKey(par)) {
                        return (int)((Double)this.valueCache.get(par)).doubleValue();
                    }
                    return 0;
                }
                if (editable && color != Color.WHITE) {
                    this.table.setBackgroundColor(par, Color.WHITE);
                    this.table.refresh();
                } else if (!editable && color != NOT_EDITABLE_BACKGROUND) {
                    this.table.setBackgroundColor(par, NOT_EDITABLE_BACKGROUND);
                    this.table.refresh();
                }
                this.valueCache.put(par, new Double(dval));
                return (int)dval;
            }
        }
    }

    public Object getObject(String par) throws UnsupportedOperationException {
        return this.control.getObject(par);
    }

    public String getString(String par) {
        return this.control.getString(par);
    }

    public boolean getBoolean(String par) {
        return this.control.getBoolean(par);
    }

    public Collection getPropertyNames() {
        return this.control.getPropertyNames();
    }

    public JButton addButton(String methodName, String text) {
        return this.addButton(methodName, text, null, this.model);
    }

    public JButton addButton(String methodName, String text, String toolTipText) {
        return this.addButton(methodName, text, toolTipText, this.model);
    }

    public void addControlListener(String methodName) {
        this.addControlListener(methodName, this.model);
    }

    public void addControlListener(String methodName, final Object target) {
        Class[] parameters = new Class[]{class$java$lang$String == null ? (class$java$lang$String = OSPControl.class$("java.lang.String")) : class$java$lang$String};
        try {
            final Method m = target.getClass().getMethod(methodName, parameters);
            this.table.tableModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    if (e.getType() != 0 || e.getColumn() != 1 || e.getFirstRow() < 0) {
                        return;
                    }
                    String name = OSPControl.this.table.getValueAt(e.getFirstRow(), 0).toString();
                    Object[] args = new Object[]{name};
                    try {
                        m.invoke(target, args);
                    }
                    catch (IllegalAccessException iae) {
                    }
                    catch (InvocationTargetException ite) {
                        // empty catch block
                    }
                }
            });
        }
        catch (NoSuchMethodException nsme) {
            System.err.println("The method " + methodName + "() does not exist.");
        }
    }

    public void println(String s) {
        this.print(s + "\n");
    }

    public void println() {
        this.print("\n");
    }

    public void print(final String s) {
        if (SwingUtilities.isEventDispatchThread() || Thread.currentThread().getName().equals("main")) {
            this.messageTextArea.append(s);
            return;
        }
        Runnable doLater = new Runnable(){

            public void run() {
                OSPControl.this.messageTextArea.append(s);
            }
        };
        EventQueue.invokeLater(doLater);
    }

    public void clearMessages() {
        if (SwingUtilities.isEventDispatchThread() || Thread.currentThread().getName().equals("main")) {
            this.messageTextArea.setText("");
            return;
        }
        Runnable doLater = new Runnable(){

            public void run() {
                OSPControl.this.messageTextArea.setText("");
            }
        };
        EventQueue.invokeLater(doLater);
    }

    public void clearValues() {
        this.control.clearValues();
    }

    public void calculationDone(String message) {
        if (message != null) {
            this.println(message);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new OSPControlLoader();
    }

    public static OSPControl createApp(Object model) {
        OSPControl control = new OSPControl(model);
        control.setSize(300, 300);
        control.setVisible(true);
        return control;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class OSPControlLoader
    implements XML.ObjectLoader {
        OSPControlLoader() {
        }

        public void saveObject(XMLControl xmlControl, Object obj) {
            OSPControl ospControl = (OSPControl)obj;
            this.saveControlProperites(xmlControl, ospControl);
            if (xmlControl.getLevel() == 0) {
                xmlControl.setValue("model", ospControl.model);
            }
        }

        protected void saveControlProperites(XMLControl xmlControl, OSPControl ospControl) {
            Iterator it = ospControl.getPropertyNames().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                Object val = ospControl.getObject(name);
                if (val.getClass() == (class$org$opensourcephysics$numerics$DoubleArray == null ? OSPControl.class$("org.opensourcephysics.numerics.DoubleArray") : class$org$opensourcephysics$numerics$DoubleArray)) {
                    xmlControl.setValue(name, ((DoubleArray)val).getArray());
                    continue;
                }
                if (val.getClass() == (class$org$opensourcephysics$numerics$IntegerArray == null ? OSPControl.class$("org.opensourcephysics.numerics.IntegerArray") : class$org$opensourcephysics$numerics$IntegerArray)) {
                    xmlControl.setValue(name, ((IntegerArray)val).getArray());
                    continue;
                }
                if (val.getClass() == (class$java$lang$Boolean == null ? OSPControl.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    xmlControl.setValue(name, (Boolean)val);
                    continue;
                }
                if (val.getClass() == (class$java$lang$Double == null ? OSPControl.class$("java.lang.Double") : class$java$lang$Double)) {
                    xmlControl.setValue(name, (Double)val);
                    continue;
                }
                if (val.getClass() == (class$java$lang$Integer == null ? OSPControl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    xmlControl.setValue(name, (Integer)val);
                    continue;
                }
                if (val.getClass().isArray()) {
                    xmlControl.setValue(name, val);
                    continue;
                }
                xmlControl.setValue(name, val);
            }
        }

        public Object createObject(XMLControl control) {
            return new OSPControl((Object)null);
        }

        public Object loadObject(XMLControl control, Object obj) {
            OSPControl cf = (OSPControl)obj;
            Iterator it = control.getPropertyNames().iterator();
            cf.control.setLockValues(true);
            while (it.hasNext()) {
                String name = (String)it.next();
                if (control.getPropertyType(name).equals("string")) {
                    cf.setValue(name, control.getString(name));
                    continue;
                }
                if (control.getPropertyType(name).equals("int")) {
                    cf.setValue(name, control.getInt(name));
                    continue;
                }
                if (control.getPropertyType(name).equals("double")) {
                    cf.setValue(name, control.getDouble(name));
                    continue;
                }
                if (control.getPropertyType(name).equals("boolean")) {
                    cf.setValue(name, control.getBoolean(name));
                    continue;
                }
                cf.setValue(name, control.getObject(name));
            }
            cf.control.setLockValues(false);
            XMLControl child = control.getChildControl("model");
            if (child != null) {
                cf.model = child.loadObject(cf.model);
            }
            return obj;
        }
    }

    class ClearMouseAdapter
    extends MouseAdapter {
        ClearMouseAdapter() {
        }

        public void mousePressed(MouseEvent evt) {
            OSPControl.this.clearMessages();
        }

        public void mouseEntered(MouseEvent evt) {
            OSPControl.this.clearLabel.setFont(new Font(OSPControl.this.clearLabel.getFont().getFamily(), 1, 10));
            OSPControl.this.clearLabel.setText(ControlsRes.getString("OSPControl.Click_to_clear_message"));
        }

        public void mouseExited(MouseEvent evt) {
            OSPControl.this.clearLabel.setFont(new Font(OSPControl.this.clearLabel.getFont().getFamily(), 0, 9));
            OSPControl.this.clearLabel.setText(ControlsRes.getString("OSPControl.Clear"));
        }
    }
}

