/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Rectangle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import org.opensourcephysics.controls.ConsoleLevel;
import org.opensourcephysics.controls.OSPLog;

class OSPLogHandler
extends Handler {
    JTextPane log;

    public OSPLogHandler(JTextPane textPane) {
        this.log = textPane;
    }

    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        String msg = this.getFormatter().format(record);
        Style style = OSPLog.green;
        int val = record.getLevel().intValue();
        if (val == ConsoleLevel.ERR_CONSOLE.intValue()) {
            style = OSPLog.magenta;
        } else if (val == ConsoleLevel.OUT_CONSOLE.intValue()) {
            style = OSPLog.gray;
        } else if (val >= Level.WARNING.intValue()) {
            style = OSPLog.red;
        } else if (val >= Level.INFO.intValue()) {
            style = OSPLog.black;
        } else if (val >= Level.CONFIG.intValue()) {
            style = OSPLog.green;
        } else if (val >= Level.FINEST.intValue()) {
            style = OSPLog.blue;
        }
        try {
            Document doc = this.log.getDocument();
            doc.insertString(doc.getLength(), msg + '\n', style);
            Rectangle rect = this.log.getBounds();
            rect.y = rect.height;
            this.log.scrollRectToVisible(rect);
        }
        catch (BadLocationException ex) {
            System.err.println(ex);
        }
    }

    public void flush() {
    }

    public void close() {
    }
}

