/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPControlTable;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTable;

public class OSPTableInspector
extends JDialog
implements PropertyChangeListener {
    static final String FRAME_TITLE = ControlsRes.getString("OSPTableInspector.Properties_of");
    private OSPControlTable table;

    public OSPTableInspector() {
        this(true, true);
    }

    public OSPTableInspector(boolean editable) {
        this(editable, true);
    }

    public OSPTableInspector(boolean editable, boolean modal) {
        this(null, editable, modal);
    }

    public OSPTableInspector(Frame owner, boolean editable, boolean modal) {
        super(owner, modal);
        XMLControlElement control = new XMLControlElement();
        this.table = new OSPControlTable(control);
        this.table.setEditable(editable);
        this.table.addPropertyChangeListener("cell", this);
        this.createGUI();
        String s = XML.getExtension(control.getObjectClassName());
        this.setTitle(FRAME_TITLE + " " + s + " \"" + control.getPropertyName() + "\" ");
    }

    public Control getControl() {
        return this.table;
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
    }

    public XMLTable getTable() {
        return this.table;
    }

    private void createGUI() {
        ((Component)this).setSize(400, 300);
        this.setContentPane(new JPanel(new BorderLayout()));
        JScrollPane scrollpane = new JScrollPane(this.table);
        scrollpane.createHorizontalScrollBar();
        this.getContentPane().add((Component)scrollpane, "Center");
        if (!JDialog.isDefaultLookAndFeelDecorated()) {
            return;
        }
        JPanel panel = new JPanel(new FlowLayout());
        JButton closeButton = new JButton(ControlsRes.getString("OSPTableInspector.OK"));
        panel.add(closeButton);
        this.getContentPane().add((Component)panel, "South");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((Component)OSPTableInspector.this).setVisible(false);
                OSPTableInspector.this.dispose();
            }
        });
    }
}

