/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.AnimationControl;
import org.opensourcephysics.controls.OSPControl;
import org.opensourcephysics.controls.SimControl;
import org.opensourcephysics.controls.Simulation;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;

public class SimulationControl
extends AnimationControl
implements SimControl {
    Set fixedParameters = new HashSet();

    public SimulationControl(Simulation animation) {
        super(animation);
    }

    public void setParameterToFixed(String name, boolean fixed) {
        if (fixed) {
            this.fixedParameters.add(name);
        } else {
            this.fixedParameters.remove(name);
        }
        this.table.refresh();
    }

    public boolean isParamterFixed(String name) {
        return this.fixedParameters.contains(name);
    }

    public void setValue(String name, Object val) {
        super.setValue(name, val);
        this.fixedParameters.add(name);
    }

    public void setAdjustableValue(String name, Object val) {
        super.setValue(name, val);
        this.fixedParameters.remove(name);
    }

    public void setValue(String name, double val) {
        super.setValue(name, val);
        this.fixedParameters.add(name);
    }

    public void setAdjustableValue(String name, double val) {
        super.setValue(name, val);
        this.fixedParameters.remove(name);
    }

    public void setValue(String name, int val) {
        super.setValue(name, val);
        this.fixedParameters.add(name);
    }

    public void setAdjustableValue(String name, int val) {
        super.setValue(name, val);
        this.fixedParameters.remove(name);
    }

    public void setValue(String name, boolean val) {
        super.setValue(name, val);
        this.fixedParameters.add(name);
    }

    public void removeParameter(String name) {
        super.removeParameter(name);
        this.fixedParameters.remove(name);
    }

    public void setAdjustableValue(String name, boolean val) {
        super.setValue(name, val);
        this.fixedParameters.remove(name);
    }

    void resetBtnActionPerformed(ActionEvent e) {
        Iterator it = this.fixedParameters.iterator();
        while (it.hasNext()) {
            String par = (String)it.next();
            this.table.setEditable(par, true);
            this.table.setBackgroundColor(par, Color.WHITE);
        }
        this.table.refresh();
        super.resetBtnActionPerformed(e);
    }

    void startBtnActionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(this.initText)) {
            this.table.setEditable(true);
            Iterator it = this.fixedParameters.iterator();
            while (it.hasNext()) {
                String par = (String)it.next();
                this.table.setEditable(par, false);
                this.table.setBackgroundColor(par, OSPControl.NOT_EDITABLE_BACKGROUND);
            }
        } else if (e.getActionCommand().equals(this.startText)) {
            Iterator it = this.control.getPropertyNames().iterator();
            while (it.hasNext()) {
                String par = (String)it.next();
                this.table.setEditable(par, false);
                this.table.setBackgroundColor(par, OSPControl.NOT_EDITABLE_BACKGROUND);
            }
        } else if (e.getActionCommand().equals(this.stopText)) {
            Iterator it = this.control.getPropertyNames().iterator();
            while (it.hasNext()) {
                String par = (String)it.next();
                if (this.fixedParameters.contains(par)) continue;
                this.table.setEditable(par, true);
                this.table.setBackgroundColor(par, Color.WHITE);
            }
        }
        this.table.refresh();
        super.startBtnActionPerformed(e);
    }

    public static XML.ObjectLoader getLoader() {
        return new SimulationControlLoader();
    }

    public static SimulationControl createApp(Simulation model) {
        SimulationControl control = new SimulationControl(model);
        model.setControl(control);
        return control;
    }

    public static SimulationControl createApp(Simulation model, String[] xml) {
        SimulationControl control = SimulationControl.createApp(model);
        control.loadXML(xml);
        return control;
    }

    static class SimulationControlLoader
    extends AnimationControl.AnimationControlLoader {
        SimulationControlLoader() {
        }

        public Object createObject(XMLControl element) {
            return new SimulationControl(null);
        }

        public Object loadObject(XMLControl element, Object obj) {
            SimulationControl sc = (SimulationControl)obj;
            Object[] fixedParm = sc.fixedParameters.toArray();
            super.loadObject(element, obj);
            sc.fixedParameters.clear();
            int n = fixedParm.length;
            for (int i = 0; i < n; ++i) {
                sc.fixedParameters.add(fixedParm[i]);
            }
            Iterator it = sc.control.getPropertyNames().iterator();
            while (it.hasNext()) {
                String parm = (String)it.next();
                if (sc.fixedParameters.contains(parm)) continue;
                sc.table.setEditable(parm, true);
                sc.table.setBackgroundColor(parm, Color.WHITE);
            }
            if (sc.model instanceof AbstractSimulation && element.getObject("steps per display") != null) {
                ((AbstractSimulation)sc.model).enableStepsPerDisplay(true);
                ((AbstractSimulation)sc.model).setStepsPerDisplay(Integer.parseInt(element.getString("steps per display")));
            } else {
                ((AbstractSimulation)sc.model).enableStepsPerDisplay(false);
            }
            return obj;
        }
    }
}

