/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;

public class XML {
    public static String NEW_LINE = "/n";
    public static final String CDATA_PRE = "<![CDATA[";
    public static final String CDATA_POST = "]]>";
    public static final int INDENT = 4;
    private static Map loaders = new HashMap();
    private static ObjectLoader defaultLoader;
    private static String dtdName;
    private static String dtd;
    private static String defaultName;
    private static ClassLoader classLoader;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$org$opensourcephysics$controls$XML;

    private XML() {
    }

    public static void setLoader(Class classtype, ObjectLoader loader) {
        loaders.put(classtype, loader);
    }

    public static ObjectLoader getLoader(Class classtype) {
        ObjectLoader loader = (ObjectLoader)loaders.get(classtype);
        if (loader == null) {
            try {
                Method method = classtype.getMethod("getLoader", null);
                if (method != null && Modifier.isStatic(method.getModifiers()) && (loader = (ObjectLoader)method.invoke(null, (Object[])null)) != null) {
                    XML.setLoader(classtype, loader);
                }
            }
            catch (IllegalAccessException ex) {
            }
            catch (IllegalArgumentException ex) {
            }
            catch (InvocationTargetException ex) {
            }
            catch (NoSuchMethodException ex) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (loader == null) {
            if (defaultLoader == null) {
                defaultLoader = new XMLLoader();
            }
            loader = defaultLoader;
        }
        return loader;
    }

    public static void setDefaultLoader(ObjectLoader loader) {
        defaultLoader = loader;
    }

    public static String getDataType(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return "string";
        }
        if (obj instanceof Collection) {
            return "collection";
        }
        if (obj.getClass().isArray()) {
            Class<?> componentType = obj.getClass().getComponentType();
            while (componentType.isArray()) {
                componentType = componentType.getComponentType();
            }
            String type = componentType.getName();
            if (type.indexOf(".") == -1 && "intdoubleboolean".indexOf(type) == -1) {
                return null;
            }
            return "array";
        }
        if (obj instanceof Double) {
            return "double";
        }
        if (obj instanceof Integer) {
            return "int";
        }
        return "object";
    }

    public static String[] getDataTypes() {
        return new String[]{"object", "array", "collection", "string", "int", "double", "boolean"};
    }

    public static boolean requiresCDATA(String text) {
        return text.indexOf("\"") != -1 || text.indexOf("<") != -1 || text.indexOf(">") != -1 || text.indexOf("&") != -1 || text.indexOf("'") != -1;
    }

    public static String getDTD(String doctype) {
        if (dtdName != doctype) {
            dtdName = defaultName;
            try {
                String dtdPath = "/org/opensourcephysics/resources/controls/doctypes/";
                URL url = (class$org$opensourcephysics$controls$XML == null ? (class$org$opensourcephysics$controls$XML = XML.class$("org.opensourcephysics.controls.XML")) : class$org$opensourcephysics$controls$XML).getResource(dtdPath + doctype);
                if (url == null) {
                    return dtd;
                }
                Object content = url.getContent();
                if (content instanceof InputStream) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)content));
                    StringBuffer buffer = new StringBuffer(0);
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line + NEW_LINE);
                    }
                    dtd = buffer.toString();
                    dtdName = doctype;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return dtd;
    }

    public static void setClassLoader(ClassLoader loader) {
        classLoader = loader;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static String forwardSlash(String path) {
        if (path == null) {
            return "";
        }
        int i = path.indexOf("\\");
        while (i != -1) {
            path = path.substring(0, i) + "/" + path.substring(i + 1);
            i = path.indexOf("\\");
        }
        return path;
    }

    public static String getName(String path) {
        if (path == null) {
            return "";
        }
        int i = path.lastIndexOf("/");
        if (i == -1) {
            i = path.lastIndexOf("\\");
        }
        if (i != -1) {
            return path.substring(i + 1);
        }
        return path;
    }

    public static String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            return fileName.substring(i + 1);
        }
        return null;
    }

    public static String getSimpleClassName(Class type) {
        String name = type.getName();
        int i = name.indexOf(";");
        if (i > -1) {
            name = name.substring(0, i);
        }
        while (name.startsWith("[")) {
            name = name.substring(1);
            name = name + "[]";
        }
        String ext = XML.getExtension(name);
        if (ext != null) {
            name = ext;
        }
        if ((i = name.indexOf("[")) > -1) {
            String s = name.substring(0, i);
            if (s.equals("I")) {
                s = "int";
            } else if (s.equals("D")) {
                s = "double";
            } else if (s.equals("Z")) {
                s = "boolean";
            }
            name = s + name.substring(i);
        }
        return name;
    }

    public static String stripExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            return fileName.substring(0, i);
        }
        return fileName;
    }

    public static String getPathRelativeTo(String absolutePath, String base) {
        if (base == null || base.equals("")) {
            base = XML.getUserDirectory();
        }
        absolutePath = XML.forwardSlash(absolutePath);
        base = XML.forwardSlash(base);
        if (!absolutePath.startsWith("/") && absolutePath.indexOf(":") == -1) {
            return absolutePath;
        }
        if (!base.startsWith("/") && base.indexOf(":") == -1) {
            return absolutePath;
        }
        int jar = absolutePath.indexOf("jar!");
        if (jar > -1) {
            absolutePath = absolutePath.substring(jar + 5);
            return absolutePath;
        }
        String relativePath = "";
        if (base.endsWith("/")) {
            base = base.substring(0, base.length() - 1);
        }
        for (int j = 0; j < 6; ++j) {
            if (j > 0) {
                int k = base.lastIndexOf("/");
                if (k != -1) {
                    base = base.substring(0, k);
                    relativePath = relativePath + "../";
                } else {
                    if (base.equals("")) break;
                    base = "";
                    relativePath = relativePath + "../";
                }
            }
            if (base.equals("") || !absolutePath.startsWith(base)) continue;
            String path = absolutePath.substring(base.length());
            int k = path.indexOf("/");
            if (k == 0) {
                path = path.substring(1);
            }
            relativePath = relativePath + path;
            return relativePath;
        }
        return absolutePath;
    }

    public static String getRelativePath(String absolutePath) {
        return XML.getPathRelativeTo(absolutePath, XML.getUserDirectory());
    }

    public static String getUserDirectory() {
        String userDir = System.getProperty("user.dir", ".");
        return userDir;
    }

    public static String getDirectoryPath(String fileName) {
        if (fileName == null) {
            return "";
        }
        int slash = (fileName = XML.forwardSlash(fileName)).lastIndexOf("/");
        if (slash != -1) {
            return fileName.substring(0, slash);
        }
        return "";
    }

    public static String getResolvedPath(String relativePath, String base) {
        if ((relativePath = XML.forwardSlash(relativePath)).startsWith("/") || relativePath.indexOf(":/") != -1) {
            return relativePath;
        }
        base = XML.forwardSlash(base);
        while (relativePath.startsWith("../") && !base.equals("")) {
            if (base.indexOf("/") == -1) {
                base = "/" + base;
            }
            relativePath = relativePath.substring(3);
            base = base.substring(0, base.lastIndexOf("/"));
        }
        if (base.equals("")) {
            return relativePath;
        }
        if (base.endsWith("/")) {
            return base + relativePath;
        }
        return base + "/" + relativePath;
    }

    public static void createFolders(String path) {
        File dir = new File(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (!dir.exists()) {
            dirs.add(0, dir);
            int j = path.lastIndexOf("/");
            if (j == -1) break;
            path = path.substring(0, j);
            dir = new File(path);
        }
        Iterator it = ((AbstractList)dirs).iterator();
        while (it.hasNext()) {
            dir = (File)it.next();
            dir.mkdir();
        }
    }

    static {
        defaultName = "osp10.dtd";
        try {
            NEW_LINE = System.getProperty("line.separator", "/n");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        XML.setLoader(class$java$awt$Color == null ? (class$java$awt$Color = XML.class$("java.awt.Color")) : class$java$awt$Color, new ObjectLoader(){

            public void saveObject(XMLControl control, Object obj) {
                Color color = (Color)obj;
                control.setValue("red", color.getRed());
                control.setValue("green", color.getGreen());
                control.setValue("blue", color.getBlue());
                control.setValue("alpha", color.getAlpha());
            }

            public Object createObject(XMLControl control) {
                int r = control.getInt("red");
                int g = control.getInt("green");
                int b = control.getInt("blue");
                int a = control.getInt("alpha");
                return new Color(r, g, b, a);
            }

            public Object loadObject(XMLControl control, Object obj) {
                int r = control.getInt("red");
                int g = control.getInt("green");
                int b = control.getInt("blue");
                int a = control.getInt("alpha");
                return new Color(r, g, b, a);
            }
        });
        XML.setLoader(class$java$lang$Double == null ? (class$java$lang$Double = XML.class$("java.lang.Double")) : class$java$lang$Double, new ObjectLoader(){

            public void saveObject(XMLControl control, Object obj) {
                Double dbl = (Double)obj;
                control.setValue("value", dbl);
            }

            public Object createObject(XMLControl control) {
                double val = control.getDouble("value");
                return new Double(val);
            }

            public Object loadObject(XMLControl control, Object obj) {
                Double dbl = (Double)obj;
                double val = control.getDouble("value");
                if (dbl == val) {
                    return dbl;
                }
                return new Double(val);
            }
        });
        XML.setLoader(class$java$lang$Integer == null ? (class$java$lang$Integer = XML.class$("java.lang.Integer")) : class$java$lang$Integer, new ObjectLoader(){

            public void saveObject(XMLControl control, Object obj) {
                Integer i = (Integer)obj;
                control.setValue("value", i);
            }

            public Object createObject(XMLControl control) {
                int val = control.getInt("value");
                return new Integer(val);
            }

            public Object loadObject(XMLControl control, Object obj) {
                Integer i = (Integer)obj;
                int val = control.getInt("value");
                if (i == val) {
                    return i;
                }
                return new Integer(val);
            }
        });
        XML.setLoader(class$java$lang$Boolean == null ? (class$java$lang$Boolean = XML.class$("java.lang.Boolean")) : class$java$lang$Boolean, new ObjectLoader(){

            public void saveObject(XMLControl control, Object obj) {
                Boolean bool = (Boolean)obj;
                control.setValue("value", bool);
            }

            public Object createObject(XMLControl control) {
                boolean val = control.getBoolean("value");
                return new Boolean(val);
            }

            public Object loadObject(XMLControl control, Object obj) {
                Boolean bool = (Boolean)obj;
                boolean val = control.getBoolean("value");
                if (bool == val) {
                    return bool;
                }
                return new Boolean(val);
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface ObjectLoader {
        public void saveObject(XMLControl var1, Object var2);

        public Object createObject(XMLControl var1);

        public Object loadObject(XMLControl var1, Object var2);
    }
}

