/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;

public class XMLPropertyElement
implements XMLProperty {
    protected XMLProperty parent;
    protected String name;
    protected String type;
    protected String className;
    protected List content;
    static /* synthetic */ Class class$java$lang$String;

    public XMLPropertyElement(XMLProperty mother) {
        this.content = new ArrayList();
        this.parent = mother;
    }

    public XMLPropertyElement(XMLProperty mother, String propertyName, String propertyType, Object value) {
        block8: {
            boolean primitive;
            int count;
            block11: {
                block10: {
                    block9: {
                        block7: {
                            this(mother);
                            this.name = propertyName;
                            this.type = propertyType;
                            if (!this.type.equals("string")) break block7;
                            if (XML.requiresCDATA((String)value)) {
                                this.content.add("<![CDATA[" + value + "]]>");
                            } else {
                                this.content.add(value.toString());
                            }
                            break block8;
                        }
                        if ("intdoubleboolean".indexOf(this.type) == -1) break block9;
                        this.content.add(value.toString());
                        break block8;
                    }
                    if (!this.type.equals("object")) break block10;
                    this.className = value.getClass().getName();
                    XMLControlElement control = new XMLControlElement(this);
                    control.saveObject(value);
                    this.content.add(control);
                    break block8;
                }
                if (!this.type.equals("collection")) break block11;
                this.className = value.getClass().getName();
                Iterator it = ((Collection)value).iterator();
                int i = 0;
                while (it.hasNext()) {
                    Object next = it.next();
                    String type = XML.getDataType(next);
                    if (type == null) continue;
                    this.content.add(new XMLPropertyElement(this, "item", type, next));
                    ++i;
                }
                break block8;
            }
            if (!this.type.equals("array")) break block8;
            this.className = value.getClass().getName();
            Class<?> baseType = value.getClass().getComponentType();
            Object array = value;
            for (count = Array.getLength(array); count > 0 && baseType.getComponentType() != null; count *= Array.getLength(array)) {
                baseType = baseType.getComponentType();
                if ((array = Array.get(array, 0)) == null) break;
            }
            boolean bl = primitive = "intdoubleboolean".indexOf(baseType.getName()) != -1;
            if (primitive && count > XMLControlElement.compactArraySize) {
                String s = this.getArrayString(value);
                this.content.add(new XMLPropertyElement(this, "array", "string", s));
            } else {
                int length = Array.getLength(value);
                for (int j = 0; j < length; ++j) {
                    Object next = Array.get(value, j);
                    String type = XML.getDataType(next);
                    if (type == null) continue;
                    this.content.add(new XMLPropertyElement(this, "[" + j + "]", type, next));
                }
            }
        }
    }

    public String getPropertyName() {
        return this.name;
    }

    public String getPropertyType() {
        return this.type;
    }

    public Class getPropertyClass() {
        if (this.type.equals("int")) {
            return Integer.TYPE;
        }
        if (this.type.equals("double")) {
            return Double.TYPE;
        }
        if (this.type.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (this.type.equals("string")) {
            return class$java$lang$String == null ? (class$java$lang$String = XMLPropertyElement.class$("java.lang.String")) : class$java$lang$String;
        }
        try {
            return Class.forName(this.className);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public XMLProperty getParentProperty() {
        return this.parent;
    }

    public int getLevel() {
        return this.parent.getLevel() + 1;
    }

    public List getPropertyContent() {
        return this.content;
    }

    public XMLControl getChildControl(String name) {
        XMLControl[] children = this.getChildControls();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].getPropertyName().equals(name)) continue;
            return children[i];
        }
        return null;
    }

    public XMLControl[] getChildControls() {
        if (this.type.equals("object")) {
            XMLControl child = (XMLControl)this.getPropertyContent().get(0);
            return new XMLControl[]{child};
        }
        if ("arraycollection".indexOf(this.type) != -1) {
            ArrayList list = new ArrayList();
            Iterator it = this.getPropertyContent().iterator();
            while (it.hasNext()) {
                XMLProperty prop = (XMLProperty)it.next();
                if (!prop.getPropertyType().equals("object")) continue;
                list.add(prop.getPropertyContent().get(0));
            }
            return list.toArray(new XMLControl[0]);
        }
        return new XMLControl[0];
    }

    public void setValue(String stringValue) {
        boolean valid = true;
        try {
            if (this.type.equals("int")) {
                Integer.parseInt(stringValue);
            } else if (this.type.equals("double")) {
                Double.parseDouble(stringValue);
            } else if (this.type.equals("boolean")) {
                stringValue = stringValue.equals("true") ? "true" : "false";
            } else if ("objectarraycollection".indexOf(this.type) != -1) {
                valid = false;
            } else if (this.type.equals("string") && XML.requiresCDATA(stringValue)) {
                stringValue = "<![CDATA[" + stringValue + "]]>";
            }
        }
        catch (NumberFormatException ex) {
            valid = false;
        }
        if (valid) {
            this.content.clear();
            this.content.add(stringValue);
        }
    }

    public String toString() {
        List content;
        StringBuffer xml = new StringBuffer(XML.NEW_LINE + this.indent(this.getLevel()) + "<property name=\"" + this.name + "\" type=\"" + this.type + "\"");
        if ("arraycollection".indexOf(this.type) != -1) {
            xml.append(" class=\"" + this.className + "\"");
        }
        if ((content = this.getPropertyContent()).isEmpty()) {
            xml.append("/>");
            return xml.toString();
        }
        xml.append(">");
        boolean hasChildren = false;
        Iterator it = content.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            hasChildren = hasChildren || next instanceof XMLProperty;
            xml.append(next);
        }
        if (hasChildren) {
            xml.append(XML.NEW_LINE + this.indent(this.getLevel()));
        }
        xml.append("</property>");
        return xml.toString();
    }

    protected String indent(int level) {
        String space = "";
        for (int i = 0; i < 4 * level; ++i) {
            space = space + " ";
        }
        return space;
    }

    protected String getArrayString(Object array) {
        StringBuffer sb = new StringBuffer("{");
        int length = Array.getLength(array);
        for (int j = 0; j < length; ++j) {
            Object element;
            if (j > 0) {
                sb.append(',');
            }
            if ((element = Array.get(array, j)) != null && element.getClass().isArray()) {
                sb.append(this.getArrayString(element));
                continue;
            }
            sb.append(element);
        }
        sb.append('}');
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

