/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLTree;

public class XMLTreeChooser
extends JDialog {
    private JPanel scrollPane;
    private XMLTree tree;
    private JLabel textLabel;
    private boolean applyChanges = false;

    public XMLTreeChooser(String title, String text) {
        this(title, text, null);
    }

    public XMLTreeChooser(String title, String text, Component comp) {
        super(JOptionPane.getFrameForComponent(comp), true);
        this.setTitle(title);
        this.textLabel = new JLabel(" " + text);
        this.textLabel.setHorizontalTextPosition(2);
        JButton cancelButton = new JButton("Cancel");
        JButton okButton = new JButton("OK");
        JButton selectAllButton = new JButton("Select_All");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((Component)XMLTreeChooser.this).setVisible(false);
            }
        });
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XMLTreeChooser.this.applyChanges = true;
                ((Component)XMLTreeChooser.this).setVisible(false);
            }
        });
        selectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XMLTreeChooser.this.tree.selectHighlightedProperties();
            }
        });
        this.getRootPane().setDefaultButton(okButton);
        JPanel headerPane = new JPanel();
        headerPane.setLayout(new BoxLayout(headerPane, 0));
        headerPane.add(this.textLabel);
        headerPane.add(Box.createHorizontalGlue());
        headerPane.add(selectAllButton);
        headerPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.scrollPane = new JPanel(new BorderLayout());
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(cancelButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(okButton);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setPreferredSize(new Dimension(340, 340));
        this.setContentPane(contentPane);
        contentPane.add((Component)headerPane, "North");
        contentPane.add((Component)this.scrollPane, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        ((Component)this).setLocation(x, y);
    }

    public List choose(XMLControl control, Class type) {
        ArrayList<XMLProperty> list = new ArrayList<XMLProperty>();
        this.tree = new XMLTree(control);
        this.tree.setHighlightedClass(type);
        this.tree.selectHighlightedProperties();
        this.textLabel.setIcon(XMLTree.hiliteIcon);
        this.scrollPane.removeAll();
        this.scrollPane.add((Component)this.tree.getScrollPane(), "Center");
        this.validate();
        this.applyChanges = false;
        ((Component)this).setVisible(true);
        if (this.applyChanges) {
            List props = this.tree.getSelectedProperties();
            Iterator it = props.iterator();
            while (it.hasNext()) {
                XMLProperty prop = (XMLProperty)it.next();
                Class propClass = prop.getPropertyClass();
                if (propClass == null || !type.isAssignableFrom(propClass)) continue;
                list.add(prop);
            }
        }
        return list;
    }
}

