/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.davidson.applets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JApplet;
import javax.swing.JFrame;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.display.TextFrame;

public class FrameApplet
extends JApplet
implements Renderable {
    JFrame mainFrame = null;
    String targetClassName;
    String contentName;
    ArrayList newFrames = new ArrayList();
    ArrayList existingFrames = new ArrayList();
    Class target;
    String[] args = null;
    Renderable renderPanel;
    boolean singleFrame = true;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$opensourcephysics$display$Renderable;

    public String getParameter(String key, String def) {
        return this.getParameter(key) != null ? this.getParameter(key) : def;
    }

    public void init() {
        String xmldata;
        super.init();
        OSPFrame.applet = this;
        OSPFrame.appletMode = true;
        if (this.getParameter("showLog", "false").toLowerCase().trim().equals("true")) {
            OSPLog.showLog();
        }
        if ((xmldata = this.getParameter("xmldata", null)) != null) {
            this.args = new String[1];
            this.args[0] = xmldata;
        }
        this.targetClassName = this.getParameter("target", null);
        if (this.targetClassName == null) {
            this.targetClassName = this.getParameter("app", null);
        }
        this.contentName = this.getParameter("content", null);
        this.singleFrame = !this.getParameter("singleframe", "true").trim().equalsIgnoreCase("false");
    }

    public void start() {
        int i;
        int n;
        if (this.mainFrame != null) {
            return;
        }
        this.createTarget();
        if (this.contentName != null) {
            Frame[] frame = Frame.getFrames();
            n = frame.length;
            for (i = 0; i < n; ++i) {
                if (!(frame[i] instanceof JFrame) || !frame[i].getName().equalsIgnoreCase(this.contentName)) continue;
                this.mainFrame = (JFrame)frame[i];
                break;
            }
        }
        if (this.mainFrame == null) {
            System.out.println("Main frame not found.");
            return;
        }
        this.removeWindowListeners(this.mainFrame);
        ((Component)this.mainFrame).setVisible(false);
        if (!this.mainFrame.isActive()) {
            this.mainFrame.dispose();
        }
        Container content = this.mainFrame.getContentPane();
        if (this.mainFrame instanceof OSPFrame && ((OSPFrame)this.mainFrame).isAnimated()) {
            this.renderPanel = (Renderable)((Object)GUIUtils.findInstance(content, class$org$opensourcephysics$display$Renderable == null ? (class$org$opensourcephysics$display$Renderable = FrameApplet.class$("org.opensourcephysics.display.Renderable")) : class$org$opensourcephysics$display$Renderable));
        }
        this.getRootPane().setContentPane(content);
        this.getRootPane().requestFocus();
        if (!this.singleFrame) {
            OSPFrame.appletMode = false;
            n = this.newFrames.size();
            for (i = 0; i < n; ++i) {
                if (!(this.newFrames.get(i) instanceof OSPFrame)) continue;
                ((OSPFrame)this.newFrames.get(i)).setKeepHidden(false);
            }
            GUIUtils.showDrawingAndTableFrames();
        }
    }

    private void removeWindowListeners(Window frame) {
        WindowListener[] wl = frame.getWindowListeners();
        int n = wl.length;
        for (int i = 0; i < n; ++i) {
            this.mainFrame.removeWindowListener(wl[i]);
        }
    }

    public BufferedImage render() {
        if (this.renderPanel != null) {
            return this.renderPanel.render();
        }
        return null;
    }

    public Image render(Image image) {
        if (this.renderPanel != null) {
            this.renderPanel.render(image);
        }
        return image;
    }

    static boolean isLaunchable(Class type) {
        if (type == null) {
            return false;
        }
        try {
            type.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = FrameApplet.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            return true;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    public void destroy() {
        this.disposeOwnedFrames();
        this.target = null;
        this.mainFrame = null;
        super.destroy();
    }

    private Class createTarget() {
        Class<?> type = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            type = classLoader.loadClass(this.targetClassName);
        }
        catch (ClassNotFoundException ex1) {
            System.err.println("Class not found: " + this.targetClassName);
            return null;
        }
        if (!FrameApplet.isLaunchable(type)) {
            System.err.println("Main method not found in " + this.targetClassName);
            return null;
        }
        Frame[] frame = Frame.getFrames();
        this.existingFrames.clear();
        int n = frame.length;
        for (int i = 0; i < n; ++i) {
            this.existingFrames.add(frame[i]);
        }
        String htmldata = this.getParameter("htmldata", null);
        if (htmldata != null) {
            TextFrame htmlframe = new TextFrame(htmldata, type);
            ((Component)htmlframe).setVisible(true);
        }
        try {
            Method m = type.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = FrameApplet.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            m.invoke(type, new Object[]{this.args});
            frame = Frame.getFrames();
            int n2 = frame.length;
            for (int i = 0; i < n2; ++i) {
                if (frame[i] instanceof JFrame && ((JFrame)frame[i]).getDefaultCloseOperation() == 3) {
                    ((JFrame)frame[i]).setDefaultCloseOperation(1);
                    if (this.mainFrame == null) {
                        this.mainFrame = (JFrame)frame[i];
                    }
                }
                if (this.existingFrames.contains(frame[i])) continue;
                this.newFrames.add(frame[i]);
            }
        }
        catch (NoSuchMethodException ex) {
            System.err.println(ex);
        }
        catch (InvocationTargetException ex) {
            System.err.println(ex);
        }
        catch (IllegalAccessException ex) {
            System.err.println(ex);
        }
        if (this.newFrames.size() > 0 && this.mainFrame == null && this.newFrames.get(0) instanceof JFrame) {
            this.mainFrame = (JFrame)this.newFrames.get(0);
        }
        return type;
    }

    private void disposeOwnedFrames() {
        Frame[] frame = Frame.getFrames();
        int n = frame.length;
        for (int i = 0; i < n; ++i) {
            if (frame[i] instanceof JFrame && ((JFrame)frame[i]).getDefaultCloseOperation() == 3) {
                ((JFrame)frame[i]).setDefaultCloseOperation(2);
            }
            if (this.existingFrames.contains(frame[i])) continue;
            ((Component)frame[i]).setVisible(false);
            this.removeWindowListeners(frame[i]);
            frame[i].dispose();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

