/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.table.AbstractTableModel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;

public class Histogram
extends AbstractTableModel
implements Measurable {
    public static final short DRAW_POINT = 0;
    public static final short DRAW_BIN = 1;
    public boolean logScale = false;
    public boolean adjustForWidth = false;
    protected Color binColor = Color.red;
    protected short binStyle = 1;
    HashMap bins;
    double binWidth = 1.0;
    double binOffset = 0.0;
    boolean discrete = true;
    double xmin;
    double xmax;
    final int YMIN = 0;
    double ymax;
    String binColumnName = "bin number";
    String xColumnName = "x";
    String yColumnName = "occurences";
    Map.Entry[] entries = new Map.Entry[0];
    boolean dataChanged;
    double sum;
    boolean normalizedToOne = false;
    double barOffset;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;

    public Histogram() {
        this.clear();
    }

    public void read(String inputPathName) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(inputPathName));
        String s = null;
        while ((s = reader.readLine()) != null) {
            if ((s = s.trim()).equals("") || s.charAt(0) == '#') continue;
            try {
                StringTokenizer st = new StringTokenizer(s, "\t");
                int binNumber = Integer.parseInt(st.nextToken());
                double numberOfOccurences = Double.parseDouble(st.nextToken());
                Double priorOccurences = (Double)this.bins.get(new Integer(binNumber));
                if (priorOccurences == null) {
                    this.bins.put(new Integer(binNumber), new Double(numberOfOccurences));
                } else {
                    this.bins.put(new Integer(binNumber), new Double(numberOfOccurences += priorOccurences.doubleValue()));
                }
                this.ymax = Math.max(numberOfOccurences, this.ymax);
                this.xmin = Math.min((double)binNumber * this.binWidth + this.binOffset, this.xmin);
                this.xmax = Math.max((double)binNumber * this.binWidth + this.binWidth + this.binOffset, this.xmax);
            }
            catch (NoSuchElementException nsee) {
                nsee.printStackTrace();
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        this.dataChanged = true;
    }

    public String toSortedString() {
        Set keySet = this.bins.keySet();
        Object[] keys = keySet.toArray();
        Arrays.sort(keys);
        String s = "x\tx";
        StringBuffer buf = new StringBuffer(s.length() * keys.length);
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            buf.append(key);
            buf.append("\t");
            buf.append(this.bins.get(keys[i]));
            buf.append("\n");
        }
        return buf.toString();
    }

    public String toString() {
        Set set = this.bins.keySet();
        Iterator keys = set.iterator();
        String s = "x\tx";
        StringBuffer buf = new StringBuffer(s.length() * set.size());
        while (keys.hasNext()) {
            Integer binNumber = (Integer)keys.next();
            Double occurences = (Double)this.bins.get(binNumber);
            buf.append(binNumber);
            buf.append("\t");
            buf.append(occurences);
            buf.append("\n");
        }
        return buf.toString();
    }

    public int hashCode(double value) {
        return (int)Math.floor((value - this.binOffset) / this.binWidth);
    }

    public synchronized void append(double value, double numberOfOccurences) {
        this.sum += numberOfOccurences;
        int binNumber = this.hashCode(value);
        Double occurences = (Double)this.bins.get(new Integer(binNumber));
        if (occurences == null) {
            this.bins.put(new Integer(binNumber), new Double(numberOfOccurences));
        } else {
            this.bins.put(new Integer(binNumber), new Double(numberOfOccurences += occurences.doubleValue()));
        }
        this.ymax = Math.max(numberOfOccurences, this.ymax);
        this.xmin = Math.min((double)binNumber * this.binWidth + this.binOffset, this.xmin);
        this.xmax = Math.max((double)binNumber * this.binWidth + this.binWidth + this.binOffset, this.xmax);
        this.dataChanged = true;
    }

    public void append(double value) {
        this.append(value, 1.0);
    }

    public void append(String inputPathName) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(inputPathName));
        String s = null;
        while ((s = br.readLine()) != null) {
            if ((s = s.trim()).equals("") || s.charAt(0) == '#') continue;
            try {
                double d = Double.parseDouble(s);
                this.append(d, 1.0);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
    }

    public void append(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.append(values[i], 1.0);
        }
    }

    public synchronized void draw(DrawingPanel drawingPanel, Graphics g) {
        if (this.bins.size() == 0) {
            return;
        }
        Shape oldClip = g.getClip();
        g.setColor(this.binColor);
        g.clipRect(0, 0, drawingPanel.getWidth(), drawingPanel.getHeight());
        Iterator keys = this.bins.keySet().iterator();
        while (keys.hasNext()) {
            Integer binNumber = (Integer)keys.next();
            Double d = (Double)this.bins.get(binNumber);
            if (d == null) {
                return;
            }
            double occurences = d;
            if (this.normalizedToOne) {
                occurences /= this.sum;
            }
            if (this.binStyle == 1) {
                this.drawBin(drawingPanel, g, binNumber, occurences);
                continue;
            }
            this.drawPoint(drawingPanel, g, binNumber, occurences);
        }
        g.setClip(oldClip);
    }

    public synchronized void clear() {
        this.bins = new HashMap();
        this.xmin = 2.147483647E9;
        this.xmax = -2.147483648E9;
        this.ymax = -2.147483648E9;
        this.sum = 0.0;
        this.dataChanged = true;
    }

    public Map.Entry[] entries() {
        this.updateEntries();
        return this.entries;
    }

    public void setBinStyle(short style) {
        this.binStyle = style;
    }

    public void setDiscrete(boolean _discrete) {
        this.discrete = _discrete;
    }

    public void setBinOffset(double _binOffset) {
        this.binOffset = _binOffset;
    }

    public void setBarOffset(double _barOffset) {
        this.barOffset = _barOffset;
    }

    public void setBinColor(Color _binColor) {
        this.binColor = _binColor;
    }

    public void setBinWidth(double _binWidth) {
        this.binWidth = _binWidth;
    }

    public void setXYColumnNames(String _binColumnName, String _yColumnName) {
        this.binColumnName = _binColumnName;
        this.yColumnName = _yColumnName;
    }

    public void setNormalizedToOne(boolean b) {
        this.normalizedToOne = b;
    }

    public double getBinWidth() {
        return this.binWidth;
    }

    public double getBinOffset() {
        return this.binOffset;
    }

    public double getXMin() {
        return this.discrete && this.bins.size() > 1 ? this.xmin - this.binWidth : this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMin() {
        return 0.0;
    }

    public double getYMax() {
        double max;
        double d = max = this.normalizedToOne ? this.ymax / this.sum : this.ymax;
        if (this.adjustForWidth) {
            max /= this.getBinWidth();
        }
        if (this.logScale) {
            max = Math.log(max);
        }
        return max;
    }

    public boolean isMeasured() {
        return this.bins.size() > 0;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return this.binColumnName;
        }
        if (column == 1) {
            return this.xColumnName;
        }
        return this.yColumnName;
    }

    public int getRowCount() {
        return this.bins.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public Object getValueAt(int row, int column) {
        this.updateEntries();
        Map.Entry entry = this.entries[row];
        if (column == 0) {
            return entry.getKey();
        }
        if (column == 1) {
            return new Double(((Integer)entry.getKey()).doubleValue() * this.binWidth + this.binWidth / 2.0 + this.binOffset);
        }
        if (this.normalizedToOne) {
            Double d = (Double)entry.getValue();
            return new Double(d / this.sum);
        }
        return entry.getValue();
    }

    public Class getColumnClass(int columnIndex) {
        Class clazz = columnIndex == 0 ? (class$java$lang$Integer == null ? (class$java$lang$Integer = Histogram.class$("java.lang.Integer")) : class$java$lang$Integer) : (class$java$lang$Double == null ? (class$java$lang$Double = Histogram.class$("java.lang.Double")) : class$java$lang$Double);
        return clazz;
    }

    protected void drawPoint(DrawingPanel drawingPanel, Graphics g, int binNumber, double occurences) {
        int px = drawingPanel.xToPix(this.getLeftMostBinPosition(binNumber));
        int py = drawingPanel.yToPix(occurences);
        int pointRadius = 2;
        if (this.discrete) {
            g.fillRect(px - pointRadius, py - pointRadius, pointRadius * 2, pointRadius * 2);
        } else {
            int px2 = drawingPanel.xToPix(this.getRightMostBinPosition(binNumber));
            int pWidth = px2 - px;
            g.fillRect(px, py, pWidth, pointRadius * 2);
        }
    }

    protected void drawBin(DrawingPanel drawingPanel, Graphics g, int binNumber, double occurences) {
        if (this.adjustForWidth) {
            occurences /= this.getBinWidth();
        }
        if (this.logScale) {
            occurences = Math.max(0.0, Math.log(occurences));
        }
        int binlx = drawingPanel.xToPix(this.getLeftMostBinPosition(binNumber));
        if (this.discrete) {
            g.drawLine(binlx, drawingPanel.yToPix(0.0), binlx, drawingPanel.yToPix(occurences));
        } else {
            int binrx = drawingPanel.xToPix(this.getRightMostBinPosition(binNumber));
            int pWidth = binrx - binlx;
            double pHeight = drawingPanel.getYPixPerUnit() * occurences;
            Rectangle2D.Double rect = new Rectangle2D.Double(binlx, drawingPanel.yToPix(occurences), pWidth, pHeight);
            Graphics2D g2 = (Graphics2D)g;
            g2.fill(rect);
        }
    }

    public double[] getXPoints() {
        int nbins = 1 + (int)((this.xmax - this.xmin) / this.binWidth);
        if (nbins < 1) {
            return new double[0];
        }
        double[] xdata = new double[nbins];
        for (int i = 0; i < nbins; ++i) {
            xdata[i] = this.xmin + (double)i * this.binWidth + this.binOffset + this.binWidth / 2.0;
        }
        return xdata;
    }

    public double[] getYPoints() {
        int nbins = 1 + (int)((this.xmax - this.xmin) / this.binWidth);
        if (nbins < 1) {
            return new double[0];
        }
        double[] ydata = new double[nbins];
        for (int i = 0; i < nbins; ++i) {
            Integer binNumber = new Integer(i);
            Double bin = (Double)this.bins.get(binNumber);
            ydata[i] = bin == null ? 0.0 : bin;
        }
        return ydata;
    }

    public double[][] getPoints() {
        int nbins = 1 + (int)((this.xmax - this.xmin) / this.binWidth);
        if (nbins < 1) {
            return new double[2][0];
        }
        double[][] data = new double[2][nbins];
        int iStart = (int)(this.xmin / this.binWidth);
        for (int i = 0; i < nbins; ++i) {
            Integer binNumber = new Integer(i + iStart);
            Double bin = (Double)this.bins.get(binNumber);
            data[0][i] = this.xmin + (double)i * this.binWidth + this.binOffset + this.binWidth / 2.0;
            data[1][i] = bin == null ? 0.0 : bin;
        }
        return data;
    }

    public double[][] getLogPoints() {
        int nbins = (int)Math.round((this.xmax - this.xmin) / this.binWidth);
        if (nbins < 1) {
            return new double[2][0];
        }
        double[][] data = new double[2][nbins];
        int iStart = (int)(this.xmin / this.binWidth);
        for (int i = 0; i < nbins; ++i) {
            Integer binNumber = new Integer(i + iStart);
            Double bin = (Double)this.bins.get(binNumber);
            data[0][i] = this.xmin + (double)i * this.binWidth + this.binOffset + this.binWidth / 2.0;
            data[1][i] = bin == null ? 0.0 : bin;
            data[1][i] = data[1][i] > 0.0 ? Math.log(data[1][i]) : 0.0;
        }
        return data;
    }

    public double getLeftMostBinPosition(int binNumber) {
        return (double)binNumber * this.binWidth + this.binOffset + this.binWidth * this.barOffset;
    }

    public double getRightMostBinPosition(int binNumber) {
        return (double)binNumber * this.binWidth + this.binWidth + this.binOffset + this.binWidth * this.barOffset;
    }

    private synchronized void updateEntries() {
        if (this.dataChanged) {
            this.entries = this.bins.entrySet().toArray(this.entries);
            this.dataChanged = false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

