/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.CircleLoader;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.MeasuredCircle;

public class InteractiveCircle
extends MeasuredCircle
implements Interactive {
    boolean enableInteraction = true;

    public InteractiveCircle(double x, double y) {
        super(x, y);
    }

    public InteractiveCircle() {
        this(0.0, 0.0);
    }

    public void setEnabled(boolean _enableInteraction) {
        this.enableInteraction = _enableInteraction;
    }

    public boolean isEnabled() {
        return this.enableInteraction;
    }

    public boolean isInside(DrawingPanel panel, int xpix, int ypix) {
        return this.findInteractive(panel, xpix, ypix) != null;
    }

    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (!this.enableInteraction) {
            return null;
        }
        int xcpix = panel.xToPix(this.x);
        int ycpix = panel.yToPix(this.y);
        if (Math.abs(xcpix - xpix) <= this.pixRadius && Math.abs(ycpix - ypix) <= this.pixRadius) {
            return this;
        }
        return null;
    }

    public static XML.ObjectLoader getLoader() {
        return new InteractiveCircleLoader();
    }

    protected static class InteractiveCircleLoader
    extends CircleLoader {
        protected InteractiveCircleLoader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            super.saveObject(control, obj);
            InteractiveCircle circle = (InteractiveCircle)obj;
            control.setValue("interaction enabled", circle.enableInteraction);
            control.setValue("measure enabled", circle.enableInteraction);
        }

        public Object createObject(XMLControl control) {
            return new InteractiveCircle();
        }

        public Object loadObject(XMLControl control, Object obj) {
            super.loadObject(control, obj);
            InteractiveCircle circle = (InteractiveCircle)obj;
            circle.enableInteraction = control.getBoolean("interaction enabled");
            circle.enableMeasure = control.getBoolean("measure enabled");
            return obj;
        }
    }
}

