/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.MouseController;
import org.opensourcephysics.display.Selectable;

public class InteractivePanel
extends DrawingPanel
implements InteractiveMouseHandler {
    public static final int MOUSE_PRESSED = 1;
    public static final int MOUSE_RELEASED = 2;
    public static final int MOUSE_DRAGGED = 3;
    public static final int MOUSE_CLICKED = 4;
    public static final int MOUSE_ENTERED = 5;
    public static final int MOUSE_EXITED = 6;
    public static final int MOUSE_MOVED = 7;
    protected boolean containsInteractive = false;
    protected int mouseAction = 0;
    protected MouseEvent mouseEvent = null;
    protected InteractiveMouseHandler interactive = null;
    private Interactive iaDragable = null;
    private Selectable iaSelectable = null;

    public InteractivePanel(InteractiveMouseHandler in) {
        this();
        this.interactive = in;
    }

    public InteractivePanel() {
        this.removeMouseListener(this.mouseController);
        this.removeMouseMotionListener(this.mouseController);
        this.mouseController = new IADMouseController();
        this.addMouseListener(this.mouseController);
        this.addMouseMotionListener(this.mouseController);
        this.interactive = this;
    }

    public synchronized void addDrawable(Drawable drawable) {
        super.addDrawable(drawable);
        if (drawable instanceof Interactive) {
            this.containsInteractive = true;
        }
    }

    public synchronized void clear() {
        super.clear();
        this.containsInteractive = false;
    }

    public void setInteractiveMouseHandler(InteractiveMouseHandler handler) {
        this.interactive = handler;
    }

    public void handleMouseAction(InteractivePanel panel, MouseEvent evt) {
        switch (panel.getMouseAction()) {
            case 4: {
                Interactive clickedIA = this.getInteractive();
                if (panel.getMouseClickCount() < 2 || clickedIA == null || !(clickedIA instanceof Selectable)) {
                    return;
                }
                if (this.iaSelectable != null && this.iaSelectable != clickedIA) {
                    this.iaSelectable.setSelected(false);
                }
                this.iaSelectable = (Selectable)clickedIA;
                this.iaSelectable.toggleSelected();
                this.validImage = false;
                if (this.getIgnoreRepaint()) break;
                panel.repaint();
                break;
            }
            case 3: {
                if (this.iaDragable == null) {
                    return;
                }
                double x = panel.getMouseX();
                double y = panel.getMouseY();
                if (evt.getX() < 1 + this.leftGutter) {
                    x = panel.pixToX(1 + this.leftGutter);
                }
                if (evt.getX() > panel.getWidth() - 1 - this.rightGutter) {
                    x = panel.pixToX(panel.getWidth() - 1 - this.rightGutter);
                }
                if (evt.getY() < 1 + this.topGutter) {
                    y = panel.pixToY(1 + this.topGutter);
                }
                if (evt.getY() > panel.getHeight() - 1 - this.bottomGutter) {
                    y = panel.pixToY(panel.getHeight() - 1 - this.bottomGutter);
                }
                this.iaDragable.setXY(x, y);
                this.validImage = false;
                if (this.getIgnoreRepaint()) break;
                panel.repaint();
            }
        }
    }

    public Interactive getInteractive() {
        if (!this.containsInteractive) {
            return null;
        }
        if (this.iaDragable != null) {
            return this.iaDragable;
        }
        if (this.iaSelectable != null && this.iaSelectable.isSelected()) {
            Interactive iad = this.iaSelectable.findInteractive(this, this.mouseEvent.getX(), this.mouseEvent.getY());
            return iad;
        }
        Object[] array = this.drawableList.toArray();
        for (int i = array.length - 1; i >= 0; --i) {
            Interactive iad;
            Object obj = array[i];
            if (!(obj instanceof Interactive) || (iad = ((Interactive)obj).findInteractive(this, this.mouseEvent.getX(), this.mouseEvent.getY())) == null) continue;
            return iad;
        }
        return null;
    }

    public void setShowCoordinates(boolean show) {
        this.showCoordinates = show;
    }

    public int getMouseButton() {
        switch (this.mouseEvent.getModifiers()) {
            case 16: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return 0;
    }

    public int getMouseClickCount() {
        return this.mouseEvent.getClickCount();
    }

    public int getMouseAction() {
        return this.mouseAction;
    }

    public int getMouseIntX() {
        return this.mouseEvent.getX();
    }

    public int getMouseIntY() {
        return this.mouseEvent.getY();
    }

    public double getMouseX() {
        return this.pixToX(this.mouseEvent.getX());
    }

    public double getMouseY() {
        return this.pixToY(this.mouseEvent.getY());
    }

    public void saveMouseEvent(int type, MouseEvent evt) {
        this.mouseAction = type;
        this.mouseEvent = evt;
    }

    protected class IADMouseController
    extends MouseController {
        protected DecimalFormat scientificFormat = new DecimalFormat("0.###E0");
        protected DecimalFormat decimalFormat = new DecimalFormat("0.00");

        protected IADMouseController() {
        }

        public void mousePressed(MouseEvent e) {
            InteractivePanel.this.mouseEvent = e;
            InteractivePanel.this.mouseAction = 1;
            if (InteractivePanel.this.interactive != null) {
                InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, e);
                InteractivePanel.this.iaDragable = null;
                InteractivePanel.this.iaDragable = InteractivePanel.this.getInteractive();
                if (InteractivePanel.this.iaDragable != null) {
                    if (InteractivePanel.this.iaDragable instanceof Selectable) {
                        InteractivePanel.this.setMouseCursor(((Selectable)InteractivePanel.this.iaDragable).getPreferredCursor());
                    } else {
                        InteractivePanel.this.setMouseCursor(Cursor.getPredefinedCursor(12));
                    }
                }
            }
            if (InteractivePanel.this.showCoordinates) {
                String s = InteractivePanel.this.coordinateStrBuilder.getCoordinateString(InteractivePanel.this, e);
                InteractivePanel.this.blMessageBox.setText(s);
            }
        }

        public void mouseReleased(MouseEvent e) {
            InteractivePanel.this.mouseEvent = e;
            InteractivePanel.this.mouseAction = 2;
            if (InteractivePanel.this.interactive != null) {
                InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, e);
            }
            InteractivePanel.this.iaDragable = null;
            if (InteractivePanel.this.showCoordinates) {
                InteractivePanel.this.blMessageBox.setText(null);
            }
            InteractivePanel.this.setMouseCursor(Cursor.getPredefinedCursor(1));
        }

        public void mouseEntered(MouseEvent e) {
            if (InteractivePanel.this.showCoordinates) {
                InteractivePanel.this.setMouseCursor(Cursor.getPredefinedCursor(1));
            }
            InteractivePanel.this.mouseEvent = e;
            InteractivePanel.this.mouseAction = 5;
            if (InteractivePanel.this.interactive != null) {
                InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, e);
            }
        }

        public void mouseExited(MouseEvent e) {
            InteractivePanel.this.setMouseCursor(Cursor.getPredefinedCursor(0));
            InteractivePanel.this.mouseEvent = e;
            InteractivePanel.this.mouseAction = 6;
            if (InteractivePanel.this.interactive != null) {
                InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, e);
            }
        }

        public void mouseClicked(MouseEvent e) {
            InteractivePanel.this.mouseEvent = e;
            InteractivePanel.this.mouseAction = 4;
            if (InteractivePanel.this.interactive == null) {
                return;
            }
            InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, e);
        }

        public void mouseDragged(MouseEvent e) {
            InteractivePanel.this.mouseEvent = e;
            InteractivePanel.this.mouseAction = 3;
            if (InteractivePanel.this.interactive != null) {
                InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, e);
            }
            if (InteractivePanel.this.showCoordinates) {
                String s = InteractivePanel.this.coordinateStrBuilder.getCoordinateString(InteractivePanel.this, e);
                InteractivePanel.this.blMessageBox.setText(s);
            }
        }

        public void mouseMoved(MouseEvent e) {
            InteractivePanel.this.mouseEvent = e;
            InteractivePanel.this.mouseAction = 7;
            InteractivePanel.this.iaDragable = null;
            if (InteractivePanel.this.interactive != null) {
                InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, e);
                Interactive iad = InteractivePanel.this.getInteractive();
                if (iad == null) {
                    InteractivePanel.this.setMouseCursor(Cursor.getPredefinedCursor(1));
                } else if (iad instanceof Selectable) {
                    InteractivePanel.this.setMouseCursor(((Selectable)iad).getPreferredCursor());
                } else {
                    InteractivePanel.this.setMouseCursor(Cursor.getPredefinedCursor(12));
                }
            }
        }
    }
}

