/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class SortDecorator
implements TableModel,
TableModelListener {
    private TableModel realModel;
    private int[] indexes;

    public SortDecorator(TableModel model) {
        if (model == null) {
            throw new IllegalArgumentException("null models are not allowed");
        }
        this.realModel = model;
        this.realModel.addTableModelListener(this);
        this.allocate();
    }

    public Object getValueAt(int row, int column) {
        if (this.indexes.length <= row) {
            this.allocate();
        }
        return this.realModel.getValueAt(this.indexes[row], column);
    }

    public void setValueAt(Object aValue, int row, int column) {
        if (this.indexes.length <= row) {
            this.allocate();
        }
        this.realModel.setValueAt(aValue, this.indexes[row], column);
    }

    public void tableChanged(TableModelEvent e) {
        this.allocate();
    }

    public void sort(int column) {
        int rowCount = this.getRowCount();
        if (this.indexes.length <= rowCount) {
            this.allocate();
        }
        for (int i = 0; i < rowCount; ++i) {
            for (int j = i + 1; j < rowCount; ++j) {
                if (this.compare(this.indexes[i], this.indexes[j], column) >= 0) continue;
                this.swap(i, j);
            }
        }
    }

    public void swap(int i, int j) {
        int tmp = this.indexes[i];
        this.indexes[i] = this.indexes[j];
        this.indexes[j] = tmp;
    }

    public int compare(int i, int j, int column) {
        Object io = this.realModel.getValueAt(i, column);
        Object jo = this.realModel.getValueAt(j, column);
        if (io instanceof Integer) {
            int a = (Integer)io;
            int b = (Integer)jo;
            return b < a ? -1 : (b > a ? 1 : 0);
        }
        if (io instanceof Double) {
            double a = (Double)io;
            double b = (Double)jo;
            return b < a ? -1 : (b > a ? 1 : 0);
        }
        int c = jo.toString().compareTo(io.toString());
        return c < 0 ? -1 : (c > 0 ? 1 : 0);
    }

    private void allocate() {
        this.indexes = new int[this.getRowCount()];
        for (int i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = i;
        }
    }

    public int getRowCount() {
        return this.realModel.getRowCount();
    }

    public int getColumnCount() {
        return this.realModel.getColumnCount();
    }

    public String getColumnName(int columnIndex) {
        return this.realModel.getColumnName(columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        return this.realModel.getColumnClass(columnIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.realModel.isCellEditable(rowIndex, columnIndex);
    }

    public void addTableModelListener(TableModelListener l) {
        this.realModel.addTableModelListener(l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.realModel.removeTableModelListener(l);
    }
}

