/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;

public class Trail
implements Drawable,
Measurable {
    GeneralPath generalPath = new GeneralPath();
    int numpts = 0;
    boolean connected = true;
    public Color color = Color.black;
    boolean enableMeasure = false;
    double xmin = Double.MAX_VALUE;
    double xmax = -1.7976931348623157E308;
    double ymin = Double.MAX_VALUE;
    double ymax = -1.7976931348623157E308;

    public synchronized void addPoint(double x, double y) {
        if (!this.connected || this.numpts == 0) {
            this.generalPath.moveTo((float)x, (float)y);
        }
        this.generalPath.lineTo((float)x, (float)y);
        this.xmin = Math.min(this.xmin, x);
        this.xmax = Math.max(this.xmax, x);
        this.ymin = Math.min(this.ymin, y);
        this.ymax = Math.max(this.ymax, y);
        ++this.numpts;
    }

    public synchronized void moveToPoint(double x, double y) {
        this.generalPath.moveTo((float)x, (float)y);
        this.xmin = Math.min(this.xmin, x);
        this.xmax = Math.max(this.xmax, x);
        this.ymin = Math.min(this.ymin, y);
        this.ymax = Math.max(this.ymax, y);
        ++this.numpts;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void clear() {
        this.numpts = 0;
        this.xmin = Double.MAX_VALUE;
        this.xmax = -1.7976931348623157E308;
        this.ymin = Double.MAX_VALUE;
        this.ymax = -1.7976931348623157E308;
        this.generalPath.reset();
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (this.numpts == 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.color);
        Shape s = this.generalPath.createTransformedShape(panel.getPixelTransform());
        g2.draw(s);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public void setMeasured(boolean _enableMeasure) {
        this.enableMeasure = _enableMeasure;
    }

    public boolean isMeasured() {
        return this.enableMeasure && this.numpts > 0;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getYMax() {
        return this.ymax;
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            Trail trail = (Trail)obj;
            control.setValue("connected", trail.connected);
            control.setValue("color", trail.color);
            control.setValue("number of pts", trail.numpts);
            control.setValue("general path", trail.generalPath);
        }

        public Object createObject(XMLControl control) {
            return new Trail();
        }

        public Object loadObject(XMLControl control, Object obj) {
            Trail trail = (Trail)obj;
            trail.connected = control.getBoolean("connected");
            trail.color = (Color)control.getObject("color");
            trail.numpts = control.getInt("number of pts");
            trail.generalPath = (GeneralPath)control.getObject("general path");
            return obj;
        }
    }
}

