/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;

public class TrailBezier
implements Measurable {
    GeneralPath path = new GeneralPath();
    GeneralPath pathStart = new GeneralPath();
    GeneralPath pathEnd = new GeneralPath();
    float x0;
    float y0;
    float x1;
    float y1;
    float x2;
    float y2;
    float[] endPts = new float[4];
    float dxEstimate = 0.0f;
    float dyEstimate = 0.0f;
    float slack = 0.15f;
    float dx2;
    float dy2;
    int numpts = 0;
    public Color color = Color.black;
    boolean enableMeasure = false;
    double xmin = Double.MAX_VALUE;
    double xmax = -1.7976931348623157E308;
    double ymin = Double.MAX_VALUE;
    double ymax = -1.7976931348623157E308;
    boolean closed = false;

    public synchronized void addPoint(double x, double y) {
        if (this.closed) {
            throw new IllegalStateException("Cannot add points to a closed trail.");
        }
        this.xmin = Math.min(this.xmin, x);
        this.xmax = Math.max(this.xmax, x);
        this.ymin = Math.min(this.ymin, y);
        this.ymax = Math.max(this.ymax, y);
        if (this.numpts == 0) {
            this.pathStart.moveTo((float)x, (float)y);
            this.endPts[0] = this.x0 = (float)x;
            this.endPts[1] = this.y0 = (float)y;
        } else if (this.numpts == 1) {
            this.endPts[2] = this.x1 = (float)x;
            this.endPts[3] = this.y1 = (float)y;
            this.path.moveTo(this.x1, this.y1);
        } else if (this.numpts == 2) {
            this.x2 = (float)x;
            this.y2 = (float)y;
            this.dx2 = this.x2 - this.endPts[0];
            this.dy2 = this.y2 - this.endPts[1];
            float dx1 = -2.0f * this.x2 - 4.0f * this.endPts[0] + 6.0f * this.endPts[2];
            float dy1 = -2.0f * this.y2 - 4.0f * this.endPts[1] + 6.0f * this.endPts[3];
            this.pathStart.curveTo(this.endPts[0] + this.slack * dx1, this.endPts[1] + this.slack * dy1, this.endPts[2] - this.slack * this.dx2, this.endPts[3] - this.slack * this.dy2, this.endPts[2], this.endPts[3]);
            this.endPts[0] = this.endPts[2];
            this.endPts[1] = this.endPts[3];
            this.endPts[2] = this.x2;
            this.endPts[3] = this.y2;
        } else {
            float dx1 = this.dx2;
            float dy1 = this.dy2;
            float fx = (float)x;
            float fy = (float)y;
            this.dx2 = fx - this.endPts[0];
            this.dy2 = fy - this.endPts[1];
            this.path.curveTo(this.endPts[0] + this.slack * dx1, this.endPts[1] + this.slack * dy1, this.endPts[2] - this.slack * this.dx2, this.endPts[3] - this.slack * this.dy2, this.endPts[2], this.endPts[3]);
            this.dxEstimate = 2.0f * this.endPts[0] + 4.0f * fx - 6.0f * this.endPts[2];
            this.dyEstimate = 2.0f * this.endPts[1] + 4.0f * fy - 6.0f * this.endPts[3];
            this.endPts[0] = this.endPts[2];
            this.endPts[1] = this.endPts[3];
            this.endPts[2] = fx;
            this.endPts[3] = fy;
        }
        ++this.numpts;
    }

    public void closeTrail() {
        this.addPoint(this.x0, this.y0);
        this.addPoint(this.x1, this.y1);
        this.addPoint(this.x2, this.y2);
        this.closed = true;
        this.pathStart.reset();
        this.pathEnd.reset();
        this.path.closePath();
    }

    public synchronized void clear() {
        this.numpts = 0;
        this.xmin = Double.MAX_VALUE;
        this.xmax = -1.7976931348623157E308;
        this.ymin = Double.MAX_VALUE;
        this.ymax = -1.7976931348623157E308;
        this.path.reset();
        this.pathStart.reset();
        this.pathEnd.reset();
        this.closed = false;
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (this.numpts == 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.color);
        Shape s = this.path.createTransformedShape(panel.getPixelTransform());
        g2.draw(s);
        if (this.closed) {
            return;
        }
        s = this.pathStart.createTransformedShape(panel.getPixelTransform());
        g2.draw(s);
        if (this.numpts > 2) {
            this.makePathEnd();
            s = this.pathEnd.createTransformedShape(panel.getPixelTransform());
            g2.draw(s);
        }
    }

    private void makePathEnd() {
        this.pathEnd.reset();
        this.path.moveTo(this.endPts[0], this.endPts[1]);
        this.path.curveTo(this.endPts[0] + this.slack * this.dx2, this.endPts[1] + this.slack * this.dy2, this.endPts[2] - this.slack * this.dxEstimate, this.endPts[3] - this.slack * this.dyEstimate, this.endPts[2], this.endPts[3]);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public boolean isMeasured() {
        return this.enableMeasure && this.numpts > 0;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getYMax() {
        return this.ymax;
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            TrailBezier trail = (TrailBezier)obj;
            control.setValue("closed", trail.closed);
            control.setValue("color", trail.color);
            control.setValue("number of pts", trail.numpts);
        }

        public Object createObject(XMLControl control) {
            return new TrailBezier();
        }

        public Object loadObject(XMLControl control, Object obj) {
            TrailBezier trail = (TrailBezier)obj;
            trail.closed = control.getBoolean("closed");
            trail.color = (Color)control.getObject("color");
            trail.numpts = control.getInt("number of pts");
            return obj;
        }
    }
}

