/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.AbstractAxes;
import org.opensourcephysics.display.axes.CartesianAxes;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display.axes.YAxis;

public class CartesianType3
extends AbstractAxes
implements CartesianAxes,
Interactive {
    XAxis xaxis;
    YAxis yaxis;
    boolean enabled = true;
    boolean xlog = false;
    boolean ylog = false;

    public CartesianType3(PlottingPanel panel) {
        super(panel);
        this.titleLine.setJustification(0);
        this.titleLine.setFont(this.titleFont);
        this.xaxis = new XAxis();
        this.yaxis = new YAxis();
        this.xaxis.setEnabled(true);
        this.xaxis.setLocationType(2);
        this.yaxis.setEnabled(true);
        this.yaxis.setLocationType(2);
        if (panel == null) {
            return;
        }
        panel.setCoordinateStringBuilder(CoordinateStringBuilder.createCartesian());
        panel.setGutters(30, 30, 30, 30);
        panel.setAxes(this);
    }

    public void setXLabel(String s, String font_name) {
        this.xaxis.setTitle(s, font_name);
    }

    public void setYLabel(String s, String font_name) {
        this.yaxis.setTitle(s, font_name);
    }

    public void setTitle(String s, String font_name) {
        this.titleLine.setText(s);
        if (font_name == null || font_name.equals("")) {
            return;
        }
        this.titleLine.setFont(Font.decode(font_name));
    }

    public String getXLabel() {
        return this.xaxis.axisLabel.getText();
    }

    public String getYLabel() {
        return this.yaxis.axisLabel.getText();
    }

    public String getTitle() {
        return this.titleLine.getText();
    }

    public void setXLog(boolean isLog) {
        this.xlog = isLog;
        if (isLog) {
            this.xaxis.setAxisType(1);
        } else {
            this.xaxis.setAxisType(0);
        }
    }

    public void setYLog(boolean isLog) {
        this.ylog = isLog;
        if (isLog) {
            this.yaxis.setAxisType(1);
        } else {
            this.yaxis.setAxisType(0);
        }
    }

    public boolean isXLog() {
        return this.xlog;
    }

    public boolean isYLog() {
        return this.ylog;
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible) {
            return;
        }
        if (this.interiorColor != null) {
            g.setColor(this.interiorColor);
            int gw = panel.getLeftGutter() + panel.getRightGutter();
            int gh = panel.getTopGutter() + panel.getLeftGutter();
            g.fillRect(panel.getLeftGutter(), panel.getTopGutter(), panel.getWidth() - gw, panel.getHeight() - gh);
            g.setColor(Color.lightGray);
            g.drawRect(panel.getLeftGutter(), panel.getTopGutter(), panel.getWidth() - gw, panel.getHeight() - gh);
        }
        this.xaxis.draw(panel, g);
        this.yaxis.draw(panel, g);
        this.titleLine.setX((panel.getXMax() + panel.getXMin()) / 2.0);
        if (panel.getTopGutter() > 20) {
            this.titleLine.setY(panel.getYMax() + 5.0 / panel.getYPixPerUnit());
        } else {
            this.titleLine.setY(panel.getYMax() - 25.0 / panel.getYPixPerUnit());
        }
        this.titleLine.draw(panel, g);
    }

    public void setInteriorBackground(Color color) {
        this.interiorColor = color;
    }

    public void setShowMajorXGrid(boolean showGrid) {
        this.xaxis.setShowMajorGrid(showGrid);
        if (!showGrid) {
            this.setShowMinorXGrid(showGrid);
        }
    }

    public void setShowMinorXGrid(boolean showGrid) {
    }

    public void setShowMajorYGrid(boolean showGrid) {
        this.yaxis.setShowMajorGrid(showGrid);
        if (!showGrid) {
            this.setShowMinorYGrid(showGrid);
        }
    }

    public void setShowMinorYGrid(boolean showGrid) {
    }

    public void centerAxes(DrawingPanel panel) {
        this.xaxis.setLocation((panel.getYMax() + panel.getYMin()) / 2.0);
        this.yaxis.setLocation((panel.getXMax() + panel.getXMin()) / 2.0);
    }

    public void setEnabled(boolean _enabled) {
        this.enabled = _enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setXY(double x, double y) {
        this.xaxis.setLocation(y);
        this.yaxis.setLocation(x);
    }

    public void setX(double x) {
        this.yaxis.setLocation(x);
    }

    public void setY(double y) {
        this.xaxis.setLocation(y);
    }

    public double getX() {
        return 0.0;
    }

    public double getY() {
        return 0.0;
    }

    public double getXMin() {
        return 0.0;
    }

    public double getXMax() {
        return 0.0;
    }

    public double getYMin() {
        return 0.0;
    }

    public double getYMax() {
        return 0.0;
    }

    public boolean isMeasured() {
        return false;
    }

    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (!this.visible) {
            return null;
        }
        if (this.xaxis.findInteractive(panel, xpix, ypix) != null) {
            return this.xaxis;
        }
        if (this.yaxis.findInteractive(panel, xpix, ypix) != null) {
            return this.yaxis;
        }
        return null;
    }
}

