/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Dimension;
import java.awt.Graphics;
import org.opensourcephysics.display.Dimensioned;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.AbstractPolarAxis;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.display.axes.PolarAxes;

public class PolarType1
extends AbstractPolarAxis
implements PolarAxes,
Dimensioned {
    public PolarType1(PlottingPanel panel, String rLabel, String phiLabel, double phiOffset) {
        super(panel);
        if (panel == null) {
            return;
        }
        panel.setGutters(25, 25, 25, 25);
        this.titleLine.setJustification(0);
        this.titleLine.setFont(this.titleFont);
        panel.setAxes(this);
        panel.setCoordinateStringBuilder(CoordinateStringBuilder.createPolar(rLabel, phiLabel, phiOffset));
        panel.setClipAtGutter(false);
    }

    public PolarType1(PlottingPanel panel) {
        this(panel, "r=", " phi=", 0.0);
    }

    public Dimension getInterior(DrawingPanel panel) {
        double max = Math.abs(panel.getPreferredXMax());
        max = Math.max(max, Math.abs(panel.getPreferredXMin()));
        max = Math.max(max, Math.abs(panel.getPreferredYMax()));
        max = Math.max(max, Math.abs(panel.getPreferredYMin()));
        panel.setPreferredMinMax(-max, max, -max, max);
        return null;
    }

    public void setXLabel(String s, String font_name) {
    }

    public void setYLabel(String s, String font_name) {
    }

    public String getXLabel() {
        return "";
    }

    public String getYLabel() {
        return "";
    }

    public void setXLog(boolean isLog) {
    }

    public void setYLog(boolean isLog) {
    }

    public void setShowMajorXGrid(boolean showGrid) {
    }

    public void setShowMinorXGrid(boolean showGrid) {
    }

    public void setShowMajorYGrid(boolean showGrid) {
    }

    public void setShowMinorYGrid(boolean showGrid) {
    }

    public void draw(DrawingPanel panel, Graphics g) {
        double rmax = Math.abs(panel.getPreferredXMax());
        double dr = this.drawRings(rmax, panel, g);
        this.drawSpokes(rmax, panel, g);
        this.drawRAxis(dr, rmax, panel, g);
        this.titleLine.setX((panel.getXMax() + panel.getXMin()) / 2.0);
        if (panel.getTopGutter() > 20) {
            this.titleLine.setY(panel.getYMax() + 5.0 / panel.getYPixPerUnit());
        } else {
            this.titleLine.setY(panel.getYMax() - 25.0 / panel.getYPixPerUnit());
        }
        this.titleLine.draw(panel, g);
    }
}

