/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.axes.XYAxis;

public class YAxis
extends XYAxis {
    AffineTransform rot90 = AffineTransform.getRotateInstance(-1.5707963267948966);

    public YAxis() {
        this("Y Axis");
    }

    public YAxis(String title) {
        this.setTitle(title);
        this.axisLabel.setTheta(1.5707963267948966);
    }

    public void draw(DrawingPanel drawingPanel, Graphics g) {
        int pixLoc = drawingPanel.xToPix(this.location);
        if (pixLoc < 1) {
            this.location = drawingPanel.getXMin();
        }
        if (pixLoc > drawingPanel.getWidth() - 1) {
            this.location = drawingPanel.getXMax();
        }
        Graphics2D g2 = (Graphics2D)g;
        Shape clipShape = g2.getClip();
        g2.clipRect(0, 0, drawingPanel.getWidth(), drawingPanel.getHeight());
        switch (this.locationType) {
            case 0: 
            case 2: {
                this.drawInsideDisplay(drawingPanel, g);
                break;
            }
            case 1: {
                this.drawInsideGutter(drawingPanel, g);
                break;
            }
            default: {
                this.drawInsideDisplay(drawingPanel, g);
            }
        }
        g2.setClip(clipShape);
    }

    private void drawInsideDisplay(DrawingPanel drawingPanel, Graphics g) {
        int bottomGutter = drawingPanel.getBottomGutter();
        int rightGutter = drawingPanel.getRightGutter();
        int leftGutter = drawingPanel.getLeftGutter();
        int topGutter = drawingPanel.getTopGutter();
        FontMetrics fm = g.getFontMetrics();
        int sw = 0;
        g.setColor(this.color);
        if (this.locationType == 0) {
            this.location = (drawingPanel.getXMax() + drawingPanel.getXMin()) / 2.0;
        }
        int xo = drawingPanel.xToPix(this.location);
        int yo = drawingPanel.getHeight() - bottomGutter;
        int h = drawingPanel.getHeight() - bottomGutter - topGutter;
        this.calculateLabels(drawingPanel.getYMin(), drawingPanel.getYMax(), 1 + h / 35);
        String[] temp_strings = this.label_string;
        double[] temp_values = this.label_value;
        if (temp_strings.length != temp_values.length) {
            return;
        }
        int n = temp_values.length;
        for (int i = 0; i < n; ++i) {
            int ypix;
            if (this.axisType == 0) {
                ypix = drawingPanel.yToPix(temp_values[i] * this.decade_multiplier);
                if (this.showMajorGrid) {
                    g.setColor(this.majorGridColor);
                    g.drawLine(leftGutter, ypix, drawingPanel.getWidth() - rightGutter - 2, ypix);
                    g.setColor(this.color);
                }
                g.drawLine(xo - 5, ypix, xo + 5, ypix);
                sw = fm.stringWidth(temp_strings[i]);
                g.drawString(temp_strings[i], xo - sw - 7, ypix + 5);
                continue;
            }
            ypix = drawingPanel.yToPix(Math.pow(10.0, temp_values[i] * this.decade_multiplier));
            if (this.showMajorGrid) {
                g.setColor(this.majorGridColor);
                g.drawLine(leftGutter, ypix, drawingPanel.getWidth() - rightGutter - 2, ypix);
                g.setColor(this.color);
            }
            g.drawLine(xo - 5, ypix, xo + 5, ypix);
            sw = fm.stringWidth(this.logBase);
            this.drawMultiplier(xo - sw - 7, ypix + 5, (int)temp_values[i], (Graphics2D)g);
        }
        g.drawLine(xo, yo, xo, yo - h);
        Graphics2D g2 = (Graphics2D)g;
        if (this.axisType == 0 && this.label_exponent != 0) {
            g2.setColor(Color.red);
            g2.drawString("x10", 5, 18);
            g2.setFont(g2.getFont().deriveFont(0, 9.0f));
            g2.drawString("" + this.label_exponent, 25, 12);
        }
        g2.setColor(Color.black);
        if (this.axisLabel != null) {
            this.axisLabel.setY((drawingPanel.getYMax() + drawingPanel.getYMin()) / 2.0);
            this.axisLabel.setX(drawingPanel.pixToX(Math.max(leftGutter / 2 - 10, 18)));
            this.axisLabel.draw(drawingPanel, g2);
        }
    }

    private void drawInsideGutter(DrawingPanel drawingPanel, Graphics g) {
        int bottomGutter = drawingPanel.getBottomGutter();
        int rightGutter = drawingPanel.getRightGutter();
        int leftGutter = drawingPanel.getLeftGutter();
        int topGutter = drawingPanel.getTopGutter();
        FontMetrics fm = g.getFontMetrics();
        int sw = 0;
        g.setColor(this.color);
        int xo = leftGutter;
        int yo = drawingPanel.getHeight() - bottomGutter - 1;
        int h = drawingPanel.getHeight() - bottomGutter - topGutter;
        g.drawLine(xo, yo, xo, yo - h);
        this.calculateLabels(drawingPanel.getYMin(), drawingPanel.getYMax(), 1 + h / 35);
        String[] temp_strings = this.label_string;
        double[] temp_values = this.label_value;
        if (temp_strings.length != temp_values.length) {
            return;
        }
        int n = temp_values.length;
        for (int i = 0; i < n; ++i) {
            int ypix;
            if (this.axisType == 0) {
                ypix = drawingPanel.yToPix(temp_values[i] * this.decade_multiplier);
                if (this.showMajorGrid) {
                    g.setColor(this.majorGridColor);
                    g.drawLine(xo, ypix, drawingPanel.getWidth() - rightGutter - 2, ypix);
                    g.setColor(this.color);
                }
                g.drawLine(xo - 5, ypix, xo, ypix);
                sw = fm.stringWidth(temp_strings[i]);
                g.drawString(temp_strings[i], xo - sw - 7, ypix + 5);
                continue;
            }
            ypix = drawingPanel.yToPix(Math.pow(10.0, temp_values[i] * this.decade_multiplier));
            if (this.showMajorGrid) {
                g.setColor(this.majorGridColor);
                g.drawLine(xo, ypix, drawingPanel.getWidth() - rightGutter - 2, ypix);
                g.setColor(this.color);
            }
            g.drawLine(xo - 5, ypix, xo, ypix);
            sw = fm.stringWidth(this.logBase);
            this.drawMultiplier(xo - sw - 14, ypix + 5, (int)temp_values[i], (Graphics2D)g);
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.axisType == 0 && this.label_exponent != 0) {
            g2.setColor(Color.red);
            g2.drawString("x10", 5, 18);
            g2.setFont(g2.getFont().deriveFont(0, 9.0f));
            g2.drawString("" + this.label_exponent, 25, 12);
        }
        g2.setColor(Color.black);
        if (this.axisLabel != null) {
            this.axisLabel.setY((drawingPanel.getYMax() + drawingPanel.getYMin()) / 2.0);
            this.axisLabel.setX(drawingPanel.pixToX(Math.max(leftGutter / 2 - 10, 18)));
            this.axisLabel.draw(drawingPanel, g2);
        }
    }

    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (!this.enabled) {
            return null;
        }
        if (Math.abs(panel.xToPix(this.location) - xpix) < 2) {
            return this;
        }
        return null;
    }

    public void setXY(double x, double y) {
        this.location = x;
    }

    public void setX(double x) {
        this.location = x;
    }
}

