/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.AbstractList;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.opensourcephysics.display.DrawingPanel;

public class DrawingPanelInspector
extends JDialog {
    static DrawingPanelInspector inspector;
    DrawingPanel drawingPanel;
    DecimalFormat format = new DecimalFormat("0.00000E00");
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JPanel scalePanel = new JPanel();
    JPanel contentPanel = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JTextPane contentTextPane = new JTextPane();
    JTextField ymaxField = new JTextField();
    JPanel yminmaxpanel = new JPanel();
    JTextField yminField = new JTextField();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JPanel jPanel3 = new JPanel();
    JCheckBox zoomenableBox = new JCheckBox();
    JCheckBox autoscaleyBox = new JCheckBox();
    JCheckBox autoscalexBox = new JCheckBox();
    JTextField xmaxField = new JTextField();
    JTextField xminField = new JTextField();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();
    JPanel xminmaxpanel = new JPanel();
    JPanel jPanel1 = new JPanel();
    JButton applyButton = new JButton();
    JButton cancelButton = new JButton();
    JButton okButton = new JButton();
    JPanel jPanel4 = new JPanel();
    JButton measureButton = new JButton();
    JButton snapButton = new JButton();
    BoxLayout scaleLayout = new BoxLayout(this.scalePanel, 1);

    public DrawingPanelInspector(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ((Component)this).setVisible(true);
    }

    public DrawingPanelInspector(DrawingPanel dp) {
        this((Frame)null, "Drawing Panel Inspector", false);
        this.drawingPanel = dp;
        this.getValues();
        this.getContent();
    }

    public DrawingPanelInspector() {
        this((Frame)null, "", false);
    }

    void getValues() {
        this.xminField.setText("" + this.format.format((float)this.drawingPanel.getXMin()));
        this.xmaxField.setText("" + this.format.format((float)this.drawingPanel.getXMax()));
        this.yminField.setText("" + this.format.format((float)this.drawingPanel.getYMin()));
        this.ymaxField.setText("" + this.format.format((float)this.drawingPanel.getYMax()));
        this.zoomenableBox.setSelected(this.drawingPanel.isZoom());
        this.autoscalexBox.setSelected(this.drawingPanel.isAutoscaleX());
        this.autoscaleyBox.setSelected(this.drawingPanel.isAutoscaleY());
    }

    void getContent() {
        Iterator it = ((AbstractList)this.drawingPanel.getDrawables()).iterator();
        StringBuffer buffer = new StringBuffer();
        while (it.hasNext()) {
            Object obj = it.next();
            buffer.append(obj.toString());
            buffer.append('\n');
        }
        this.contentTextPane.setText(buffer.toString());
    }

    void applyValues() {
        double newXMin = this.drawingPanel.getXMin();
        try {
            newXMin = Double.parseDouble(this.xminField.getText());
        }
        catch (Exception ex) {
            // empty catch block
        }
        double newXMax = this.drawingPanel.getXMax();
        try {
            newXMax = Double.parseDouble(this.xmaxField.getText());
        }
        catch (Exception ex) {
            // empty catch block
        }
        double newYMin = this.drawingPanel.getYMin();
        try {
            newYMin = Double.parseDouble(this.yminField.getText());
        }
        catch (Exception ex) {
            // empty catch block
        }
        double newYMax = this.drawingPanel.getYMax();
        try {
            newYMax = Double.parseDouble(this.ymaxField.getText());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.drawingPanel.setAutoscaleX(this.autoscalexBox.isSelected());
        this.drawingPanel.setAutoscaleY(this.autoscaleyBox.isSelected());
        this.drawingPanel.setZoom(this.zoomenableBox.isSelected());
        if (!this.drawingPanel.isAutoscaleX() && !this.drawingPanel.isAutoscaleY()) {
            this.drawingPanel.setPreferredMinMax(newXMin, newXMax, newYMin, newYMax);
        } else if (!this.drawingPanel.isAutoscaleX()) {
            this.drawingPanel.setPreferredMinMaxX(newXMin, newXMax);
        } else if (!this.drawingPanel.isAutoscaleY()) {
            this.drawingPanel.setPreferredMinMaxY(newYMin, newYMax);
        }
        this.drawingPanel.scale();
        this.getValues();
        this.drawingPanel.repaint();
    }

    void applyButton_actionPerformed(ActionEvent e) {
        this.applyValues();
    }

    void measureButton_actionPerformed(ActionEvent e) {
        this.drawingPanel.measure();
        this.getValues();
        this.drawingPanel.repaint();
    }

    void snapButton_actionPerformed(ActionEvent e) {
        this.drawingPanel.snapshot();
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        ((Component)this).setVisible(false);
    }

    void okButton_actionPerformed(ActionEvent e) {
        this.applyValues();
        ((Component)this).setVisible(false);
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.scalePanel.setToolTipText("Set the drawing panel scale.");
        this.scalePanel.setLayout(this.scaleLayout);
        this.contentPanel.setLayout(this.borderLayout3);
        this.contentTextPane.setText("jTextPane1");
        this.ymaxField.setPreferredSize(new Dimension(100, 21));
        this.ymaxField.setText("0");
        this.yminField.setPreferredSize(new Dimension(100, 21));
        this.yminField.setText("0");
        this.jLabel4.setText("  ymax =");
        this.jLabel3.setText("ymin =");
        this.zoomenableBox.setText("enable zoom");
        this.autoscaleyBox.setText("autoscale y");
        this.autoscalexBox.setText("autoscale x");
        this.xmaxField.setText("0");
        this.xmaxField.setPreferredSize(new Dimension(100, 21));
        this.xminField.setText("0");
        this.xminField.setPreferredSize(new Dimension(100, 21));
        this.jLabel5.setText("  xmax =");
        this.jLabel6.setText("xmin =");
        this.xminmaxpanel.setToolTipText("Set the drawing panel scale.");
        this.applyButton.setText("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrawingPanelInspector.this.applyButton_actionPerformed(e);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrawingPanelInspector.this.cancelButton_actionPerformed(e);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrawingPanelInspector.this.okButton_actionPerformed(e);
            }
        });
        this.measureButton.setFont(new Font("Dialog", 0, 10));
        this.measureButton.setText("Measure");
        this.measureButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrawingPanelInspector.this.measureButton_actionPerformed(e);
            }
        });
        this.snapButton.setFont(new Font("Dialog", 0, 10));
        this.snapButton.setText("Snapshot");
        this.snapButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrawingPanelInspector.this.snapButton_actionPerformed(e);
            }
        });
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jTabbedPane1, "Center");
        this.jPanel3.add((Component)this.zoomenableBox, null);
        this.jPanel3.add((Component)this.autoscalexBox, null);
        this.jPanel3.add((Component)this.autoscaleyBox, null);
        this.xminmaxpanel.add((Component)this.jLabel6, null);
        this.xminmaxpanel.add((Component)this.xminField, null);
        this.xminmaxpanel.add((Component)this.jLabel5, null);
        this.xminmaxpanel.add((Component)this.xmaxField, null);
        this.scalePanel.add((Component)this.xminmaxpanel, null);
        this.scalePanel.add((Component)this.yminmaxpanel, null);
        this.yminmaxpanel.add((Component)this.jLabel3, null);
        this.yminmaxpanel.add((Component)this.yminField, null);
        this.yminmaxpanel.add((Component)this.jLabel4, null);
        this.yminmaxpanel.add((Component)this.ymaxField, null);
        this.scalePanel.add((Component)this.jPanel4, null);
        this.jPanel4.add((Component)this.measureButton, null);
        this.jPanel4.add((Component)this.snapButton, null);
        this.scalePanel.add((Component)this.jPanel3, null);
        this.jTabbedPane1.add((Component)this.scalePanel, "scale");
        this.jTabbedPane1.add((Component)this.contentPanel, "content");
        this.contentPanel.add((Component)this.contentTextPane, "Center");
        this.scalePanel.add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.okButton, null);
        this.jPanel1.add((Component)this.cancelButton, null);
        this.jPanel1.add((Component)this.applyButton, null);
    }

    public static DrawingPanelInspector getInspector(DrawingPanel dp) {
        if (inspector == null) {
            inspector = new DrawingPanelInspector(dp);
        } else {
            DrawingPanelInspector.inspector.drawingPanel = dp;
            inspector.getValues();
            inspector.getContent();
            ((Component)inspector).setVisible(true);
        }
        return inspector;
    }

    public static void hideInspector() {
        if (inspector != null) {
            ((Component)inspector).setVisible(false);
        }
    }

    public static void updateValues(DrawingPanel dp) {
        if (inspector == null || DrawingPanelInspector.inspector.drawingPanel != dp || !inspector.isShowing()) {
            return;
        }
        DrawingPanelInspector.inspector.drawingPanel.scale();
        inspector.getValues();
    }
}

