/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Random;
import javax.swing.JFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Grid;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display2d.ByteLattice;

public class BinaryLattice
extends MeasuredImage
implements ByteLattice {
    WritableRaster raster;
    Grid grid;
    byte[] packedData;
    int ny;
    int nx;
    boolean visible = true;
    Color zeroColor = Color.red;
    Color oneColor = Color.blue;

    public BinaryLattice(int _nx, int _ny) {
        this.ny = _ny;
        this.nx = _nx;
        int len = (this.nx + 7) / 8 * this.ny;
        this.packedData = new byte[len];
        DataBufferByte databuffer = new DataBufferByte(this.packedData, len);
        this.raster = Raster.createPackedRaster(databuffer, this.nx, this.ny, 1, null);
        IndexColorModel colorModel = new IndexColorModel(1, 2, new byte[]{-1, 0}, new byte[]{0, 0}, new byte[]{0, -1});
        this.image = new BufferedImage(colorModel, this.raster, false, null);
        this.xmin = 0.0;
        this.xmax = this.nx;
        this.ymin = 0.0;
        this.ymax = this.ny;
        this.grid = new Grid(this.nx, this.ny, this.xmin, this.xmax, this.ymin, this.ymax);
        this.grid.setColor(Color.lightGray);
    }

    public void createDefaultColors() {
        this.zeroColor = Color.red;
        this.oneColor = Color.blue;
    }

    public void resizeLattice(int _nx, int _ny) {
        this.ny = _ny;
        this.nx = _nx;
        int len = (this.nx + 7) / 8 * this.ny;
        this.packedData = new byte[len];
        DataBufferByte databuffer = new DataBufferByte(this.packedData, len);
        this.raster = Raster.createPackedRaster(databuffer, this.nx, this.ny, 1, null);
        ColorModel colorModel = this.image.getColorModel();
        this.image = new BufferedImage(colorModel, this.raster, false, null);
        Color color = this.grid.getColor();
        this.grid = new Grid(this.nx, this.ny, this.xmin, this.xmax, this.ymin, this.ymax);
        this.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
        this.grid.setColor(color);
    }

    public void randomize() {
        Random random = new Random();
        random.nextBytes(this.packedData);
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        super.draw(panel, g);
        this.grid.draw(panel, g);
    }

    public void setAll(byte[][] val) {
        if (this.getNx() != val.length || this.getNy() != val[0].length) {
            this.resizeLattice(val.length, val[0].length);
        }
        this.setBlock(0, 0, val);
    }

    public void setAll(byte[][] val, double xmin, double xmax, double ymin, double ymax) {
        this.setAll(val);
        this.setMinMax(xmin, xmax, ymin, ymax);
    }

    public void setMinMax(double xmin, double xmax, double ymin, double ymax) {
        super.setMinMax(xmin, xmax, ymin, ymax);
        this.grid.setMinMax(xmin, xmax, ymin, ymax);
    }

    public void setBlock(int x_offset, int y_offset, int[][] val) {
        if (y_offset < 0 || y_offset + val[0].length > this.ny) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setBlock.");
        }
        if (x_offset < 0 || x_offset + val.length > this.nx) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setBlock.");
        }
        int my = val[0].length + y_offset;
        for (int iy = y_offset; iy < my; ++iy) {
            int mx = val.length + x_offset;
            for (int ix = x_offset; ix < mx; ++ix) {
                int arrayIndex = (this.ny - iy - 1) * ((this.nx + 7) / 8) + ix / 8;
                byte packedcell = this.packedData[arrayIndex];
                int mask = 128 >>> ix % 8;
                packedcell = val[ix - x_offset][iy - y_offset] <= 0 ? (byte)(packedcell & ~mask) : (byte)(packedcell | mask);
                this.packedData[arrayIndex] = packedcell;
            }
        }
    }

    public void setBlock(int ix_offset, int iy_offset, byte[][] val) {
        if (iy_offset < 0 || iy_offset + val[0].length > this.ny) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setBlock.");
        }
        if (ix_offset < 0 || ix_offset + val.length > this.nx) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setBlock.");
        }
        int my = val[0].length + iy_offset;
        for (int iy = iy_offset; iy < my; ++iy) {
            int mx = val.length + ix_offset;
            for (int ix = ix_offset; ix < mx; ++ix) {
                int arrayIndex = (this.ny - iy - 1) * ((this.nx + 7) / 8) + ix / 8;
                byte packedcell = this.packedData[arrayIndex];
                int mask = 128 >>> ix % 8;
                packedcell = val[ix - ix_offset][iy - iy_offset] <= 0 ? (byte)(packedcell & ~mask) : (byte)(packedcell | mask);
                this.packedData[arrayIndex] = packedcell;
            }
        }
    }

    public void setBlock(byte[][] val) {
        this.setBlock(0, 0, val);
    }

    public void setCol(int ix, int iy_offset, int[] val) {
        if (iy_offset < 0 || iy_offset + val.length > this.ny) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setCol.");
        }
        if (ix < 0 || ix >= this.nx) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setCol.");
        }
        int nr = val.length + iy_offset;
        for (int iy = iy_offset; iy < nr; ++iy) {
            int arrayIndex = (this.ny - iy - 1) * ((this.nx + 7) / 8) + ix / 8;
            byte packedcell = this.packedData[arrayIndex];
            int mask = 128 >>> ix % 8;
            packedcell = val[iy - iy_offset] <= 0 ? (byte)(packedcell & ~mask) : (byte)(packedcell | mask);
            this.packedData[arrayIndex] = packedcell;
        }
    }

    public void setCol(int ix, int iy_offset, byte[] val) {
        if (iy_offset < 0 || iy_offset + val.length > this.ny) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setCol.");
        }
        if (ix < 0 || ix >= this.nx) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setCol.");
        }
        int nr = val.length + iy_offset;
        for (int iy = iy_offset; iy < nr; ++iy) {
            int arrayIndex = (this.ny - iy - 1) * ((this.nx + 7) / 8) + ix / 8;
            byte packedcell = this.packedData[arrayIndex];
            int mask = 128 >>> ix % 8;
            packedcell = val[iy - iy_offset] <= 0 ? (byte)(packedcell & ~mask) : (byte)(packedcell | mask);
            this.packedData[arrayIndex] = packedcell;
        }
    }

    public void setRow(int iy, int ix_offset, int[] val) {
        if (iy < 0 || iy >= this.ny) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setRow.");
        }
        if (ix_offset < 0 || ix_offset + val.length > this.nx) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setRow.");
        }
        int nc = val.length + ix_offset;
        for (int ix = ix_offset; ix < nc; ++ix) {
            int arrayIndex = (this.ny - iy - 1) * ((this.nx + 7) / 8) + ix / 8;
            byte packedcell = this.packedData[arrayIndex];
            int mask = 128 >>> ix % 8;
            packedcell = val[ix - ix_offset] <= 0 ? (byte)(packedcell & ~mask) : (byte)(packedcell | mask);
            this.packedData[arrayIndex] = packedcell;
        }
    }

    public void setRow(int iy, int ix_offset, byte[] val) {
        if (iy < 0 || iy >= this.ny) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setRow.");
        }
        if (ix_offset < 0 || ix_offset + val.length > this.nx) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setRow.");
        }
        int nc = val.length + ix_offset;
        for (int ix = ix_offset; ix < nc; ++ix) {
            int arrayIndex = (this.ny - iy - 1) * ((this.nx + 7) / 8) + ix / 8;
            byte packedcell = this.packedData[arrayIndex];
            int mask = 128 >>> ix % 8;
            packedcell = val[ix - ix_offset] <= 0 ? (byte)(packedcell & ~mask) : (byte)(packedcell | mask);
            this.packedData[arrayIndex] = packedcell;
        }
    }

    public void setValue(int ix, int iy, int val) {
        if (iy < 0 || iy >= this.ny || ix < 0 || ix >= this.nx) {
            throw new IllegalArgumentException("Cell row or column index out of range.  row=" + iy + "  col=" + ix);
        }
        int arrayIndex = (this.ny - iy - 1) * ((this.nx + 7) / 8) + ix / 8;
        byte packedcell = this.packedData[arrayIndex];
        int mask = 128 >>> ix % 8;
        packedcell = val <= 0 ? (byte)(packedcell & ~mask) : (byte)(packedcell | mask);
        this.packedData[arrayIndex] = packedcell;
    }

    public void setValue(int ix, int iy, byte val) {
        this.setValue(ix, iy, (int)val);
    }

    public byte getValue(int ix, int iy) {
        byte packedcell = this.packedData[(this.ny - iy - 1) * ((this.nx + 7) / 8) + ix / 8];
        int mask = 128 >>> ix % 8;
        if ((packedcell & mask) > 0) {
            return 1;
        }
        return 0;
    }

    public int getNx() {
        return this.nx;
    }

    public int getNy() {
        return this.ny;
    }

    public void setShowGrid(boolean showGrid) {
        this.grid.setVisible(showGrid);
    }

    public void setColorPalette(Color[] colors) {
        this.zeroColor = colors[0];
        this.oneColor = colors[1];
        IndexColorModel colorModel = new IndexColorModel(1, 2, new byte[]{(byte)this.zeroColor.getRed(), (byte)this.oneColor.getRed()}, new byte[]{(byte)this.zeroColor.getGreen(), (byte)this.oneColor.getGreen()}, new byte[]{(byte)this.zeroColor.getBlue(), (byte)this.oneColor.getBlue()});
        this.image = new BufferedImage(colorModel, this.raster, false, null);
    }

    public void setIndexedColor(int i, Color color) {
        if (i == 0) {
            this.zeroColor = color;
        } else {
            this.oneColor = color;
        }
        IndexColorModel colorModel = new IndexColorModel(1, 2, new byte[]{(byte)this.zeroColor.getRed(), (byte)this.oneColor.getRed()}, new byte[]{(byte)this.zeroColor.getGreen(), (byte)this.oneColor.getGreen()}, new byte[]{(byte)this.zeroColor.getBlue(), (byte)this.oneColor.getBlue()});
        this.image = new BufferedImage(colorModel, this.raster, false, null);
    }

    public void setGridLineColor(Color color) {
        this.grid.setColor(color);
    }

    public void setShowGridLines(boolean showGridLines) {
        this.grid.setVisible(showGridLines);
    }

    public int xToIndex(double x) {
        double xMax;
        int nx = this.getNx();
        double xMin = this.getXMin();
        double deltaX = (x - xMin) / ((xMax = this.getXMax()) - xMin);
        int ix = (int)(deltaX * (double)nx);
        if (ix < 0) {
            return 0;
        }
        if (ix >= nx) {
            return nx - 1;
        }
        return ix;
    }

    public int yToIndex(double y) {
        double yMax;
        int ny = this.getNy();
        double yMin = this.getYMin();
        double deltaY = (y - yMin) / ((yMax = this.getYMax()) - yMin);
        int iy = (int)(deltaY * (double)ny);
        if (iy < 0) {
            return 0;
        }
        if (iy >= ny) {
            return ny - 1;
        }
        return iy;
    }

    public int indexFromPoint(double x, double y) {
        int nx = this.getNx();
        int ny = this.getNy();
        double xMin = this.getXMin();
        double xMax = this.getXMax();
        double yMin = this.getYMin();
        double yMax = this.getYMax();
        double deltaX = (x - xMin) / (xMax - xMin);
        double deltaY = (y - yMin) / (yMax - yMin);
        int ix = (int)(deltaX * (double)nx);
        int iy = (int)(deltaY * (double)ny);
        if (ix < 0 || iy < 0 || ix >= nx || iy >= ny) {
            return -1;
        }
        return iy * nx + ix;
    }

    public JFrame showLegend() {
        return null;
    }
}

