/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Random;
import javax.swing.JFrame;
import org.opensourcephysics.display.Dimensioned;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display2d.ByteLattice;

public class ByteRaster
extends MeasuredImage
implements Dimensioned,
ByteLattice {
    WritableRaster raster;
    ColorModel colorModel;
    byte[] packedData;
    int ny;
    int nx;
    Dimension dimension;
    Color gridColor = Color.lightGray;
    boolean showGrid = false;
    byte[] reds = new byte[256];
    byte[] greens = new byte[256];
    byte[] blues = new byte[256];
    private JFrame legendFrame;

    public ByteRaster(int _nx, int _ny) {
        this.ny = _ny;
        this.nx = _nx;
        this.dimension = new Dimension(this.nx - 1, this.ny - 1);
        int len = this.nx * this.ny;
        this.packedData = new byte[len];
        DataBufferByte databuffer = new DataBufferByte(this.packedData, len);
        this.raster = Raster.createPackedRaster(databuffer, this.nx, this.ny, 8, null);
        this.colorModel = this.createColorModel();
        this.image = new BufferedImage(this.colorModel, this.raster, false, null);
        this.xmin = 0.0;
        this.xmax = this.nx;
        this.ymin = 0.0;
        this.ymax = this.ny;
    }

    public void resizeLattice(int nx, int ny) {
        this.resizeRaster(nx, ny);
        this.xmin = 0.0;
        this.xmax = nx;
        this.ymin = 0.0;
        this.ymax = ny;
    }

    public void resizeRaster(int _nx, int _ny) {
        this.ny = _ny;
        this.nx = _nx;
        this.dimension = new Dimension(this.nx - 1, this.ny - 1);
        int len = this.nx * this.ny;
        this.packedData = new byte[len];
        DataBufferByte databuffer = new DataBufferByte(this.packedData, len);
        this.raster = Raster.createPackedRaster(databuffer, this.nx, this.ny, 8, null);
        this.image = new BufferedImage(this.colorModel, this.raster, false, null);
    }

    public int getNx() {
        return this.nx;
    }

    public int getNy() {
        return this.ny;
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible) {
            return;
        }
        g.setColor(this.gridColor);
        g.drawImage(this.image, panel.getLeftGutter(), panel.getTopGutter(), panel);
        if (this.showGrid) {
            g.drawRect(panel.getLeftGutter(), panel.getTopGutter(), (int)this.dimension.getWidth(), (int)this.dimension.getHeight());
        }
    }

    public void randomize() {
        Random random = new Random();
        random.nextBytes(this.packedData);
    }

    public Dimension getInterior(DrawingPanel panel) {
        panel.setPreferredMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
        return this.dimension;
    }

    public void setAll(byte[][] val) {
        if (this.getNx() != val.length || this.getNy() != val[0].length) {
            this.resizeLattice(val.length, val[0].length);
        }
        this.setBlock(0, 0, val);
    }

    public void setAll(byte[][] val, double xmin, double xmax, double ymin, double ymax) {
        this.setAll(val);
        this.setMinMax(xmin, xmax, ymin, ymax);
    }

    public void setBlock(byte[][] val) {
        this.setBlock(0, 0, val);
    }

    public void setBlock(int ix_offset, int iy_offset, byte[][] val) {
        if (iy_offset < 0 || iy_offset + val[0].length > this.ny) {
            throw new IllegalArgumentException("Row index out of range in byte raster setBlock.");
        }
        if (ix_offset < 0 || ix_offset + val.length > this.nx) {
            throw new IllegalArgumentException("Column index out of range in byte raster setBlock.");
        }
        int my = val[0].length + iy_offset;
        for (int iy = iy_offset; iy < my; ++iy) {
            int mx = val.length + ix_offset;
            for (int ix = ix_offset; ix < mx; ++ix) {
                this.packedData[(this.ny - iy - 1) * this.nx + ix] = val[ix - ix_offset][iy - iy_offset];
            }
        }
    }

    public void setBlock(int ix_offset, int iy_offset, int[][] val) {
        if (iy_offset < 0 || iy_offset + val[0].length > this.ny) {
            throw new IllegalArgumentException("Row index out of range in byte raster setBlock.");
        }
        if (ix_offset < 0 || ix_offset + val.length > this.nx) {
            throw new IllegalArgumentException("Column index out of range in byte raster setBlock.");
        }
        int my = val[0].length + iy_offset;
        for (int iy = iy_offset; iy < my; ++iy) {
            int mx = val.length + ix_offset;
            for (int ix = ix_offset; ix < mx; ++ix) {
                this.packedData[(this.ny - iy - 1) * this.nx + ix] = (byte)val[ix - ix_offset][iy - iy_offset];
            }
        }
    }

    public void setCol(int ix, int iy_offset, byte[] val) {
        if (iy_offset < 0 || iy_offset + val.length > this.ny) {
            throw new IllegalArgumentException("Row index out of range in byte raster setCol.");
        }
        if (ix < 0 || ix >= this.nx) {
            throw new IllegalArgumentException("Column index out of range in byte raster setCol.");
        }
        int my = val.length + iy_offset;
        for (int iy = iy_offset; iy < my; ++iy) {
            this.packedData[(this.ny - iy - 1) * this.nx + ix] = val[iy - iy_offset];
        }
    }

    public void setRow(int iy, int ix_offset, byte[] val) {
        if (iy < 0 || iy >= this.ny) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setRow.");
        }
        if (ix_offset < 0 || ix_offset + val.length > this.nx) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setRow.");
        }
        int mx = val.length + ix_offset;
        for (int ix = ix_offset; ix < mx; ++ix) {
            this.packedData[(this.ny - iy - 1) * this.nx + ix] = val[ix - ix_offset];
        }
    }

    public void setValue(int ix, int iy, byte val) {
        this.packedData[(this.ny - iy - 1) * this.nx + ix] = val;
    }

    public byte getValue(int ix, int iy) {
        return this.packedData[(this.ny - iy - 1) * this.nx + ix];
    }

    public void setBWPalette() {
        Color[] bwPalette = new Color[256];
        for (int i = 0; i < 256; ++i) {
            bwPalette[i] = new Color(i, i, i);
        }
        this.setColorPalette(bwPalette);
    }

    public void setColorPalette(Color[] colors) {
        int numColors = colors.length;
        this.reds = new byte[numColors];
        this.greens = new byte[numColors];
        this.blues = new byte[numColors];
        for (int i = 0; i < numColors; ++i) {
            this.reds[i] = (byte)colors[i].getRed();
            this.greens[i] = (byte)colors[i].getGreen();
            this.blues[i] = (byte)colors[i].getBlue();
        }
        this.colorModel = new IndexColorModel(8, numColors, this.reds, this.greens, this.blues);
        this.image = new BufferedImage(this.colorModel, this.raster, false, null);
    }

    public byte[][] getColorPalette() {
        byte[][] palette = new byte[][]{this.reds, this.greens, this.blues};
        return palette;
    }

    public void createDefaultColors() {
        this.colorModel = this.createColorModel();
        this.image = new BufferedImage(this.colorModel, this.raster, false, null);
    }

    public void setIndexedColor(int i, Color color) {
        i = (i + 256) % this.reds.length;
        this.reds[i] = (byte)color.getRed();
        this.greens[i] = (byte)color.getGreen();
        this.blues[i] = (byte)color.getBlue();
        this.colorModel = new IndexColorModel(8, 256, this.reds, this.greens, this.blues);
        this.image = new BufferedImage(this.colorModel, this.raster, false, null);
    }

    public JFrame showLegend() {
        InteractivePanel dp = new InteractivePanel();
        dp.setPreferredSize(new Dimension(300, 80));
        dp.setGutters(0, 0, 0, 35);
        dp.setClipAtGutter(false);
        if (this.legendFrame == null) {
            this.legendFrame = new JFrame("Legend");
        }
        this.legendFrame.setResizable(false);
        this.legendFrame.setContentPane(dp);
        ByteRaster byteRaster = new ByteRaster(256, 20);
        byteRaster.setMinMax(-128.0, 127.0, 0.0, 1.0);
        byte[][] data = new byte[256][20];
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 20; ++j) {
                data[i][j] = (byte)(-128 + i);
            }
        }
        byteRaster.setBlock(0, 0, data);
        dp.addDrawable(byteRaster);
        XAxis xaxis = new XAxis("");
        xaxis.setLocationType(2);
        xaxis.setLocation(-0.5);
        xaxis.setEnabled(true);
        dp.addDrawable(xaxis);
        this.legendFrame.pack();
        ((Component)this.legendFrame).setVisible(true);
        return this.legendFrame;
    }

    public void setShowGridLines(boolean showGridLines) {
        this.showGrid = showGridLines;
    }

    public void setGridLineColor(Color c) {
        this.gridColor = c;
    }

    ColorModel createColorModel() {
        this.reds = new byte[256];
        this.greens = new byte[256];
        this.blues = new byte[256];
        for (int i = 0; i < 256; ++i) {
            double x = i < 128 ? (double)(i - 100) / 255.0 : -1.0;
            double val = Math.exp(-x * x * 8.0);
            this.reds[i] = (byte)(255.0 * val);
            x = i < 128 ? (double)i / 255.0 : (double)(255 - i) / 255.0;
            val = Math.exp(-x * x * 8.0);
            this.greens[i] = (byte)(255.0 * val);
            x = i < 128 ? -1.0 : (double)(i - 156) / 255.0;
            val = Math.exp(-x * x * 8.0);
            this.blues[i] = (byte)(255.0 * val);
        }
        IndexColorModel colorModel = new IndexColorModel(8, 256, this.reds, this.greens, this.blues);
        return colorModel;
    }

    public int indexFromPoint(double x, double y) {
        int nx = this.getNx();
        int ny = this.getNy();
        double xMin = this.getXMin();
        double xMax = this.getXMax();
        double yMin = this.getYMin();
        double yMax = this.getYMax();
        double deltaX = (x - xMin) / (xMax - xMin);
        double deltaY = (y - yMin) / (yMax - yMin);
        int ix = (int)(deltaX * (double)nx);
        int iy = (int)(deltaY * (double)ny);
        if (ix < 0 || iy < 0 || ix >= nx || iy >= ny) {
            return -1;
        }
        return iy * nx + ix;
    }

    public int xToIndex(double x) {
        double xMax;
        int nx = this.getNx();
        double xMin = this.getXMin();
        double deltaX = (x - xMin) / ((xMax = this.getXMax()) - xMin);
        int ix = (int)(deltaX * (double)nx);
        if (ix < 0) {
            return 0;
        }
        if (ix >= nx) {
            return nx - 1;
        }
        return ix;
    }

    public double indexToX(int i) {
        double xMin = this.getXMin();
        double xMax = this.getXMax();
        return xMin + (double)i * (xMax - xMin) / (double)this.getNx();
    }

    public int yToIndex(double y) {
        double yMax;
        int ny = this.getNy();
        double yMin = this.getYMin();
        double deltaY = (y - yMin) / ((yMax = this.getYMax()) - yMin);
        int iy = (int)(deltaY * (double)ny);
        if (iy < 0) {
            return 0;
        }
        if (iy >= ny) {
            return ny - 1;
        }
        return iy;
    }

    public double indexToY(int i) {
        double yMin = this.getYMin();
        double yMax = this.getYMax();
        return yMin + (double)i * (yMax - yMin) / (double)this.getNy();
    }
}

