/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.ColorMapper;
import org.opensourcephysics.display2d.ContourAccumulator;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.Plot2DLoader;

public class ContourPlot
implements Plot2D {
    private GridData griddata;
    private Color lineColor = new Color(0, 64, 0);
    private boolean visible = true;
    private int contour_lines = 12;
    private boolean showContourLines = true;
    private boolean showColoredLevels = true;
    private double contour_stepz;
    private int[] xpoints = new int[8];
    private int[] ypoints = new int[8];
    private int[] contour_x = new int[8];
    private int[] contour_y = new int[8];
    private double[] delta = new double[4];
    private double[] intersection = new double[4];
    private double[][] contour_vertex = new double[4][3];
    private ContourAccumulator accumulator = new ContourAccumulator();
    private double zmin = 0.0;
    private double zmax = 1.0;
    private boolean autoscaleZ = true;
    protected ColorMapper colorMap = new ColorMapper(this.contour_lines, this.zmin, this.zmax, 0);
    private Color[] contourColors = new Color[this.contour_lines + 2];
    private double[][] internalData = new double[1][1];
    private int ampIndex = 0;
    private int nx = 0;
    private int ny = 0;
    private int maxGridSize = 48;
    protected boolean interpolateLargeGrids = true;

    public ContourPlot() {
    }

    public ContourPlot(GridData _griddata) {
        this.griddata = _griddata;
        if (this.griddata == null) {
            return;
        }
        this.nx = this.griddata.getNx() > this.maxGridSize ? 32 : this.griddata.getNx();
        this.ny = this.griddata.getNy() > this.maxGridSize ? 32 : this.griddata.getNy();
        this.internalData = new double[this.nx][this.ny];
        this.update();
    }

    public double indexToX(int i) {
        return this.griddata.indexToX(i);
    }

    public double indexToY(int i) {
        return this.griddata.indexToY(i);
    }

    public int xToIndex(double x) {
        return this.griddata.xToIndex(x);
    }

    public int yToIndex(double y) {
        return this.griddata.yToIndex(y);
    }

    public void setAll(Object obj) {
        double[][] val = (double[][])obj;
        this.copyData(val);
        this.update();
    }

    public void setAll(Object obj, double xmin, double xmax, double ymin, double ymax) {
        double[][] val = (double[][])obj;
        this.copyData(val);
        if (this.griddata.isCellData()) {
            this.griddata.setCellScale(xmin, xmax, ymin, ymax);
        } else {
            this.griddata.setScale(xmin, xmax, ymin, ymax);
        }
        this.update();
    }

    private void copyData(double[][] val) {
        if (this.griddata != null && !(this.griddata instanceof ArrayData)) {
            throw new IllegalStateException("SetAll only supports ArrayData for data storage.");
        }
        if (this.griddata == null || this.griddata.getNx() != val.length || this.griddata.getNy() != val[0].length) {
            this.griddata = new ArrayData(val.length, val[0].length, 1);
            this.setGridData(this.griddata);
        }
        double[][] data = this.griddata.getData()[0];
        int ny = data[0].length;
        int nx = data.length;
        for (int i = 0; i < nx; ++i) {
            System.arraycopy(val[i], 0, data[i], 0, ny);
        }
    }

    public GridData getGridData() {
        return this.griddata;
    }

    public void setGridData(GridData _griddata) {
        this.griddata = _griddata;
        if (this.griddata == null) {
            return;
        }
        this.nx = this.griddata.getNx() > this.maxGridSize ? 32 : this.griddata.getNx();
        this.ny = this.griddata.getNy() > this.maxGridSize ? 32 : this.griddata.getNy();
        this.internalData = new double[this.nx][this.ny];
    }

    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    public JFrame showLegend() {
        return this.colorMap.showLegend();
    }

    public void setShowGridLines(boolean showLines) {
        this.showContourLines = showLines;
    }

    public void setGridLineColor(Color color) {
        this.lineColor = color;
    }

    public synchronized void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible || this.griddata == null) {
            return;
        }
        this.accumulator.clearAccumulator();
        this.contour_stepz = (this.zmax - this.zmin) / (double)(this.contour_lines + 1);
        double z = this.zmin;
        for (int c = 0; c < this.contourColors.length; ++c) {
            this.contourColors[c] = this.colorMap.doubleToColor(z);
            z += this.contour_stepz;
        }
        double x = this.griddata.getLeft();
        double dx = (this.griddata.getRight() - this.griddata.getLeft()) / (double)(this.nx - 1);
        double y = this.griddata.getTop();
        double dy = -(this.griddata.getTop() - this.griddata.getBottom()) / (double)(this.ny - 1);
        int mx = this.internalData.length - 1;
        for (int i = 0; i < mx; ++i) {
            y = this.griddata.getTop();
            int my = this.internalData[0].length - 1;
            for (int j = 0; j < my; ++j) {
                this.contour_vertex[0][0] = x;
                this.contour_vertex[0][1] = y;
                this.contour_vertex[0][2] = this.internalData[i][j];
                this.contour_vertex[1][0] = x;
                this.contour_vertex[1][1] = y + dy;
                this.contour_vertex[1][2] = this.internalData[i][j + 1];
                this.contour_vertex[2][0] = x + dx;
                this.contour_vertex[2][1] = y + dy;
                this.contour_vertex[2][2] = this.internalData[i + 1][j + 1];
                this.contour_vertex[3][0] = x + dx;
                this.contour_vertex[3][1] = y;
                this.contour_vertex[3][2] = this.internalData[i + 1][j];
                this.createContour(panel, g);
                y += dy;
            }
            x += dx;
        }
        if (this.showContourLines) {
            g.setColor(this.lineColor);
            this.accumulator.drawAll(g);
            int lpix = panel.xToPix(this.griddata.getLeft());
            int tpix = panel.yToPix(this.griddata.getTop());
            int rpix = panel.xToPix(this.griddata.getRight());
            int bpix = panel.yToPix(this.griddata.getBottom());
            g.drawRect(Math.min(lpix, rpix), Math.min(tpix, bpix), Math.abs(lpix - rpix), Math.abs(tpix - bpix));
        }
    }

    public void setAutoscaleZ(boolean isAutoscale, double floor, double ceil) {
        this.autoscaleZ = isAutoscale;
        if (this.autoscaleZ) {
            this.update();
        } else {
            this.zmax = ceil;
            this.zmin = floor;
            this.colorMap.setScale(this.zmin, this.zmax);
        }
    }

    public boolean isAutoscaleZ() {
        return this.autoscaleZ;
    }

    public double getFloor() {
        return this.colorMap.getFloor();
    }

    public double getCeiling() {
        return this.colorMap.getCeil();
    }

    public void update() {
        if (this.griddata == null) {
            return;
        }
        if (this.interpolateLargeGrids && this.nx != this.griddata.getNx() && this.ny != this.griddata.getNy()) {
            this.updateInterpolated(this.griddata);
        } else {
            this.updateDirect(this.griddata);
        }
    }

    void updateInterpolated(GridData griddata) {
        if (this.autoscaleZ) {
            double[] minmax = griddata.getZRange(this.ampIndex);
            this.zmax = minmax[1];
            this.zmin = minmax[0];
            this.colorMap.setScale(this.zmin, this.zmax);
        }
        double x = griddata.getLeft();
        double dx = (griddata.getRight() - griddata.getLeft()) / (double)(this.nx - 1);
        double y = griddata.getTop();
        double dy = -(griddata.getTop() - griddata.getBottom()) / (double)(this.ny - 1);
        for (int i = 0; i < this.nx; ++i) {
            y = griddata.getTop();
            for (int j = 0; j < this.ny; ++j) {
                this.internalData[i][j] = griddata.interpolate(x, y, this.ampIndex);
                y += dy;
            }
            x += dx;
        }
    }

    void updateDirect(GridData griddata) {
        block6: {
            block5: {
                if (griddata == null) {
                    return;
                }
                if (this.autoscaleZ) {
                    double[] minmax = griddata.getZRange(this.ampIndex);
                    this.zmax = minmax[1];
                    this.zmin = minmax[0];
                    this.colorMap.setScale(this.zmin, this.zmax);
                }
                if (!(griddata instanceof ArrayData)) break block5;
                double[][] arrayData = griddata.getData()[this.ampIndex];
                for (int i = 0; i < this.nx; ++i) {
                    System.arraycopy(arrayData[i], 0, this.internalData[i], 0, this.ny);
                }
                break block6;
            }
            if (!(griddata instanceof GridPointData)) break block6;
            double[][][] ptdata = griddata.getData();
            int nx = ptdata.length;
            for (int i = 0; i < nx; ++i) {
                int ny = ptdata[0].length;
                for (int j = 0; j < ny; ++j) {
                    this.internalData[i][j] = ptdata[i][j][2 + this.ampIndex];
                }
            }
        }
    }

    private final void createContour(DrawingPanel panel, Graphics g) {
        double z = this.zmin;
        this.xpoints[0] = panel.xToPix(this.contour_vertex[0][0]) + 1;
        this.xpoints[2] = panel.xToPix(this.contour_vertex[1][0]) + 1;
        this.xpoints[4] = panel.xToPix(this.contour_vertex[2][0]) + 1;
        this.xpoints[6] = panel.xToPix(this.contour_vertex[3][0]) + 1;
        this.xpoints[7] = -1;
        this.xpoints[5] = -1;
        this.xpoints[3] = -1;
        this.xpoints[1] = -1;
        this.ypoints[0] = panel.yToPix(this.contour_vertex[0][1]) + 1;
        this.ypoints[4] = panel.yToPix(this.contour_vertex[2][1]) + 1;
        this.ypoints[2] = this.ypoints[3] = panel.yToPix(this.contour_vertex[1][1]) + 1;
        this.ypoints[6] = this.ypoints[7] = panel.yToPix(this.contour_vertex[3][1]) + 1;
        int xmin = this.xpoints[0];
        int xmax = this.xpoints[4];
        for (int counter = 0; counter <= this.contour_lines + 1; ++counter) {
            int index;
            block7: for (int edge = 0; edge < 4; ++edge) {
                index = (edge << 1) + 1;
                int nextedge = edge + 1 & 3;
                if (z > this.contour_vertex[edge][2]) {
                    this.xpoints[index - 1] = -2;
                    if (z > this.contour_vertex[nextedge][2]) {
                        this.xpoints[index + 1 & 7] = -2;
                        this.xpoints[index] = -2;
                    }
                } else if (z > this.contour_vertex[nextedge][2]) {
                    this.xpoints[index + 1 & 7] = -2;
                }
                if (this.xpoints[index] == -2) continue;
                if (this.xpoints[index] != -1) {
                    int n = edge;
                    this.intersection[n] = this.intersection[n] + this.delta[edge];
                    if (index == 1 || index == 5) {
                        this.ypoints[index] = panel.yToPix(this.intersection[edge]) + 1;
                        continue;
                    }
                    this.xpoints[index] = panel.xToPix(this.intersection[edge]) + 1;
                    continue;
                }
                if (!(z > this.contour_vertex[edge][2]) && !(z > this.contour_vertex[nextedge][2])) continue;
                switch (index) {
                    case 1: {
                        this.delta[edge] = (this.contour_vertex[nextedge][1] - this.contour_vertex[edge][1]) * this.contour_stepz / (this.contour_vertex[nextedge][2] - this.contour_vertex[edge][2]);
                        this.intersection[edge] = (this.contour_vertex[nextedge][1] * (z - this.contour_vertex[edge][2]) + this.contour_vertex[edge][1] * (this.contour_vertex[nextedge][2] - z)) / (this.contour_vertex[nextedge][2] - this.contour_vertex[edge][2]);
                        this.xpoints[index] = xmin;
                        this.ypoints[index] = panel.yToPix(this.intersection[edge]) + 1;
                        continue block7;
                    }
                    case 3: {
                        this.delta[edge] = (this.contour_vertex[nextedge][0] - this.contour_vertex[edge][0]) * this.contour_stepz / (this.contour_vertex[nextedge][2] - this.contour_vertex[edge][2]);
                        this.intersection[edge] = (this.contour_vertex[nextedge][0] * (z - this.contour_vertex[edge][2]) + this.contour_vertex[edge][0] * (this.contour_vertex[nextedge][2] - z)) / (this.contour_vertex[nextedge][2] - this.contour_vertex[edge][2]);
                        this.xpoints[index] = panel.xToPix(this.intersection[edge]) + 1;
                        continue block7;
                    }
                    case 5: {
                        this.delta[edge] = (this.contour_vertex[edge][1] - this.contour_vertex[nextedge][1]) * this.contour_stepz / (this.contour_vertex[edge][2] - this.contour_vertex[nextedge][2]);
                        this.intersection[edge] = (this.contour_vertex[edge][1] * (z - this.contour_vertex[nextedge][2]) + this.contour_vertex[nextedge][1] * (this.contour_vertex[edge][2] - z)) / (this.contour_vertex[edge][2] - this.contour_vertex[nextedge][2]);
                        this.xpoints[index] = xmax;
                        this.ypoints[index] = panel.yToPix(this.intersection[edge]) + 1;
                        continue block7;
                    }
                    case 7: {
                        this.delta[edge] = (this.contour_vertex[edge][0] - this.contour_vertex[nextedge][0]) * this.contour_stepz / (this.contour_vertex[edge][2] - this.contour_vertex[nextedge][2]);
                        this.intersection[edge] = (this.contour_vertex[edge][0] * (z - this.contour_vertex[nextedge][2]) + this.contour_vertex[nextedge][0] * (this.contour_vertex[edge][2] - z)) / (this.contour_vertex[edge][2] - this.contour_vertex[nextedge][2]);
                        this.xpoints[index] = panel.xToPix(this.intersection[edge]) + 1;
                    }
                }
            }
            int contour_n = 0;
            for (index = 0; index < 8; ++index) {
                if (this.xpoints[index] < 0) continue;
                this.contour_x[contour_n] = this.xpoints[index];
                this.contour_y[contour_n] = this.ypoints[index];
                ++contour_n;
            }
            if (this.showColoredLevels && this.colorMap.getPaletteType() != 7) {
                g.setColor(this.contourColors[counter]);
                if (contour_n > 0) {
                    g.fillPolygon(this.contour_x, this.contour_y, contour_n);
                }
            }
            if (this.showContourLines) {
                int x = -1;
                int y = -1;
                for (int index2 = 1; index2 < 8; index2 += 2) {
                    if (this.xpoints[index2] < 0) continue;
                    if (x != -1) {
                        this.accumulator.addLine(x, y, this.xpoints[index2], this.ypoints[index2]);
                    }
                    x = this.xpoints[index2];
                    y = this.ypoints[index2];
                }
                if (this.xpoints[1] > 0 && x != -1) {
                    this.accumulator.addLine(x, y, this.xpoints[1], this.ypoints[1]);
                }
            }
            if (contour_n < 3) break;
            z += this.contour_stepz;
        }
    }

    public void setColorPalette(Color[] colors) {
        this.colorMap.setColorPalette(colors);
    }

    public void setPaletteType(int mode) {
        this.colorMap.setPaletteType(mode);
    }

    public void setFloorCeilColor(Color floorColor, Color ceilColor) {
        this.colorMap.setFloorCeilColor(floorColor, ceilColor);
    }

    public void setIndexes(int[] indexes) {
        this.ampIndex = indexes[0];
    }

    public void setNumberOfLevels(int n) {
        this.contour_lines = n;
        this.colorMap.setNumberOfColors(n);
        this.contourColors = new Color[this.contour_lines + 2];
    }

    public double getXMin() {
        return this.griddata.getLeft();
    }

    public double getXMax() {
        return this.griddata.getRight();
    }

    public double getYMin() {
        return this.griddata.getBottom();
    }

    public double getYMax() {
        return this.griddata.getTop();
    }

    public boolean isMeasured() {
        return this.griddata != null;
    }

    public static XML.ObjectLoader getLoader() {
        return new Plot2DLoader(){

            public void saveObject(XMLControl control, Object obj) {
                super.saveObject(control, obj);
                ContourPlot plot = (ContourPlot)obj;
                control.setValue("line color", plot.lineColor);
                control.setValue("color map", plot.colorMap);
            }

            public Object createObject(XMLControl control) {
                return new ContourPlot(null);
            }

            public Object loadObject(XMLControl control, Object obj) {
                super.loadObject(control, obj);
                ContourPlot plot = (ContourPlot)obj;
                plot.lineColor = (Color)control.getObject("line color");
                plot.colorMap = (ColorMapper)control.getObject("color map");
                return plot;
            }
        };
    }
}

