/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display2d.GridData;

public class FlatData
implements GridData {
    protected double[] data;
    protected double left;
    protected double right;
    protected double bottom;
    protected double top;
    protected double dx = 0.0;
    protected double dy = 0.0;
    protected boolean cellData = false;
    protected String[] names;
    int nx;
    int ny;
    int stride;

    public FlatData(int ix, int iy, int ncomponents) {
        if (iy < 1 || ix < 1) {
            throw new IllegalArgumentException("Number of dataset rows and columns must be positive. Your row=" + iy + "  col=" + ix);
        }
        if (ncomponents < 1) {
            throw new IllegalArgumentException("Number of 2d data components must be positive. Your ncomponents=" + ncomponents);
        }
        this.nx = ix;
        this.ny = iy;
        this.stride = ncomponents;
        this.data = new double[ncomponents * ix * iy];
        this.setScale(0.0, ix, 0.0, iy);
        this.names = new String[ncomponents];
        for (int i = 0; i < ncomponents; ++i) {
            this.names[i] = "Component_" + i;
        }
    }

    public void setComponentName(int i, String name) {
        this.names[i] = name;
    }

    public String getComponentName(int i) {
        return this.names[i];
    }

    public int getComponentCount() {
        return this.stride;
    }

    public void setScale(double _left, double _right, double _bottom, double _top) {
        this.cellData = false;
        this.left = _left;
        this.right = _right;
        this.bottom = _bottom;
        this.top = _top;
        int ix = this.nx;
        int iy = this.ny;
        this.dx = 0.0;
        if (ix > 1) {
            this.dx = (this.right - this.left) / (double)(ix - 1);
        }
        this.dy = 0.0;
        if (iy > 1) {
            this.dy = (this.bottom - this.top) / (double)(iy - 1);
        }
        if (this.dx == 0.0) {
            this.left -= 0.5;
            this.right += 0.5;
        }
        if (this.dy == 0.0) {
            this.bottom -= 0.5;
            this.top += 0.5;
        }
    }

    public boolean isCellData() {
        return this.cellData;
    }

    public double getValue(int ix, int iy, int component) {
        if (ix < 0 || ix >= this.nx) {
            throw new IllegalArgumentException("x index out of range in getValue");
        }
        if (iy < 0 || iy >= this.ny) {
            throw new IllegalArgumentException("y index out of range in getValue");
        }
        return this.data[(iy * this.nx + ix) * this.stride + component];
    }

    public void setValue(int ix, int iy, int component, double value) {
        if (ix < 0 || ix >= this.nx) {
            throw new IllegalArgumentException("x index out of range in getValue");
        }
        if (iy < 0 || iy >= this.ny) {
            throw new IllegalArgumentException("y index out of range in getValue");
        }
        this.data[(iy * this.nx + ix) * this.stride + component] = value;
    }

    public int getNx() {
        return this.nx;
    }

    public int getNy() {
        return this.ny;
    }

    public void setCellScale(double _left, double _right, double _bottom, double _top) {
        this.cellData = true;
        int ix = this.nx;
        int iy = this.ny;
        this.dx = 0.0;
        if (ix > 1) {
            this.dx = (_right - _left) / (double)ix;
        }
        this.dy = 0.0;
        if (iy > 1) {
            this.dy = (_bottom - _top) / (double)iy;
        }
        this.left = _left + this.dx / 2.0;
        this.right = _right - this.dx / 2.0;
        this.bottom = _bottom - this.dy / 2.0;
        this.top = _top + this.dy / 2.0;
    }

    public void setCenteredCellScale(double xmin, double xmax, double ymin, double ymax) {
        double delta = this.nx > 1 ? (xmax - xmin) / (double)(this.nx - 1) / 2.0 : 0.0;
        xmin -= delta;
        xmax += delta;
        delta = this.ny > 1 ? (ymax - ymin) / (double)(this.ny - 1) / 2.0 : 0.0;
        this.setCellScale(xmin, xmax, ymin -= delta, ymax += delta);
    }

    public double interpolate(double x, double y, int index) {
        int ix = (int)((x - this.left) / this.dx);
        ix = Math.max(0, ix);
        ix = Math.min(this.nx - 2, ix);
        int iy = -((int)((this.top - y) / this.dy));
        iy = Math.max(0, iy);
        iy = Math.min(this.ny - 2, iy);
        double t = (x - this.left) / this.dx - (double)ix;
        double u = -(this.top - y) / this.dy - (double)iy;
        if (ix < 0) {
            int i = this.nx * iy * this.stride + index;
            return (1.0 - u) * this.data[i] + u * this.data[i + this.nx * this.stride];
        }
        if (iy < 0) {
            int i = ix * this.stride + index;
            return (1.0 - t) * this.data[i] + t * this.data[i + this.stride];
        }
        int i = this.nx * iy * this.stride + ix * this.stride + index;
        return (1.0 - t) * (1.0 - u) * this.data[i] + t * (1.0 - u) * this.data[i + this.stride] + t * u * this.data[i + this.nx * this.stride + this.stride] + (1.0 - t) * u * this.data[i + this.nx * this.stride];
    }

    public double[] interpolate(double x, double y, int[] indexes, double[] values) {
        int ix = (int)((x - this.left) / this.dx);
        ix = Math.max(0, ix);
        ix = Math.min(this.nx - 2, ix);
        int iy = -((int)((this.top - y) / this.dy));
        iy = Math.max(0, iy);
        iy = Math.min(this.ny - 2, iy);
        if (ix < 0 && iy < 0) {
            int n = indexes.length;
            for (int i = 0; i < n; ++i) {
                values[i] = this.data[indexes[i]];
            }
            return values;
        }
        if (ix < 0) {
            double u = -(this.top - y) / this.dy - (double)iy;
            int n = indexes.length;
            for (int i = 0; i < n; ++i) {
                int ii = this.nx * iy * this.stride + indexes[i];
                values[i] = (1.0 - u) * this.data[ii] + u * this.data[ii + this.stride];
            }
            return values;
        }
        if (iy < 0) {
            double t = (x - this.left) / this.dx - (double)ix;
            int n = indexes.length;
            for (int i = 0; i < n; ++i) {
                int ii = ix * this.stride + indexes[i];
                values[i] = (1.0 - t) * this.data[ii] + t * this.data[ii + this.stride];
            }
            return values;
        }
        double t = (x - this.left) / this.dx - (double)ix;
        double u = -(this.top - y) / this.dy - (double)iy;
        int n = indexes.length;
        for (int i = 0; i < n; ++i) {
            int index = indexes[i];
            int ii = this.nx * iy * this.stride + ix * this.stride + index;
            values[i] = (1.0 - t) * (1.0 - u) * this.data[ii] + t * (1.0 - u) * this.data[ii + this.stride] + t * u * this.data[ii + this.nx * this.stride + this.stride] + (1.0 - t) * u * this.data[ii + this.nx * this.stride];
        }
        return values;
    }

    public double[][][] getData() {
        double[][][] data = new double[1][1][];
        data[0][0] = this.data;
        return data;
    }

    public double[] getZRange(int n) {
        double zmin;
        double zmax = zmin = this.data[n];
        for (int j = 0; j < this.ny; ++j) {
            int index = j * this.nx + n;
            int i = 0;
            while (n < this.nx) {
                double v = this.data[index + i];
                if (v > zmax) {
                    zmax = v;
                }
                if (v < zmin) {
                    zmin = v;
                }
                ++i;
            }
        }
        return new double[]{zmin, zmax};
    }

    public final double getLeft() {
        return this.left;
    }

    public final double getRight() {
        return this.right;
    }

    public final double getTop() {
        return this.top;
    }

    public final double getBottom() {
        return this.bottom;
    }

    public final double getDx() {
        return this.dx;
    }

    public final double getDy() {
        return this.dy;
    }

    public double indexToX(int i) {
        return this.data == null ? Double.NaN : this.left + this.dx * (double)i;
    }

    public double indexToY(int i) {
        return this.data == null ? Double.NaN : this.top + this.dy * (double)i;
    }

    public int xToIndex(double x) {
        if (this.data == null) {
            return 0;
        }
        int nx = this.getNx();
        double dx = (this.right - this.left) / (double)nx;
        int i = (int)((x - this.left) / dx);
        if (i < 0) {
            return 0;
        }
        if (i >= nx) {
            return nx - 1;
        }
        return i;
    }

    public int yToIndex(double y) {
        if (this.data == null) {
            return 0;
        }
        int ny = this.getNy();
        double dy = (this.top - this.bottom) / (double)ny;
        int i = (int)((this.top - y) / dy);
        if (i < 0) {
            return 0;
        }
        if (i >= ny) {
            return ny - 1;
        }
        return i;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            FlatData gpd = (FlatData)obj;
            control.setValue("left", gpd.left);
            control.setValue("right", gpd.right);
            control.setValue("bottom", gpd.bottom);
            control.setValue("top", gpd.top);
            control.setValue("dx", gpd.dx);
            control.setValue("dy", gpd.dy);
            control.setValue("is cell data", gpd.cellData);
            control.setValue("data", gpd.data);
        }

        public Object createObject(XMLControl control) {
            return new FlatData(1, 1, 1);
        }

        public Object loadObject(XMLControl control, Object obj) {
            FlatData gpd = (FlatData)obj;
            double[] data = (double[])control.getObject("data");
            gpd.data = data;
            gpd.left = control.getDouble("left");
            gpd.right = control.getDouble("right");
            gpd.bottom = control.getDouble("bottom");
            gpd.top = control.getDouble("top");
            gpd.dx = control.getDouble("dx");
            gpd.dy = control.getDouble("dy");
            gpd.cellData = control.getBoolean("is cell data");
            return obj;
        }
    }
}

