/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridTableModel;

public class GridDataTable
extends JTable
implements ActionListener {
    static final Color PANEL_BACKGROUND = UIManager.getColor("Panel.background");
    int refreshDelay = 0;
    Timer refreshTimer = new Timer(this.refreshDelay, this);
    GridTableModel tableModel;
    RowNumberRenderer rowNumberRenderer = new RowNumberRenderer(this);

    public GridDataTable(GridData griddata, int component) {
        this.refreshTimer.setRepeats(false);
        this.refreshTimer.setCoalesce(true);
        this.tableModel = new GridTableModel(griddata, component);
        this.setModel(this.tableModel);
        this.setAutoResizeMode(0);
        String name = this.getColumnName(0);
        TableColumn column = this.getColumn(name);
        int width = 20;
        column.setMinWidth(width);
        column.setResizable(true);
        column.setWidth(width);
        width = 60;
        int n = this.getColumnCount();
        for (int i = 1; i < n; ++i) {
            name = this.getColumnName(i);
            column = this.getColumn(name);
            column.setMinWidth(width);
            column.setWidth(width);
            column.setResizable(true);
        }
        this.sizeColumnsToFit(0);
    }

    public void actionPerformed(ActionEvent evt) {
        this.tableChanged(new TableModelEvent(this.tableModel, -1));
    }

    public void refreshTable() {
        if (this.refreshDelay > 0) {
            this.refreshTimer.start();
        } else {
            Runnable doRefreshTable = new Runnable(){

                public synchronized void run() {
                    GridDataTable.this.tableChanged(new TableModelEvent(GridDataTable.this.tableModel, -1));
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                doRefreshTable.run();
            } else {
                SwingUtilities.invokeLater(doRefreshTable);
            }
        }
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        int i = this.convertColumnIndexToModel(column);
        if (i == 0) {
            return this.rowNumberRenderer;
        }
        return this.getDefaultRenderer(this.getColumnClass(column));
    }

    private static class RowNumberRenderer
    extends JLabel
    implements TableCellRenderer {
        JTable table;

        public RowNumberRenderer(JTable _table) {
            this.table = _table;
            this.setHorizontalAlignment(4);
            this.setOpaque(true);
            this.setForeground(Color.BLACK);
            this.setBackground(PANEL_BACKGROUND);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 0) {
                this.setBackground(PANEL_BACKGROUND);
            }
            this.setText(value.toString());
            return this;
        }
    }
}

