/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display2d.GridData;

public class GridPointData
implements GridData {
    protected double[][][] data;
    protected double left;
    protected double right;
    protected double bottom;
    protected double top;
    protected double dx = 0.0;
    protected double dy = 0.0;
    protected boolean cellData = false;
    protected String[] names;

    public GridPointData(int ix, int iy, int ncomponents) {
        if (iy < 1 || ix < 1) {
            throw new IllegalArgumentException("Number of dataset rows and columns must be positive. Your row=" + iy + "  col=" + ix);
        }
        if (ncomponents < 1) {
            throw new IllegalArgumentException("Number of 2d data components must be positive. Your ncomponents=" + ncomponents);
        }
        this.data = new double[ix][iy][ncomponents + 2];
        this.setScale(0.0, ix, 0.0, iy);
        this.names = new String[ncomponents];
        for (int i = 0; i < ncomponents; ++i) {
            this.names[i] = "Component_" + i;
        }
    }

    public GridPointData createGridPointData(int ncomponents) {
        GridPointData data2d = new GridPointData(this.data.length, this.data[0].length, ncomponents + 2);
        data2d.setScale(this.left, this.right, this.bottom, this.top);
        return data2d;
    }

    public void setComponentName(int i, String name) {
        this.names[i] = name;
    }

    public String getComponentName(int i) {
        return this.names[i];
    }

    public int getComponentCount() {
        return this.data[0][0].length - 2;
    }

    public void setScale(double _left, double _right, double _bottom, double _top) {
        this.cellData = false;
        this.left = _left;
        this.right = _right;
        this.bottom = _bottom;
        this.top = _top;
        int ix = this.data.length;
        int iy = this.data[0].length;
        this.dx = 0.0;
        if (ix > 1) {
            this.dx = (this.right - this.left) / (double)(ix - 1);
        }
        this.dy = 0.0;
        if (iy > 1) {
            this.dy = (this.bottom - this.top) / (double)(iy - 1);
        }
        double x = this.left;
        for (int i = 0; i < ix; ++i) {
            double y = this.top;
            for (int j = 0; j < iy; ++j) {
                this.data[i][j][0] = x;
                this.data[i][j][1] = y;
                y += this.dy;
            }
            x += this.dx;
        }
    }

    public void setCellScale(double _left, double _right, double _bottom, double _top) {
        this.cellData = true;
        int nx = this.data.length;
        int ny = this.data[0].length;
        this.dx = 0.0;
        if (nx > 1) {
            this.dx = (_right - _left) / (double)nx;
        }
        this.dy = 0.0;
        if (ny > 1) {
            this.dy = (_bottom - _top) / (double)ny;
        }
        double x = _left + this.dx / 2.0;
        for (int i = 0; i < nx; ++i) {
            double y = _top + this.dy / 2.0;
            for (int j = 0; j < ny; ++j) {
                this.data[i][j][0] = x;
                this.data[i][j][1] = y;
                y += this.dy;
            }
            x += this.dx;
        }
        this.left = _left + this.dx / 2.0;
        this.right = _right - this.dx / 2.0;
        this.bottom = _bottom - this.dy / 2.0;
        this.top = _top + this.dy / 2.0;
    }

    public void setCenteredCellScale(double xmin, double xmax, double ymin, double ymax) {
        int nx = this.data.length;
        int ny = this.data[0].length;
        double delta = nx > 1 ? (xmax - xmin) / (double)(nx - 1) / 2.0 : 0.0;
        xmin -= delta;
        xmax += delta;
        delta = ny > 1 ? (ymax - ymin) / (double)(ny - 1) / 2.0 : 0.0;
        this.setCellScale(xmin, xmax, ymin -= delta, ymax += delta);
    }

    public boolean isCellData() {
        return this.cellData;
    }

    public double getValue(int ix, int iy, int component) {
        return this.data[ix][iy][component + 2];
    }

    public void setValue(int ix, int iy, int component, double value) {
        this.data[ix][iy][component + 2] = value;
    }

    public int getNx() {
        return this.data.length;
    }

    public int getNy() {
        return this.data[0].length;
    }

    public double[] getZRange(int n) {
        double zmin;
        int index = 2 + n;
        double zmax = zmin = this.data[0][0][index];
        int mx = this.data.length;
        for (int i = 0; i < mx; ++i) {
            int my = this.data[0].length;
            for (int j = 0; j < my; ++j) {
                double v = this.data[i][j][index];
                if (v > zmax) {
                    zmax = v;
                }
                if (!(v < zmin)) continue;
                zmin = v;
            }
        }
        return new double[]{zmin, zmax};
    }

    public double[] getVertex(double x, double y) {
        int nx = (int)Math.floor((x - this.left) / this.dx);
        nx = Math.max(0, nx);
        nx = Math.min(nx, this.data.length - 1);
        int ny = (int)Math.floor(-(this.top - y) / this.dy);
        ny = Math.max(0, ny);
        ny = Math.min(ny, this.data[0].length - 1);
        return this.data[nx][ny];
    }

    public double interpolate(double x, double y, int index) {
        int ix = (int)((x - this.data[0][0][0]) / this.dx);
        ix = Math.max(0, ix);
        ix = Math.min(this.data.length - 2, ix);
        int iy = (int)((y - this.data[0][0][1]) / this.dy);
        iy = Math.max(0, iy);
        iy = Math.min(this.data[0].length - 2, iy);
        double t = (x - this.data[ix][iy][0]) / this.dx;
        double u = (y - this.data[ix][iy][1]) / this.dy;
        return (1.0 - t) * (1.0 - u) * this.data[ix][iy][index += 2] + t * (1.0 - u) * this.data[ix + 1][iy][index] + t * u * this.data[ix + 1][iy + 1][index] + (1.0 - t) * u * this.data[ix][iy + 1][index];
    }

    public double[] interpolate(double x, double y, int[] indexes, double[] values) {
        int ix = (int)((x - this.data[0][0][0]) / this.dx);
        ix = Math.max(0, ix);
        ix = Math.min(this.data.length - 2, ix);
        int iy = (int)((y - this.data[0][0][1]) / this.dy);
        iy = Math.max(0, iy);
        iy = Math.min(this.data[0].length - 2, iy);
        double t = (x - this.data[ix][iy][0]) / this.dx;
        double u = (y - this.data[ix][iy][1]) / this.dy;
        int n = indexes.length;
        for (int i = 0; i < n; ++i) {
            int index = indexes[i] + 2;
            values[i] = (1.0 - t) * (1.0 - u) * this.data[ix][iy][index] + t * (1.0 - u) * this.data[ix + 1][iy][index] + t * u * this.data[ix + 1][iy + 1][index] + (1.0 - t) * u * this.data[ix][iy + 1][index];
        }
        return values;
    }

    public double[][][] getData() {
        return this.data;
    }

    public void setData(double[][][] newdata) {
        this.data = newdata;
        int nx = this.data.length - 1;
        int ny = this.data[0].length - 1;
        this.left = this.data[0][0][0];
        this.right = this.data[nx][ny][0];
        this.top = this.data[0][0][1];
        this.bottom = this.data[nx][ny][1];
        this.dx = (this.right - this.left) / (double)nx;
        this.dy = (this.bottom - this.top) / (double)ny;
        this.cellData = false;
    }

    public final double getLeft() {
        return this.left;
    }

    public final double getRight() {
        return this.right;
    }

    public final double getTop() {
        return this.top;
    }

    public final double getBottom() {
        return this.bottom;
    }

    public final double getDx() {
        return this.dx;
    }

    public final double getDy() {
        return this.dy;
    }

    public double indexToX(int i) {
        return this.data == null ? Double.NaN : this.data[i][0][0];
    }

    public double indexToY(int i) {
        return this.data == null ? Double.NaN : this.data[0][i][1];
    }

    public int xToIndex(double x) {
        if (this.data == null) {
            return 0;
        }
        int nx = this.getNx();
        double dx = (this.right - this.left) / (double)nx;
        int i = (int)((x - this.left) / dx);
        if (i < 0) {
            return 0;
        }
        if (i >= nx) {
            return nx - 1;
        }
        return i;
    }

    public int yToIndex(double y) {
        if (this.data == null) {
            return 0;
        }
        int ny = this.getNy();
        double dy = (this.top - this.bottom) / (double)ny;
        int i = (int)((this.top - y) / dy);
        if (i < 0) {
            return 0;
        }
        if (i >= ny) {
            return ny - 1;
        }
        return i;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            GridPointData gpd = (GridPointData)obj;
            control.setValue("left", gpd.left);
            control.setValue("right", gpd.right);
            control.setValue("bottom", gpd.bottom);
            control.setValue("top", gpd.top);
            control.setValue("dx", gpd.dx);
            control.setValue("dy", gpd.dy);
            control.setValue("is cell data", gpd.cellData);
            control.setValue("data", gpd.data);
        }

        public Object createObject(XMLControl control) {
            return new GridPointData(1, 1, 1);
        }

        public Object loadObject(XMLControl control, Object obj) {
            GridPointData gpd = (GridPointData)obj;
            double[][][] data = (double[][][])control.getObject("data");
            gpd.data = data;
            gpd.left = control.getDouble("left");
            gpd.right = control.getDouble("right");
            gpd.bottom = control.getDouble("bottom");
            gpd.top = control.getDouble("top");
            gpd.dx = control.getDouble("dx");
            gpd.dy = control.getDouble("dy");
            gpd.cellData = control.getBoolean("is cell data");
            return obj;
        }
    }
}

