/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.core;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.Style;
import org.opensourcephysics.display3d.core.interaction.InteractionSource;
import org.opensourcephysics.numerics.Transformation;

public interface Element
extends InteractionSource {
    public static final int TARGET_POSITION = 0;
    public static final int TARGET_SIZE = 1;

    public void setName(String var1);

    public String getName();

    public void setX(double var1);

    public double getX();

    public void setY(double var1);

    public double getY();

    public void setZ(double var1);

    public double getZ();

    public void setXYZ(double var1, double var3, double var5);

    public void setXYZ(double[] var1);

    public void setSizeX(double var1);

    public double getSizeX();

    public void setSizeY(double var1);

    public double getSizeY();

    public void setSizeZ(double var1);

    public double getSizeZ();

    public void setSizeXYZ(double var1, double var3, double var5);

    public void setSizeXYZ(double[] var1);

    public void setVisible(boolean var1);

    public boolean isVisible();

    public Style getStyle();

    public void setTransformation(Transformation var1);

    public Transformation getTransformation();

    public double[] toSpaceFrame(double[] var1);

    public double[] toBodyFrame(double[] var1) throws UnsupportedOperationException;

    public void loadUnmutableObjects(XMLControl var1);

    public static abstract class Loader
    implements XML.ObjectLoader {
        public abstract Object createObject(XMLControl var1);

        public void saveObject(XMLControl control, Object obj) {
            Element element = (Element)obj;
            if (element.getName().length() > 0) {
                control.setValue("name", element.getName());
            }
            control.setValue("x", element.getX());
            control.setValue("y", element.getY());
            control.setValue("z", element.getZ());
            control.setValue("x size", element.getSizeX());
            control.setValue("y size", element.getSizeY());
            control.setValue("z size", element.getSizeZ());
            control.setValue("visible", element.isVisible());
            control.setValue("style", element.getStyle());
            control.setValue("transformation", element.getTransformation());
        }

        public Object loadObject(XMLControl control, Object obj) {
            Element element = (Element)obj;
            String name = control.getString("name");
            if (name != null) {
                element.setName(name);
            }
            element.setXYZ(control.getDouble("x"), control.getDouble("y"), control.getDouble("z"));
            element.setSizeXYZ(control.getDouble("x size"), control.getDouble("y size"), control.getDouble("z size"));
            element.setVisible(control.getBoolean("visible"));
            element.setTransformation((Transformation)control.getObject("transformation"));
            element.loadUnmutableObjects(control);
            return obj;
        }
    }
}

