/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Graphics2D;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.interaction.InteractionEvent;
import org.opensourcephysics.display3d.core.interaction.InteractionListener;
import org.opensourcephysics.display3d.simple3d.DrawingPanel3D;
import org.opensourcephysics.display3d.simple3d.Group;
import org.opensourcephysics.display3d.simple3d.InteractionTarget;
import org.opensourcephysics.display3d.simple3d.Object3D;
import org.opensourcephysics.display3d.simple3d.Style;
import org.opensourcephysics.numerics.Transformation;

public abstract class Element
implements org.opensourcephysics.display3d.core.Element {
    static final int SENSIBILITY = 5;
    private boolean visible = true;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private double sizeX = 1.0;
    private double sizeY = 1.0;
    private double sizeZ = 1.0;
    private String name = "";
    private Transformation transformation = null;
    private Style style = new Style(this);
    private Group group = null;
    private boolean elementChanged = true;
    private boolean needsToProject = true;
    private DrawingPanel3D panel;
    private ArrayList listeners = new ArrayList();
    protected final InteractionTarget targetPosition = new InteractionTarget(this, 0);
    protected final InteractionTarget targetSize = new InteractionTarget(this, 1);

    final DrawingPanel3D getPanel() {
        Element el = this;
        while (el.group != null) {
            el = el.group;
        }
        return el.panel;
    }

    void setPanel(DrawingPanel3D _panel) {
        this.panel = _panel;
        this.elementChanged = true;
    }

    final Group getGroup() {
        return this.group;
    }

    final Group getTopGroup() {
        Group gr = this.group;
        if (gr == null) {
            return null;
        }
        while (gr.getGroup() != null) {
            gr = gr.getGroup();
        }
        return gr;
    }

    void setGroup(Group _group) {
        this.group = _group;
        this.elementChanged = true;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public final String getName() {
        return this.name;
    }

    public void setX(double x) {
        this.x = x;
        this.elementChanged = true;
    }

    public final double getX() {
        return this.x;
    }

    public void setY(double y) {
        this.y = y;
        this.elementChanged = true;
    }

    public final double getY() {
        return this.y;
    }

    public void setZ(double z) {
        this.z = z;
        this.elementChanged = true;
    }

    public final double getZ() {
        return this.z;
    }

    public void setXYZ(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.elementChanged = true;
    }

    public void setXYZ(double[] pos) {
        this.x = pos[0];
        this.y = pos[1];
        if (pos.length > 2) {
            this.z = pos[2];
        }
        this.elementChanged = true;
    }

    void getExtrema(double[] min, double[] max) {
        min[0] = -0.5;
        max[0] = 0.5;
        min[1] = -0.5;
        max[1] = 0.5;
        min[2] = -0.5;
        max[2] = 0.5;
        this.sizeAndToSpaceFrame(min);
        this.sizeAndToSpaceFrame(max);
    }

    public void setSizeX(double sizeX) {
        this.sizeX = sizeX;
        this.elementChanged = true;
    }

    public final double getSizeX() {
        return this.sizeX;
    }

    public void setSizeY(double sizeY) {
        this.sizeY = sizeY;
        this.elementChanged = true;
    }

    public final double getSizeY() {
        return this.sizeY;
    }

    public void setSizeZ(double sizeZ) {
        this.sizeZ = sizeZ;
        this.elementChanged = true;
    }

    public final double getSizeZ() {
        return this.sizeZ;
    }

    public void setSizeXYZ(double sizeX, double sizeY, double sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.elementChanged = true;
    }

    public void setSizeXYZ(double[] size) {
        this.sizeX = size[0];
        this.sizeY = size[1];
        if (size.length > 2) {
            this.sizeZ = size[2];
        }
        this.elementChanged = true;
    }

    final double getDiagonalSize() {
        return Math.sqrt(this.sizeX * this.sizeX + this.sizeY * this.sizeY + this.sizeZ * this.sizeZ);
    }

    final boolean hasChanged() {
        Element el = this;
        while (el != null) {
            if (el.elementChanged) {
                return true;
            }
            el = el.group;
        }
        return false;
    }

    boolean getElementChanged() {
        return this.elementChanged;
    }

    final void setElementChanged(boolean change) {
        this.elementChanged = change;
    }

    public void setVisible(boolean _visible) {
        this.visible = _visible;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    protected final boolean isReallyVisible() {
        Group el = this.group;
        while (el != null) {
            if (!el.visible) {
                return false;
            }
            el = el.group;
        }
        return this.visible;
    }

    public final org.opensourcephysics.display3d.core.Style getStyle() {
        return this.style;
    }

    final Style getRealStyle() {
        return this.style;
    }

    final void styleChanged(int styleThatChanged) {
        this.elementChanged = true;
    }

    public Transformation getTransformation() {
        if (this.transformation == null) {
            return null;
        }
        return (Transformation)this.transformation.clone();
    }

    public void setTransformation(Transformation transformation) {
        this.transformation = transformation == null ? null : (Transformation)transformation.clone();
        this.elementChanged = true;
    }

    public double[] toSpaceFrame(double[] vector) {
        if (this.transformation != null) {
            this.transformation.direct(vector);
        }
        vector[0] = vector[0] + this.x;
        vector[1] = vector[1] + this.y;
        vector[2] = vector[2] + this.z;
        Group el = this.group;
        while (el != null) {
            vector[0] = vector[0] * el.sizeX;
            vector[1] = vector[1] * el.sizeY;
            vector[2] = vector[2] * el.sizeZ;
            if (el.transformation != null) {
                el.transformation.direct(vector);
            }
            vector[0] = vector[0] + el.x;
            vector[1] = vector[1] + el.y;
            vector[2] = vector[2] + el.z;
            el = el.group;
        }
        return vector;
    }

    public double[] toBodyFrame(double[] vector) throws UnsupportedOperationException {
        ArrayList<Element> elList = new ArrayList<Element>();
        Element el = this;
        do {
            elList.add(el);
        } while ((el = el.group) != null);
        for (int i = elList.size() - 1; i >= 0; --i) {
            el = (Element)elList.get(i);
            vector[0] = vector[0] - el.x;
            vector[1] = vector[1] - el.y;
            vector[2] = vector[2] - el.z;
            if (el.transformation != null) {
                el.transformation.inverse(vector);
            }
            if (el == this) continue;
            if (el.sizeX != 0.0) {
                vector[0] = vector[0] / el.sizeX;
            }
            if (el.sizeY != 0.0) {
                vector[1] = vector[1] / el.sizeY;
            }
            if (el.sizeZ == 0.0) continue;
            vector[2] = vector[2] / el.sizeZ;
        }
        return vector;
    }

    final void sizeAndToSpaceFrame(double[] vector) {
        vector[0] = vector[0] * this.sizeX;
        vector[1] = vector[1] * this.sizeY;
        vector[2] = vector[2] * this.sizeZ;
        this.toSpaceFrame(vector);
    }

    abstract Object3D[] getObjects3D();

    abstract void draw(Graphics2D var1, int var2);

    abstract void drawQuickly(Graphics2D var1);

    void setNeedToProject(boolean _need) {
        this.needsToProject = _need;
    }

    final boolean needsToProject() {
        return this.needsToProject;
    }

    public org.opensourcephysics.display3d.core.interaction.InteractionTarget getInteractionTarget(int target) {
        switch (target) {
            case 0: {
                return this.targetPosition;
            }
            case 1: {
                return this.targetSize;
            }
        }
        return null;
    }

    public void addInteractionListener(InteractionListener listener) {
        if (listener == null || this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeInteractionListener(InteractionListener listener) {
        ((AbstractCollection)this.listeners).remove(listener);
    }

    final void invokeActions(InteractionEvent event) {
        Iterator it = ((AbstractList)this.listeners).iterator();
        while (it.hasNext()) {
            ((InteractionListener)it.next()).interactionPerformed(event);
        }
    }

    protected InteractionTarget getTargetHit(int x, int y) {
        return null;
    }

    protected double[] getHotSpotBodyCoordinates(InteractionTarget target) {
        if (target == this.targetPosition) {
            return new double[]{0.0, 0.0, 0.0};
        }
        if (target == this.targetSize) {
            double[] c = new double[]{1.0, 1.0, 1.0};
            if (this.sizeX == 0.0) {
                c[0] = 0.0;
            }
            if (this.sizeY == 0.0) {
                c[1] = 0.0;
            }
            if (this.sizeZ == 0.0) {
                c[2] = 0.0;
            }
            return c;
        }
        return null;
    }

    final double[] getHotSpot(InteractionTarget target) {
        double[] coordinates = this.getHotSpotBodyCoordinates(target);
        if (coordinates != null) {
            this.sizeAndToSpaceFrame(coordinates);
        }
        return coordinates;
    }

    final void updateHotSpot(InteractionTarget target, double[] point) {
        Group gr = this.getTopGroup();
        switch (target.getType()) {
            case 0: {
                if (target.getAffectsGroup() && gr != null) {
                    double[] origin = this.getHotSpot(target);
                    gr.setXYZ(gr.x + point[0] - origin[0], gr.y + point[1] - origin[1], gr.z + point[2] - origin[2]);
                    break;
                }
                double[] coordinates = new double[]{point[0], point[1], point[2]};
                this.groupInverseTransformations(coordinates);
                double[] origin = this.getHotSpotBodyCoordinates(target);
                origin[0] = origin[0] * this.sizeX;
                origin[1] = origin[1] * this.sizeY;
                origin[2] = origin[2] * this.sizeZ;
                if (this.transformation != null) {
                    this.transformation.direct(origin);
                }
                this.setXYZ(coordinates[0] - origin[0], coordinates[1] - origin[1], coordinates[2] - origin[2]);
                break;
            }
            case 1: {
                if (target.getAffectsGroup() && gr != null) {
                    double[] coordinates = new double[]{point[0], point[1], point[2]};
                    coordinates[0] = coordinates[0] - gr.x;
                    coordinates[1] = coordinates[1] - gr.y;
                    coordinates[2] = coordinates[2] - gr.z;
                    if (gr.transformation != null) {
                        gr.transformation.inverse(coordinates);
                    }
                    double[] origin = this.getHotSpotBodyCoordinates(target);
                    this.elementDirectTransformations(origin);
                    coordinates[0] = origin[0] != 0.0 ? coordinates[0] / origin[0] : gr.sizeX;
                    coordinates[1] = origin[1] != 0.0 ? coordinates[1] / origin[1] : gr.sizeY;
                    coordinates[2] = origin[2] != 0.0 ? coordinates[2] / origin[2] : gr.sizeZ;
                    gr.setSizeXYZ(coordinates);
                    break;
                }
                double[] coordinates = new double[]{point[0], point[1], point[2]};
                this.groupInverseTransformations(coordinates);
                coordinates[0] = coordinates[0] - this.x;
                coordinates[1] = coordinates[1] - this.y;
                coordinates[2] = coordinates[2] - this.z;
                if (this.transformation != null) {
                    this.transformation.inverse(coordinates);
                }
                double[] origin = this.getHotSpotBodyCoordinates(target);
                for (int i = 0; i < 3; ++i) {
                    if (origin[i] == 0.0) continue;
                    int n = i;
                    coordinates[n] = coordinates[n] / origin[i];
                }
                this.setSizeXYZ(coordinates);
            }
        }
    }

    private final void groupInverseTransformations(double[] vector) throws UnsupportedOperationException {
        ArrayList<Group> elList = new ArrayList<Group>();
        Element el = this.group;
        while (el != null) {
            elList.add((Group)el);
            el = el.group;
        }
        for (int i = elList.size() - 1; i >= 0; --i) {
            el = (Element)elList.get(i);
            vector[0] = vector[0] - el.x;
            vector[1] = vector[1] - el.y;
            vector[2] = vector[2] - el.z;
            if (el.transformation != null) {
                el.transformation.inverse(vector);
            }
            if (el.sizeX != 0.0) {
                vector[0] = vector[0] / el.sizeX;
            }
            if (el.sizeY != 0.0) {
                vector[1] = vector[1] / el.sizeY;
            }
            if (el.sizeZ == 0.0) continue;
            vector[2] = vector[2] / el.sizeZ;
        }
    }

    private final void elementDirectTransformations(double[] vector) {
        Element el = this;
        do {
            if (el.sizeX != 0.0) {
                vector[0] = vector[0] * el.sizeX;
            }
            if (el.sizeY != 0.0) {
                vector[1] = vector[1] * el.sizeY;
            }
            if (el.sizeZ != 0.0) {
                vector[2] = vector[2] * el.sizeZ;
            }
            if (el.transformation != null) {
                el.transformation.direct(vector);
            }
            vector[0] = vector[0] + el.x;
            vector[1] = vector[1] + el.y;
            vector[2] = vector[2] + el.z;
        } while ((el = el.group) != null && el.group != null);
    }

    public void loadUnmutableObjects(XMLControl control) {
        this.style = (Style)control.getObject("style");
        this.style.setElement(this);
        this.elementChanged = true;
    }
}

