/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.Element;
import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.simple3d.AbstractTile;

public class ElementPlane
extends AbstractTile
implements org.opensourcephysics.display3d.core.ElementPlane {
    private double[] vectorU = new double[]{1.0, 0.0, 0.0};
    private double[] vectorV = new double[]{0.0, 1.0, 0.0};
    private int nu = -1;
    private int nv = -1;
    private double vectorUSize = 1.0;
    private double vectorVSize = 1.0;

    public ElementPlane() {
        this.setXYZ(0.0, 0.0, 0.0);
        this.setSizeXYZ(1.0, 1.0, 1.0);
    }

    public void setFirstDirection(double[] vector) {
        this.vectorU[0] = vector[0];
        this.vectorU[1] = vector[1];
        this.vectorU[2] = vector[2];
        this.vectorUSize = Math.sqrt(this.vectorU[0] * this.vectorU[0] + this.vectorU[1] * this.vectorU[1] + this.vectorU[2] * this.vectorU[2]);
        this.setElementChanged(true);
    }

    public double[] getFirstDirection() {
        return new double[]{this.vectorU[0], this.vectorU[1], this.vectorU[2]};
    }

    public void setSecondDirection(double[] vector) {
        this.vectorV[0] = vector[0];
        this.vectorV[1] = vector[1];
        this.vectorV[2] = vector[2];
        this.vectorVSize = Math.sqrt(this.vectorV[0] * this.vectorV[0] + this.vectorV[1] * this.vectorV[1] + this.vectorV[2] * this.vectorV[2]);
        this.setElementChanged(true);
    }

    public double[] getSecondDirection() {
        return new double[]{this.vectorU[0], this.vectorU[1], this.vectorU[2]};
    }

    protected synchronized void computeCorners() {
        int i;
        int theNu = 1;
        int theNv = 1;
        Resolution res = this.getRealStyle().getResolution();
        if (res != null) {
            switch (res.getType()) {
                case 0: {
                    theNu = Math.max(res.getN1(), 1);
                    theNv = Math.max(res.getN2(), 1);
                    break;
                }
                case 1: {
                    theNu = Math.max((int)Math.round(0.49 + Math.abs(this.getSizeX()) * this.vectorUSize / res.getMaxLength()), 1);
                    theNv = Math.max((int)Math.round(0.49 + Math.abs(this.getSizeY()) * this.vectorVSize / res.getMaxLength()), 1);
                }
            }
        }
        if (this.nu != theNu || this.nv != theNv) {
            this.nu = theNu;
            this.nv = theNv;
            this.setCorners(new double[this.nu * this.nv][4][3]);
        }
        int tile = 0;
        double du = this.getSizeX() / (double)this.nu;
        double dv = this.getSizeY() / (double)this.nv;
        for (i = 0; i < this.nu; ++i) {
            double u = (double)i * du - this.getSizeX() / 2.0;
            for (int j = 0; j < this.nv; ++j) {
                int k;
                double v = (double)j * dv - this.getSizeY() / 2.0;
                for (k = 0; k < 3; ++k) {
                    this.corners[tile][0][k] = u * this.vectorU[k] + v * this.vectorV[k];
                }
                for (k = 0; k < 3; ++k) {
                    this.corners[tile][1][k] = (u + du) * this.vectorU[k] + v * this.vectorV[k];
                }
                for (k = 0; k < 3; ++k) {
                    this.corners[tile][2][k] = (u + du) * this.vectorU[k] + (v + dv) * this.vectorV[k];
                }
                for (k = 0; k < 3; ++k) {
                    this.corners[tile][3][k] = u * this.vectorU[k] + (v + dv) * this.vectorV[k];
                }
                ++tile;
            }
        }
        for (i = 0; i < this.numberOfTiles; ++i) {
            int sides = this.corners[i].length;
            for (int j = 0; j < sides; ++j) {
                this.toSpaceFrame(this.corners[i][j]);
            }
        }
        this.setElementChanged(false);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends Element.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl control) {
            return new ElementPlane();
        }
    }
}

