/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.Element;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.Object3D;

public class ElementPolygon
extends Element
implements org.opensourcephysics.display3d.core.ElementPolygon {
    private boolean closed = true;
    private double[][] coordinates = new double[0][0];
    private int[] aPoints = null;
    private int[] bPoints = null;
    private double[][] transformedCoordinates = new double[0][0];
    private double[] center = new double[3];
    private double[] pixel = new double[3];
    protected Object3D[] lineObjects = null;
    protected Object3D[] closedObject = new Object3D[]{new Object3D(this, -1)};

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setData(double[][] data) {
        if (this.coordinates.length != data.length) {
            int n = data.length;
            this.coordinates = new double[n][3];
            this.transformedCoordinates = new double[n][3];
            this.aPoints = new int[n];
            this.bPoints = new int[n];
            this.lineObjects = new Object3D[n];
            for (int i = 0; i < n; ++i) {
                this.lineObjects[i] = new Object3D(this, i);
            }
        }
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(data[i], 0, this.coordinates[i], 0, 3);
        }
        this.setElementChanged(true);
    }

    public double[][] getData() {
        double[][] data = new double[this.coordinates.length][3];
        int n = this.coordinates.length;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(this.coordinates[i], 0, data[i], 0, 3);
        }
        return data;
    }

    public void getExtrema(double[] min, double[] max) {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        double[] aPoint = new double[3];
        int n = this.coordinates.length;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(this.coordinates[i], 0, aPoint, 0, 3);
            this.sizeAndToSpaceFrame(aPoint);
            minX = Math.min(minX, aPoint[0]);
            maxX = Math.max(maxX, aPoint[0]);
            minY = Math.min(minY, aPoint[1]);
            maxY = Math.max(maxY, aPoint[1]);
            minZ = Math.min(minZ, aPoint[2]);
            maxZ = Math.max(maxZ, aPoint[2]);
        }
        min[0] = minX;
        max[0] = maxX;
        min[1] = minY;
        max[1] = maxY;
        min[2] = minZ;
        max[2] = maxZ;
    }

    Object3D[] getObjects3D() {
        if (!this.isReallyVisible() || this.coordinates.length == 0) {
            return null;
        }
        if (this.hasChanged()) {
            this.transformAndProject();
        } else if (this.needsToProject()) {
            this.project();
        }
        if (this.closed && this.getRealStyle().isDrawingFill()) {
            return this.closedObject;
        }
        return this.lineObjects;
    }

    void draw(Graphics2D _g2, int _index) {
        if (_index < 0) {
            Color theFillColor = this.getPanel().projectColor(this.getRealStyle().getFillColor(), this.closedObject[0].getDistance());
            _g2.setPaint(theFillColor);
            _g2.fillPolygon(this.aPoints, this.bPoints, this.aPoints.length);
            if (this.getRealStyle().isDrawingLines()) {
                Color theColor = this.getPanel().projectColor(this.getRealStyle().getLineColor(), this.closedObject[0].getDistance());
                _g2.setStroke(this.getRealStyle().getLineStroke());
                _g2.setColor(theColor);
                int n = this.aPoints.length - 1;
                for (int i = 0; i < n; ++i) {
                    _g2.drawLine(this.aPoints[i], this.bPoints[i], this.aPoints[i + 1], this.bPoints[i + 1]);
                }
                _g2.drawLine(this.aPoints[n], this.bPoints[n], this.aPoints[0], this.bPoints[0]);
            }
            return;
        }
        if (!this.getRealStyle().isDrawingLines()) {
            return;
        }
        Color theColor = this.getPanel().projectColor(this.getRealStyle().getLineColor(), this.lineObjects[_index].getDistance());
        _g2.setStroke(this.getRealStyle().getLineStroke());
        _g2.setColor(theColor);
        int sides = this.aPoints.length - 1;
        if (_index < sides) {
            _g2.drawLine(this.aPoints[_index], this.bPoints[_index], this.aPoints[_index + 1], this.bPoints[_index + 1]);
        } else {
            _g2.drawLine(this.aPoints[sides], this.bPoints[sides], this.aPoints[0], this.bPoints[0]);
        }
    }

    void drawQuickly(Graphics2D _g2) {
        if (!this.isReallyVisible()) {
            return;
        }
        if (this.hasChanged()) {
            this.transformAndProject();
        } else if (this.needsToProject()) {
            this.project();
        }
        _g2.setStroke(this.getRealStyle().getLineStroke());
        _g2.setColor(this.getRealStyle().getLineColor());
        _g2.drawPolyline(this.aPoints, this.bPoints, this.aPoints.length);
        int sides = this.aPoints.length - 1;
        if (this.closed) {
            _g2.drawLine(this.aPoints[sides], this.bPoints[sides], this.aPoints[0], this.bPoints[0]);
        }
    }

    void transformAndProject() {
        this.center[2] = 0.0;
        this.center[1] = 0.0;
        this.center[0] = 0.0;
        int n = this.coordinates.length;
        for (int i = 0; i < n; ++i) {
            for (int k = 0; k < 3; ++k) {
                int n2 = k;
                this.center[n2] = this.center[n2] + this.coordinates[i][k];
                this.transformedCoordinates[i][k] = this.coordinates[i][k];
            }
            this.sizeAndToSpaceFrame(this.transformedCoordinates[i]);
            this.getPanel().project(this.transformedCoordinates[i], this.pixel);
            this.aPoints[i] = (int)this.pixel[0];
            this.bPoints[i] = (int)this.pixel[1];
            this.lineObjects[i].setDistance(this.pixel[2]);
        }
        if (!this.closed) {
            this.lineObjects[this.coordinates.length - 1].setDistance(Double.NaN);
        }
        int k = 0;
        while (k < 3) {
            int n3 = k++;
            this.center[n3] = this.center[n3] / (double)this.coordinates.length;
        }
        if (this.closed && this.getRealStyle().isDrawingFill()) {
            this.getPanel().project(this.center, this.pixel);
            this.closedObject[0].setDistance(this.pixel[2]);
        } else {
            this.closedObject[0].setDistance(Double.NaN);
        }
        this.setElementChanged(false);
        this.setNeedToProject(false);
    }

    void project() {
        int n = this.coordinates.length;
        for (int i = 0; i < n; ++i) {
            this.getPanel().project(this.transformedCoordinates[i], this.pixel);
            this.aPoints[i] = (int)this.pixel[0];
            this.bPoints[i] = (int)this.pixel[1];
            this.lineObjects[i].setDistance(this.pixel[2]);
        }
        if (!this.closed) {
            this.lineObjects[this.coordinates.length - 1].setDistance(Double.NaN);
        }
        if (this.closed && this.getRealStyle().isDrawingFill()) {
            this.getPanel().project(this.center, this.pixel);
            this.closedObject[0].setDistance(this.pixel[2]);
        } else {
            this.closedObject[0].setDistance(Double.NaN);
        }
        this.setNeedToProject(false);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends Element.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl control) {
            return new ElementPolygon();
        }
    }
}

